/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.core.vdb.ModelType;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.model.BasicMetadataObject;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.vdb.runtime.URIResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BasicModel
extends BasicMetadataObject
implements Model {
    private static final URIResource uriresource = new URIResource();
    private String description;
    private boolean isPhysical;
    private boolean isVisible = true;
    private boolean multiSourceBindingEnabled;
    private Set bindingNames = null;
    private Date versionDate;
    private String versionedBy;
    private String GUID;
    private boolean requireConnBinding;
    private int modelType = 4;
    private String uri;

    public BasicModel(BasicModelID modelID, BasicVirtualDatabaseID virtualDBID) {
        super(modelID, virtualDBID);
    }

    public BasicModel(BasicModelID modelID, BasicVirtualDatabaseID virtualDBID, ModelInfo mInfo) {
        super(modelID, virtualDBID);
        this.setIsVisible(mInfo.isVisible());
        this.setModelURI(mInfo.getModelURI());
        this.setConnectorBindingNames(mInfo.getConnectorBindingNames());
        this.setVersionedBy(mInfo.getVersionedBy());
        this.setVersionDate(mInfo.getDateVersioned());
        this.setModelType(mInfo.getModelType());
        this.setDescription(mInfo.getDescription());
        this.enableMutliSourceBindings(mInfo.isMultiSourceBindingEnabled());
        if (mInfo.getUUID() != null) {
            this.setGUID(mInfo.getUUID());
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysical;
    }

    @Override
    public String getVersion() {
        return ((ModelID)this.getID()).getVersion();
    }

    @Override
    public boolean isVisible() {
        if (this.uri == null) {
            return false;
        }
        return this.isVisible;
    }

    @Override
    public boolean isMultiSourceBindingEnabled() {
        return this.multiSourceBindingEnabled;
    }

    @Override
    public boolean requireConnectorBinding() {
        return this.requireConnBinding;
    }

    @Override
    public String getGUID() {
        if (this.GUID == null) {
            return ((BasicModelID)this.getID()).getUuid();
        }
        return this.GUID;
    }

    @Override
    public List getConnectorBindingNames() {
        if (this.bindingNames == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList bindings = null;
        bindings = new ArrayList(this.bindingNames.size());
        bindings.addAll(this.bindingNames);
        return bindings;
    }

    @Override
    public boolean supportsMultiSourceBindings() {
        switch (this.modelType) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getModelType() {
        return this.modelType;
    }

    @Override
    public String getModelTypeName() {
        return ModelType.getString((int)this.modelType);
    }

    @Override
    public String getModelURI() {
        return this.uri;
    }

    @Override
    public Date getDateVersioned() {
        return this.versionDate;
    }

    @Override
    public String getVersionedBy() {
        return this.versionedBy;
    }

    @Override
    public boolean isMaterialization() {
        return this.modelType == 10;
    }

    @Override
    public short getVisibility() {
        if (this.isVisible()) {
            return 0;
        }
        return 2;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    private void setIsPhysical(boolean physical) {
        this.isPhysical = physical;
    }

    public void setGUID(String guid) {
        this.GUID = guid;
    }

    @Override
    public void enableMutliSourceBindings(boolean isEnabled) {
        this.multiSourceBindingEnabled = isEnabled;
    }

    public void addConnectorBindingName(String connectrBindingName) {
        if (this.bindingNames == null) {
            this.bindingNames = new HashSet();
        }
        this.bindingNames.add(connectrBindingName);
    }

    public void setConnectorBindingNames(Collection bindings) {
        this.bindingNames = new HashSet();
        this.bindingNames.addAll(bindings);
    }

    public void setModelType(int type) {
        this.modelType = type;
        this.setTypeLogic();
    }

    private void setTypeLogic() {
        if (this.modelType == 0 || this.modelType == 10) {
            this.setIsPhysical(true);
            if (this.uri != null) {
                if (uriresource.isPhysicalBindingAllowed(this.uri)) {
                    this.setRequireConnectorBinding(true);
                } else {
                    this.setRequireConnectorBinding(false);
                }
            } else {
                this.setRequireConnectorBinding(false);
            }
        } else {
            this.setIsPhysical(false);
            this.setRequireConnectorBinding(false);
        }
    }

    public void setVersionDate(Date date) {
        this.versionDate = date;
    }

    public void setVersionedBy(String versionedBy) {
        this.versionedBy = versionedBy;
    }

    public void setModelURI(String uri) {
        this.uri = uri;
        this.setTypeLogic();
    }

    public void setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setVisibility(short visibility) {
        if (visibility == 0) {
            this.setIsVisible(true);
        } else {
            this.setIsVisible(false);
        }
    }

    private void setRequireConnectorBinding(boolean requireConnBinding) {
        this.requireConnBinding = requireConnBinding;
    }

    @Override
    public String toString() {
        StringBuffer sw = new StringBuffer();
        sw.append("Model: " + this.getName());
        sw.append("\n\tVersion: " + this.getVersion());
        sw.append("\n\tType: " + this.getModelTypeName());
        sw.append("\n\thasBinding: " + (this.getConnectorBindingNames().size() > 0));
        sw.append("\n\tIsVisible: " + this.isVisible());
        sw.append("\n\tIsPhysical: " + this.isPhysical());
        sw.append("\n\tURI: " + this.getModelURI());
        sw.append("\n\tRequiresBinding: " + this.requireConnectorBinding());
        return sw.toString();
    }
}

