/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompositeIndexSelector
extends AbstractIndexSelector {
    private List indexSelectors;

    public CompositeIndexSelector(List indexSelectors) {
        this.indexSelectors = indexSelectors;
    }

    @Override
    public Index[] getIndexes() throws IOException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (IndexSelector indexSelector : this.indexSelectors) {
            if (indexSelector == null) continue;
            for (int i = 0; i < indexSelector.getIndexes().length; ++i) {
                indexes.add(indexSelector.getIndexes()[i]);
            }
        }
        return indexes.toArray(new Index[0]);
    }

    @Override
    public String[] getFilePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (IndexSelector indexSelector : this.indexSelectors) {
            if (indexSelector == null) continue;
            for (int i = 0; i < indexSelector.getFilePaths().length; ++i) {
                paths.add(indexSelector.getFilePaths()[i]);
            }
        }
        return paths.toArray(new String[0]);
    }

    @Override
    public List getFileContentsAsString(List paths) {
        ArgCheck.isNotEmpty((Collection)paths);
        for (IndexSelector selector : this.indexSelectors) {
            RuntimeIndexSelector runtimeSelector;
            List contents;
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContentsAsString(paths)).isEmpty()) continue;
            return contents;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public InputStream getFileContent(String path) {
        ArgCheck.isNotNull((Object)path);
        for (IndexSelector selector : this.indexSelectors) {
            RuntimeIndexSelector runtimeSelector;
            InputStream contents;
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContent(path)) == null) continue;
            return contents;
        }
        return null;
    }

    @Override
    public File getFile(String path) {
        ArgCheck.isNotNull((Object)path);
        for (IndexSelector selector : this.indexSelectors) {
            RuntimeIndexSelector runtimeSelector;
            File file;
            if (!(selector instanceof RuntimeIndexSelector) || (file = (runtimeSelector = (RuntimeIndexSelector)selector).getFile(path)) == null) continue;
            return file;
        }
        return null;
    }

    @Override
    public String getFileContentAsString(String path) {
        ArgCheck.isNotNull((Object)path);
        for (IndexSelector selector : this.indexSelectors) {
            RuntimeIndexSelector runtimeSelector;
            String contents;
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContentAsString(path)) == null) continue;
            return contents;
        }
        return null;
    }

    @Override
    public long getFileSize(String path) {
        ArgCheck.isNotNull((Object)path);
        for (IndexSelector selector : this.indexSelectors) {
            RuntimeIndexSelector runtimeSelector;
            long length;
            if (!(selector instanceof RuntimeIndexSelector) || (length = (runtimeSelector = (RuntimeIndexSelector)selector).getFileSize(path)) == 0L) continue;
            return length;
        }
        return 0L;
    }

    @Override
    public InputStream getFileContent(String path, String[] tokens, String[] tokenReplacements) {
        ArgCheck.isNotNull((Object)path);
        for (IndexSelector selector : this.indexSelectors) {
            RuntimeIndexSelector runtimeSelector;
            InputStream contents;
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContent(path, tokens, tokenReplacements)) == null) continue;
            return contents;
        }
        return null;
    }

    public List getIndexSelectors() {
        return this.indexSelectors;
    }
}

