/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.SimpleIndexUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RuntimeIndexSelector
extends AbstractIndexSelector {
    private static final Random random = new Random(System.currentTimeMillis());
    protected Index[] indexes;
    private Object indexesLock = new Object();
    protected File vdbFile;
    protected String indexDirectoryPath;
    private long fileSize;
    private TempDirectory tempDirectory;

    public RuntimeIndexSelector(String filePath) {
        ArgCheck.isNotNull((Object)filePath);
        this.vdbFile = new File(filePath);
        Assertion.assertTrue((boolean)this.vdbFile.exists(), (String)("No file/directory exists at the given location " + filePath));
        this.checkForValidFile();
    }

    public RuntimeIndexSelector(String vdbName, byte[] contents) throws IOException {
        ArgCheck.isNotNull((Object)vdbName);
        ArgCheck.isNotNull((Object)contents);
        try {
            this.save(vdbName, contents);
            this.checkForValidFile();
        }
        catch (IOException e) {
            this.clearVDB();
            throw e;
        }
    }

    private void checkForValidFile() {
        if (this.vdbFile.isFile()) {
            Assertion.assertTrue((boolean)this.checkValidType(this.vdbFile), (String)("Invalid file type, expected an archive file or an index file " + this.vdbFile));
        }
    }

    public RuntimeIndexSelector(String vdbName, InputStream contents) throws IOException {
        ArgCheck.isNotNull((Object)vdbName);
        ArgCheck.isNotNull((Object)contents);
        try {
            this.save(vdbName, contents);
            this.checkForValidFile();
        }
        catch (IOException e) {
            this.clearVDB();
            throw e;
        }
    }

    public RuntimeIndexSelector(URL vdbUrl) throws IOException {
        ArgCheck.isNotNull((Object)vdbUrl);
        try {
            this.save(vdbUrl);
            this.checkForValidFile();
        }
        catch (IOException e) {
            this.clearVDB();
            throw e;
        }
    }

    private void save(String vdbName, byte[] contents) throws IOException {
        String vdbFilePath = this.getIndexDirectoryPath() + '/' + vdbName;
        this.vdbFile = new File(vdbFilePath);
        FileUtils.write((byte[])contents, (File)this.vdbFile);
    }

    private void save(String vdbName, InputStream contents) throws IOException {
        String vdbFilePath = this.getIndexDirectoryPath() + '/' + vdbName;
        this.vdbFile = new File(vdbFilePath);
        FileUtils.write((InputStream)contents, (File)this.vdbFile);
        contents.close();
    }

    private void save(URL vdbUrl) throws IOException {
        String vdbPath = vdbUrl.getPath();
        int index = vdbPath.lastIndexOf(47);
        String vdbName = vdbPath.substring(index + 1);
        InputStream vdbStream = vdbUrl.openStream();
        String vdbFilePath = this.getIndexDirectoryPath() + '/' + vdbName;
        this.vdbFile = new File(vdbFilePath);
        FileUtils.write((InputStream)vdbStream, (File)this.vdbFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index[] getIndexes() throws IOException {
        if (this.indexes == null) {
            Object object = this.indexesLock;
            synchronized (object) {
                if (this.indexes == null) {
                    this.init();
                }
            }
        }
        return this.indexes;
    }

    public void clearVDB() {
        if (this.tempDirectory != null) {
            this.tempDirectory.remove();
            this.tempDirectory = null;
            this.indexDirectoryPath = null;
        }
        if (this.indexDirectoryPath != null) {
            File indexDirectory = new File(this.indexDirectoryPath);
            RuntimeIndexSelector.clear(indexDirectory);
            this.indexDirectoryPath = null;
        }
        this.setValid(false);
    }

    private static void clear(File file) {
        if (file.exists()) {
            File[] indexFiles;
            if (file.isDirectory() && (indexFiles = file.listFiles()) != null) {
                for (int i = 0; i < indexFiles.length; ++i) {
                    File indexFile = indexFiles[i];
                    RuntimeIndexSelector.clear(indexFile);
                }
            }
            if (!file.delete()) {
                RuntimeIndexSelector.clearOnExit(file);
            }
        }
    }

    private static void clearOnExit(File file) {
        if (file.exists()) {
            File[] indexFiles;
            if (file.isDirectory() && (indexFiles = file.listFiles()) != null) {
                for (int i = 0; i < indexFiles.length; ++i) {
                    File indexFile = indexFiles[i];
                    RuntimeIndexSelector.clearOnExit(indexFile);
                }
            }
            file.deleteOnExit();
        }
    }

    protected void init() throws IOException {
        this.indexes = this.isArchive(this.vdbFile) ? this.loadIndexesFromZip(this.vdbFile) : (this.vdbFile.isDirectory() ? this.loadIndexesFromFolder(this.vdbFile) : this.loadIndexesFromFile(this.vdbFile));
    }

    protected Index[] loadIndexesFromFile(File file) throws IOException {
        ArrayList<Index> tmp = new ArrayList<Index>();
        if (SimpleIndexUtil.indexFileExists(file.getAbsolutePath())) {
            tmp.add(new Index(file.getAbsolutePath(), true));
        }
        return tmp.toArray(new Index[tmp.size()]);
    }

    protected Index[] loadIndexesFromFolder(File folder) throws IOException {
        ArrayList<Index> tmp = new ArrayList<Index>();
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!SimpleIndexUtil.indexFileExists(files[i].getAbsolutePath())) continue;
            tmp.add(new Index(files[i].getAbsolutePath(), true));
        }
        return tmp.toArray(new Index[tmp.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Index[] loadIndexesFromZip(File zip) throws IOException {
        ZipFile zipFile = null;
        InputStream zipInputStream = null;
        try {
            zipFile = new ZipFile(zip);
            ArrayList<Index> tmp = new ArrayList<Index>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!this.shouldExtract(entry)) continue;
                zipInputStream = zipFile.getInputStream(entry);
                int length = entry.getSize() >= 0L ? (int)entry.getSize() : FileUtils.DEFAULT_BUFFER_SIZE;
                File entryFile = new File(this.getIndexDirectoryPath(), entry.getName());
                if (entryFile.isDirectory()) {
                    entryFile.mkdirs();
                } else {
                    FileUtils.write((InputStream)zipInputStream, (File)entryFile, (int)length);
                }
                if (!SimpleIndexUtil.indexFileExists(entryFile)) continue;
                tmp.add(new Index(entryFile.getAbsolutePath(), true));
            }
            Index[] indexArray = tmp.toArray(new Index[tmp.size()]);
            return indexArray;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    private boolean shouldExtract(ZipEntry entry) {
        return true;
    }

    @Override
    public String[] getFilePaths() {
        try {
            ZipFile zipFile = new ZipFile(this.vdbFile);
            ArrayList<String> filePaths = new ArrayList<String>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                char firstChar = entryName.charAt(0);
                if (firstChar != '/') {
                    entryName = '/' + entryName;
                }
                filePaths.add(entryName);
            }
            Collections.sort(filePaths);
            return filePaths.toArray(new String[filePaths.size()]);
        }
        catch (IOException e) {
            LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            return super.getFilePaths();
        }
    }

    @Override
    public List getFileContentsAsString(List paths) {
        ArgCheck.isNotEmpty((Collection)paths);
        ArrayList<String> contents = new ArrayList<String>(paths.size());
        for (String relativePath : paths) {
            String fileContent = this.getFileContentAsString(relativePath);
            if (fileContent == null) continue;
            contents.add(fileContent);
        }
        return contents;
    }

    @Override
    public InputStream getFileContent(String path) {
        ArgCheck.isNotNull((Object)path);
        File file = new File(this.getIndexDirectoryPath(), path);
        if (file.exists()) {
            this.fileSize = file.length();
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                LogManager.logWarning((String)"com.metamatrix.metadata.runtime", (Throwable)e, (String)e.getMessage());
            }
        }
        return null;
    }

    @Override
    public File getFile(String path) {
        ArgCheck.isNotNull((Object)path);
        File file = new File(this.getIndexDirectoryPath(), path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    public String getFileContentAsString(String path) {
        ArgCheck.isNotNull((Object)path);
        File file = new File(this.getIndexDirectoryPath(), path);
        if (file.exists()) {
            FileUtil fileUtil = new FileUtil(file.getPath());
            try {
                String fileContent = fileUtil.readSafe();
                this.fileSize = fileContent.length();
                return fileContent;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public InputStream getFileContent(String path, String[] tokens, String[] tokenReplacements) {
        ArgCheck.isNotNull((Object)tokens);
        ArgCheck.isNotNull((Object)tokenReplacements);
        Assertion.isEqual((int)tokens.length, (int)tokenReplacements.length);
        String fileContents = this.getFileContentAsString(path);
        if (fileContents != null) {
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                String tokenReplacement = tokenReplacements[i];
                fileContents = StringUtil.replaceAll((String)fileContents, (String)token, (String)tokenReplacement);
            }
            this.fileSize = fileContents.length();
            return new ByteArrayInputStream(fileContents.getBytes());
        }
        return null;
    }

    @Override
    public long getFileSize(String path) {
        return this.fileSize;
    }

    protected String getIndexDirectoryPath() {
        if (this.indexDirectoryPath == null) {
            this.tempDirectory = new TempDirectory(System.currentTimeMillis(), random.nextLong());
            this.tempDirectory.create();
            this.indexDirectoryPath = this.tempDirectory.getPath();
        }
        return this.indexDirectoryPath;
    }

    protected void setIndexDirectoryPath(String path) {
        this.indexDirectoryPath = path;
        this.tempDirectory = null;
    }

    protected boolean checkValidType(File file) {
        String fileName = file.getName();
        return this.isArchive(file) || SimpleIndexUtil.isIndexFile(fileName);
    }

    protected boolean isArchive(File file) {
        if (file != null && file.isFile() && file.exists()) {
            String fileName = file.getName();
            String fileExtension = FileUtils.getExtension((File)file);
            if ("vdb".equalsIgnoreCase(fileExtension) || FileUtils.isArchiveFileName((String)fileName)) {
                return true;
            }
        }
        return false;
    }

    protected void finalize() {
        this.clearVDB();
    }
}

