/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.impl.RecordFactory;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.ColumnSetRecord;
import com.metamatrix.modeler.core.metadata.runtime.DatatypeRecord;
import com.metamatrix.modeler.core.metadata.runtime.ForeignKeyRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ModelRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureParameterRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureRecord;
import com.metamatrix.modeler.core.metadata.runtime.PropertyRecord;
import com.metamatrix.modeler.core.metadata.runtime.TableRecord;
import com.metamatrix.modeler.core.metadata.runtime.TransformationRecord;
import com.metamatrix.modeler.core.metadata.runtime.VdbRecord;
import com.metamatrix.modeler.core.util.ColumnRecordComparator;
import com.metamatrix.modeler.internal.core.index.CompositeIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import com.metamatrix.modeler.internal.core.index.SimpleIndexUtil;
import com.metamatrix.modeler.internal.transformation.util.UuidUtil;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingLoader;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.metadata.BasicQueryMetadata;
import com.metamatrix.query.metadata.StoredProcedureInfo;
import com.metamatrix.query.sql.lang.SPParameter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public abstract class TransformationMetadata
extends BasicQueryMetadata {
    private static int NULLABLE = 1;
    private static int NULLABLE_UNKNOWN = 2;
    private static int SEARCHABLE = 0;
    private static int ALL_EXCEPT_LIKE = 1;
    private static int LIKE_ONLY = 2;
    public static final char DELIMITER_CHAR = '.';
    public static final String DELIMITER_STRING = ".";
    public static ColumnRecordComparator columnComparator = new ColumnRecordComparator();
    public static String NOT_EXISTS_MESSAGE = StringUtil.Constants.SPACE + RuntimeMetadataPlugin.Util.getString("TransformationMetadata.does_not_exist._1");
    private final QueryMetadataContext context;

    protected TransformationMetadata(QueryMetadataContext context) {
        ArgCheck.isNotNull((Object)context);
        this.context = context;
    }

    public Object getElementID(String elementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)elementName);
        if (StringUtil.startsWithIgnoreCase((String)elementName, (String)"mmuuid") || StringUtil.getTokens((String)elementName, (String)DELIMITER_STRING).size() >= 3) {
            return this.getRecordByType(elementName, 'G');
        }
        throw new QueryMetadataException(elementName + NOT_EXISTS_MESSAGE);
    }

    public Object getGroupID(String groupName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)groupName);
        if (StringUtil.startsWithIgnoreCase((String)groupName, (String)"mmuuid") || StringUtil.getTokens((String)groupName, (String)DELIMITER_STRING).size() >= 2) {
            return this.getRecordByType(groupName, 'B');
        }
        throw new QueryMetadataException(groupName + NOT_EXISTS_MESSAGE);
    }

    public Collection getGroupsForPartialName(String partialGroupName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)partialGroupName);
        Collection tableRecords = null;
        String partialName = partialGroupName;
        if (!StringUtil.startsWithIgnoreCase((String)partialGroupName, (String)"mmuuid")) {
            partialName = '.' + partialGroupName;
        }
        tableRecords = this.findMetadataRecords('B', partialName, true);
        ArrayList<String> tableNames = new ArrayList<String>(tableRecords.size());
        for (TableRecord tableRecord : tableRecords) {
            tableNames.add(this.getFullName(tableRecord));
        }
        return tableNames;
    }

    public Object getModelID(Object groupOrElementID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)groupOrElementID);
        MetadataRecord metadataRecord = (MetadataRecord)groupOrElementID;
        String modelName = metadataRecord.getModelName();
        return this.getRecordByType(modelName, 'A');
    }

    public String getFullName(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        return metadataRecord.getFullName();
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)fullGroupName);
        ArgCheck.isNotEmpty((String)shortElementName);
        if (UuidUtil.isStringifiedUUID(shortElementName)) {
            return UuidUtil.stripPrefixFromUUID(shortElementName);
        }
        if (UuidUtil.isStringifiedUUID(fullGroupName)) {
            MetadataRecord group = (MetadataRecord)this.getGroupID(fullGroupName);
            String groupName = group.getFullName();
            return groupName + '.' + shortElementName;
        }
        return fullGroupName + '.' + shortElementName;
    }

    public String getShortElementName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)fullElementName);
        if (UuidUtil.isStringifiedUUID(fullElementName)) {
            return UuidUtil.stripPrefixFromUUID(fullElementName);
        }
        int index = fullElementName.lastIndexOf(46);
        if (index >= 0) {
            return fullElementName.substring(index + 1);
        }
        return fullElementName;
    }

    public String getGroupName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        String fullName;
        MetadataRecord record;
        ArgCheck.isNotEmpty((String)fullElementName);
        int index = fullElementName.lastIndexOf(46);
        if (index >= 0) {
            return fullElementName.substring(0, index);
        }
        if (UuidUtil.isStringifiedUUID(fullElementName) && (record = (MetadataRecord)this.getElementID(fullName = UuidUtil.stripPrefixFromUUID(fullElementName))) != null) {
            return record.getParentUUID();
        }
        return null;
    }

    public List getElementIDsInGroupID(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        String groupUUID = tableRecord.getUUID();
        Assertion.isNotNull((Object)groupUUID);
        Collection results = this.findChildRecords(tableRecord, 'G');
        if (results.isEmpty()) {
            throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Group(0}_does_not_have_elements", new Object[]{groupName}));
        }
        ArrayList columnRecords = new ArrayList(results);
        Collections.sort(columnRecords, columnComparator);
        return columnRecords;
    }

    public Object getGroupIDForElementID(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            ColumnRecord columnRecord = (ColumnRecord)elementID;
            String tableUUID = columnRecord.getParentUUID();
            return this.getGroupID(tableUUID);
        }
        if (elementID instanceof ProcedureParameterRecord) {
            ProcedureParameterRecord columnRecord = (ProcedureParameterRecord)elementID;
            String tableUUID = columnRecord.getParentUUID();
            return this.getGroupID(tableUUID);
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public StoredProcedureInfo getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws MetaMatrixComponentException, QueryMetadataException {
        String procedurePlan;
        ArgCheck.isNotEmpty((String)fullyQualifiedProcedureName);
        ProcedureRecord procRecord = null;
        if (StringUtil.startsWithIgnoreCase((String)fullyQualifiedProcedureName, (String)"mmuuid") || StringUtil.getTokens((String)fullyQualifiedProcedureName, (String)DELIMITER_STRING).size() >= 2) {
            procRecord = (ProcedureRecord)this.getRecordByType(fullyQualifiedProcedureName, 'E');
        }
        if (procRecord == null) {
            throw new QueryMetadataException(fullyQualifiedProcedureName + NOT_EXISTS_MESSAGE);
        }
        String procedureFullName = procRecord.getFullName();
        StoredProcedureInfo procInfo = new StoredProcedureInfo();
        procInfo.setProcedureCallableName(procRecord.getName());
        procInfo.setProcedureID((Object)procRecord);
        MetadataRecord modelRecord = (MetadataRecord)this.getModelID(procRecord);
        procInfo.setModelID((Object)modelRecord);
        for (String paramID : procRecord.getParameterIDs()) {
            ProcedureParameterRecord paramRecord = (ProcedureParameterRecord)this.getRecordByType(paramID, 'F');
            String runtimeType = paramRecord.getRuntimeType();
            int direction = this.convertParamRecordTypeToStoredProcedureType(paramRecord.getType());
            SPParameter spParam = new SPParameter(paramRecord.getPosition(), direction, paramRecord.getFullName());
            spParam.setMetadataID((Object)paramRecord);
            spParam.setClassType(DataTypeManager.getDataTypeClass((String)runtimeType));
            procInfo.addParameter(spParam);
        }
        String resultID = (String)procRecord.getResultSetID();
        if (resultID != null) {
            try {
                ColumnSetRecord resultRecord = (ColumnSetRecord)this.getRecordByType(resultID, 'C');
                int lastParamIndex = procInfo.getParameters().size() + 1;
                SPParameter param = new SPParameter(lastParamIndex, 5, resultRecord.getFullName());
                param.setClassType(ResultSet.class);
                param.setMetadataID((Object)resultRecord);
                ColumnRecord[] columnRecords = this.getColumnRecordsForUUIDs(resultRecord.getColumnIDs());
                for (int i = 0; i < columnRecords.length; ++i) {
                    String colType = columnRecords[i].getRuntimeType();
                    param.addResultSetColumn(columnRecords[i].getFullName(), DataTypeManager.getDataTypeClass((String)colType), (Object)columnRecords[i]);
                }
                procInfo.addParameter(param);
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
        }
        if (procRecord.isVirtual() && (procedurePlan = this.getProcedurePlan(procedureFullName)) != null) {
            QueryNode queryNode = new QueryNode(procedureFullName, procedurePlan);
            procInfo.setQueryPlan(queryNode);
        }
        procInfo.setUpdateCount(procRecord.getUpdateCount() - 1);
        return procInfo;
    }

    private int convertParamRecordTypeToStoredProcedureType(int parameterType) {
        switch (parameterType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return -1;
    }

    public String getElementType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getRuntimeType();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getRuntimeType();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Object getDefaultValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getDefaultValue();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getDefaultValue();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Object getMinimumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getMinValue();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Object getMaximumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getMaxValue();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public boolean isVirtualGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        return ((TableRecord)groupID).isVirtual();
    }

    public boolean isProcedure(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof ProcedureRecord) {
            return true;
        }
        if (groupID instanceof TableRecord) {
            return false;
        }
        throw this.createInvalidRecordTypeException(groupID);
    }

    public boolean isVirtualModel(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ModelRecord.class, (Object)modelID);
        ModelRecord modelRecord = (ModelRecord)modelID;
        return modelRecord.getModelType() == 1;
    }

    public QueryNode getVirtualPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            int resultSize;
            Collection results = this.findMetadataRecords('P', groupName, false);
            if (results.isEmpty()) {
                results = this.findMetadataRecords('U', groupName, false);
            }
            if ((resultSize = results.size()) == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                String transQuery = transformRecord.getTransformation();
                QueryNode queryNode = new QueryNode(groupName, transQuery);
                List bindings = transformRecord.getBindings();
                if (bindings != null) {
                    Iterator bindIter = bindings.iterator();
                    while (bindIter.hasNext()) {
                        queryNode.addBinding((String)bindIter.next());
                    }
                }
                return queryNode;
            }
            if (resultSize == 0) {
                throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Could_not_find_query_plan_for_the_group__5") + groupName);
            }
            if (resultSize > 1) {
                throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_virtual_plans_available_for_this_groupID__1") + groupName);
            }
        }
        throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.QueryPlan_could_not_be_found_for_physical_group__6") + groupName);
    }

    public String getInsertPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            Collection results = this.findMetadataRecords('Q', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                return transformRecord.getTransformation();
            }
            if (resultSize == 0) {
                return null;
            }
            if (resultSize > 1) {
                throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_insert_plans_available_for_this_groupID__2") + groupName);
            }
        }
        throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.InsertPlan_could_not_be_found_for_physical_group__8") + groupName);
    }

    public String getUpdatePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            Collection results = this.findMetadataRecords('R', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                return transformRecord.getTransformation();
            }
            if (resultSize == 0) {
                return null;
            }
            if (resultSize > 1) {
                throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_update_plans_available_for_this_groupID__3") + groupName);
            }
        }
        throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.InsertPlan_could_not_be_found_for_physical_group__10") + groupName);
    }

    public String getDeletePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            Collection results = this.findMetadataRecords('S', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                return transformRecord.getTransformation();
            }
            if (resultSize == 0) {
                return null;
            }
            if (resultSize > 1) {
                throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_delete_plans_available_for_this_groupID__4") + groupName);
            }
        }
        throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.DeletePlan_could_not_be_found_for_physical_group__12") + groupName);
    }

    public boolean modelSupports(Object modelID, int modelConstant) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ModelRecord.class, (Object)modelID);
        switch (modelConstant) {
            default: 
        }
        throw new UnsupportedOperationException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + modelConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        switch (groupConstant) {
            case 0: {
                return tableRecord.supportsUpdate();
            }
        }
        throw new UnsupportedOperationException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + groupConstant);
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            ColumnRecord columnRecord = (ColumnRecord)elementID;
            switch (elementConstant) {
                case 4: {
                    int ntype1 = columnRecord.getNullType();
                    return ntype1 == NULLABLE;
                }
                case 10: {
                    int ntype2 = columnRecord.getNullType();
                    return ntype2 == NULLABLE_UNKNOWN;
                }
                case 2: {
                    int stype1 = columnRecord.getSearchType();
                    return stype1 == SEARCHABLE || stype1 == ALL_EXCEPT_LIKE;
                }
                case 1: {
                    int stype2 = columnRecord.getSearchType();
                    return stype2 == SEARCHABLE || stype2 == LIKE_ONLY;
                }
                case 0: {
                    return columnRecord.isSelectable();
                }
                case 5: {
                    return columnRecord.isUpdatable();
                }
                case 7: {
                    Object defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return columnRecord.isAutoIncrementable();
                }
                case 9: {
                    return columnRecord.isCaseSensitive();
                }
                case 11: {
                    return columnRecord.isSigned();
                }
            }
            throw new UnsupportedOperationException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + elementConstant);
        }
        if (elementID instanceof ProcedureParameterRecord) {
            ProcedureParameterRecord columnRecord = (ProcedureParameterRecord)elementID;
            switch (elementConstant) {
                case 4: {
                    int ntype1 = columnRecord.getNullType();
                    return ntype1 == NULLABLE;
                }
                case 10: {
                    int ntype2 = columnRecord.getNullType();
                    return ntype2 == NULLABLE_UNKNOWN;
                }
                case 1: 
                case 2: {
                    return false;
                }
                case 0: {
                    return columnRecord.getType() != 0;
                }
                case 5: {
                    return false;
                }
                case 7: {
                    Object defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 11: {
                    return true;
                }
            }
            throw new UnsupportedOperationException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + elementConstant);
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    private IllegalArgumentException createInvalidRecordTypeException(Object elementID) {
        return new IllegalArgumentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Invalid_type", new Object[]{elementID.getClass().getName()}));
    }

    public int getMaxSetSize(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ModelRecord.class, (Object)modelID);
        return ((ModelRecord)modelID).getMaxSetSize();
    }

    public Collection getIndexesInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        Assertion.isNotNull((Object)groupUUID);
        Collection indexIDs = tableRecord.getIndexIDs();
        HashSet indexRecords = new HashSet(indexIDs.size());
        for (String indexID : tableRecord.getIndexIDs()) {
            Collection results = this.findMetadataRecords('L', indexID, false);
            if (results.size() != 1) {
                if (results.isEmpty()) {
                    throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.No_metadata_info_available_for_the_index_with_UUID_{0}._1", new Object[]{indexID}));
                }
                throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Ambigous_index_with_UUID_{0},_found_multiple_indexes_with_the_given_UUID._2", new Object[]{indexID}));
            }
            indexRecords.addAll(results);
        }
        return indexRecords;
    }

    public Collection getUniqueKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        Assertion.isNotNull((Object)groupUUID);
        return this.findChildRecords(tableRecord, 'I');
    }

    public Collection getForeignKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        Assertion.isNotNull((Object)groupUUID);
        return this.findChildRecords(tableRecord, 'J');
    }

    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ForeignKeyRecord.class, (Object)foreignKeyID);
        ForeignKeyRecord fkRecord = (ForeignKeyRecord)foreignKeyID;
        String uuid = (String)fkRecord.getUniqueKeyID();
        return this.getRecordByType(uuid, 'K');
    }

    public Collection getAccessPatternsInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        Assertion.isNotNull((Object)groupUUID);
        return this.findChildRecords(tableRecord, 'H');
    }

    public List getElementIDsInIndex(Object index) throws MetaMatrixComponentException, QueryMetadataException {
        boolean recordMatch;
        ArgCheck.isInstanceOf(ColumnSetRecord.class, (Object)index);
        ColumnSetRecord indexRecord = (ColumnSetRecord)index;
        boolean bl = recordMatch = indexRecord.getRecordType() == 'L';
        if (!recordMatch) {
            throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.The_metadataID_passed_does_not_match_a_index_record._1"));
        }
        List uuids = indexRecord.getColumnIDs();
        ArrayList<Object> columnRecords = new ArrayList<Object>(uuids.size());
        for (String uuid : uuids) {
            columnRecords.add(this.getElementID(uuid));
        }
        return columnRecords;
    }

    public List getElementIDsInKey(Object key) throws MetaMatrixComponentException, QueryMetadataException {
        boolean recordMatch;
        ArgCheck.isInstanceOf(ColumnSetRecord.class, (Object)key);
        ColumnSetRecord keyRecord = (ColumnSetRecord)key;
        boolean bl = recordMatch = keyRecord.getRecordType() == 'J' || keyRecord.getRecordType() == 'K' || keyRecord.getRecordType() == 'I';
        if (!recordMatch) {
            throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Expected_id_of_the_type_key_record_as_the_argument_2"));
        }
        List uuids = keyRecord.getColumnIDs();
        String groupUUID = keyRecord.getParentUUID();
        Assertion.isNotNull((Object)groupUUID);
        TableRecord tableRecord = (TableRecord)this.getGroupID(groupUUID);
        Collection results = this.findChildRecordsForColumns(tableRecord, 'G', uuids);
        if (results.isEmpty()) {
            throw new QueryMetadataException(tableRecord.getFullName() + NOT_EXISTS_MESSAGE);
        }
        return new ArrayList(results);
    }

    public List getElementIDsInAccessPattern(Object accessPattern) throws MetaMatrixComponentException, QueryMetadataException {
        boolean recordMatch;
        ArgCheck.isInstanceOf(ColumnSetRecord.class, (Object)accessPattern);
        ColumnSetRecord accessRecord = (ColumnSetRecord)accessPattern;
        boolean bl = recordMatch = accessRecord.getRecordType() == 'H';
        if (!recordMatch) {
            throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Expected_id_of_the_type_accesspattern_record_as_the_argument_3"));
        }
        List uuids = accessRecord.getColumnIDs();
        String groupUUID = accessRecord.getParentUUID();
        Assertion.isNotNull((Object)groupUUID);
        TableRecord tableRecord = (TableRecord)this.getGroupID(groupUUID);
        Collection results = this.findChildRecordsForColumns(tableRecord, 'G', uuids);
        if (results.isEmpty()) {
            throw new QueryMetadataException(tableRecord.getFullName() + NOT_EXISTS_MESSAGE);
        }
        return new ArrayList(results);
    }

    public boolean isXMLGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        return tableRecord.getTableType() == 2;
    }

    public boolean isTemporaryGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        return tableRecord.getTableType() == 4;
    }

    public boolean hasMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        return tableRecord.isMaterialized();
    }

    public Object getMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        if (tableRecord.isMaterialized()) {
            String uuid = (String)tableRecord.getMaterializedTableID();
            return this.getGroupID(uuid);
        }
        return null;
    }

    public Object getMaterializationStage(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        if (tableRecord.isMaterialized()) {
            String uuid = (String)tableRecord.getMaterializedStageTableID();
            return this.getGroupID(uuid);
        }
        return null;
    }

    public MappingNode getMappingNode(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            TransformationRecord transformRecord = null;
            Collection results = this.findMetadataRecords('U', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                transformRecord = (TransformationRecord)results.iterator().next();
            } else {
                if (resultSize == 0) {
                    throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Could_not_find_transformation_record_for_the_group__1") + groupName);
                }
                if (resultSize > 1) {
                    throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Multiple_transformation_records_found_for_the_group___1") + groupName);
                }
            }
            String document = transformRecord.getTransformation();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(document.getBytes());
            MappingLoader reader = new MappingLoader();
            MappingDocument mappingDoc = null;
            try {
                mappingDoc = reader.loadDocument((InputStream)inputStream);
                mappingDoc.setName(groupName);
            }
            catch (Exception e) {
                throw new MetaMatrixComponentException((Throwable)e, RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Error_trying_to_read_virtual_document_{0},_with_body__n{1}_1", new Object[]{groupName, mappingDoc}));
            }
            finally {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {}
            }
            return mappingDoc;
        }
        return null;
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        try {
            VdbRecord vdbRecord = (VdbRecord)this.getRecordByType(null, 'V');
            return vdbRecord.getName();
        }
        catch (QueryMetadataException e) {
            return null;
        }
    }

    public Collection getXMLTempGroups(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        Collection results;
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        int tableType = tableRecord.getTableType();
        if (tableType == 2 && !(results = this.findChildRecordsWithoutFiltering(tableRecord, 'B')).isEmpty()) {
            HashSet<TableRecord> tempGroups = new HashSet<TableRecord>(results.size());
            for (TableRecord record : results) {
                if (record.getTableType() != 4) continue;
                tempGroups.add(record);
            }
            return tempGroups;
        }
        return Collections.EMPTY_SET;
    }

    public int getCardinality(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        return ((TableRecord)groupID).getCardinality();
    }

    public List getXMLSchemas(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (!(this.getIndexSelector() instanceof CompositeIndexSelector) && !(this.getIndexSelector() instanceof RuntimeIndexSelector)) {
            return Collections.EMPTY_LIST;
        }
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        TransformationRecord transformRecord = null;
        Collection results = this.findMetadataRecords('U', groupName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            transformRecord = (TransformationRecord)results.iterator().next();
        } else {
            if (resultSize == 0) {
                throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Could_not_find_transformation_record_for_the_group__1") + groupName);
            }
            if (resultSize > 1) {
                throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Multiple_transformation_records_found_for_the_group___1") + groupName);
            }
        }
        List schemaPaths = transformRecord.getSchemaPaths();
        LinkedList<String> fullPaths = new LinkedList<String>();
        File f = new File(transformRecord.getResourcePath());
        String path = f.getParent();
        for (String string : schemaPaths) {
            fullPaths.add(path + File.separator + string);
        }
        List schemas = this.getIndexSelector().getFileContentsAsString(fullPaths);
        if ((schemas == null || schemas.isEmpty()) && ((schemas = this.getIndexSelector().getFileContentsAsString(schemaPaths)) == null || schemas.isEmpty())) {
            throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Error_trying_to_read_schemas_for_the_document/table____1") + groupName);
        }
        return schemas;
    }

    public String getNameInSource(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        return ((MetadataRecord)metadataID).getNameInSource();
    }

    public int getElementLength(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getLength();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getLength();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getPosition(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getPosition();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getPosition();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getPrecision(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getPrecision();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getPrecision();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getRadix(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getRadix();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getRadix();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public String getFormat(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getFormat();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getScale(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getScale();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getScale();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getDistinctValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getDistinctValues();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return -1;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getNullValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getNullValues();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return -1;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public String getNativeType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getNativeType();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        Properties extProps = new Properties();
        String uuid = metadataRecord.getUUID();
        String prefixString = this.getUUIDPrefixPattern('X', uuid);
        Index[] indexes = this.getIndexes('X', this.getIndexSelector());
        IEntryResult[] results = this.queryIndex(indexes, prefixString.toCharArray(), true, true);
        if (results != null && results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                PropertyRecord record;
                if (results[i] == null || (record = (PropertyRecord)this.findMetadataRecord(results[i])) == null) continue;
                extProps.setProperty(record.getPropertyName(), record.getPropertyValue());
            }
        }
        return extProps;
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        String content = this.getCharacterVDBResource(resourcePath);
        if (content != null) {
            return content.getBytes();
        }
        return null;
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        CompositeIndexSelector compSelector;
        List selectors;
        IndexSelector selector = this.getIndexSelector();
        try {
            selector.getIndexes();
        }
        catch (IOException e) {
            throw new QueryMetadataException((Throwable)e, RuntimeMetadataPlugin.Util.getString("TransformationMetadata.error_intialize_selector"));
        }
        if (selector instanceof CompositeIndexSelector && (selectors = (compSelector = (CompositeIndexSelector)selector).getIndexSelectors()).size() > 0) {
            IndexSelector firstSelector = (IndexSelector)selectors.get(0);
            return firstSelector.getFileContentAsString(resourcePath);
        }
        return selector.getFileContentAsString(resourcePath);
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        CompositeIndexSelector compSelector;
        List selectors;
        IndexSelector selector = this.getIndexSelector();
        try {
            selector.getIndexes();
        }
        catch (IOException e) {
            throw new QueryMetadataException((Throwable)e, RuntimeMetadataPlugin.Util.getString("TransformationMetadata.error_intialize_selector"));
        }
        if (selector instanceof CompositeIndexSelector && (selectors = (compSelector = (CompositeIndexSelector)selector).getIndexSelectors()).size() > 0) {
            IndexSelector firstSelector = (IndexSelector)selectors.get(0);
            return firstSelector.getFilePaths();
        }
        return selector.getFilePaths();
    }

    public String getModeledType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        DatatypeRecord record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getDatatypeID();
        }
        return null;
    }

    public String getModeledBaseType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        DatatypeRecord record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getBasetypeID();
        }
        return null;
    }

    public String getModeledPrimitiveType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        DatatypeRecord record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getPrimitiveTypeID();
        }
        return null;
    }

    protected DatatypeRecord getDatatypeRecord(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof ColumnRecord) {
            String uuid = ((ColumnRecord)elementID).getDatatypeUUID();
            if (!StringUtil.isEmpty((String)uuid)) {
                Collection results = this.findMetadataRecords('M', uuid, false);
                int resultSize = results.size();
                if (resultSize == 1) {
                    return (DatatypeRecord)results.iterator().next();
                }
                if (resultSize == 0) {
                    throw new QueryMetadataException(uuid + NOT_EXISTS_MESSAGE);
                }
                throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.0", new Object[]{uuid}));
            }
            return null;
        }
        if (elementID instanceof ProcedureParameterRecord) {
            String uuid = ((ProcedureParameterRecord)elementID).getDatatypeUUID();
            if (!StringUtil.isEmpty((String)uuid)) {
                Collection results = this.findMetadataRecords('M', uuid, false);
                int resultSize = results.size();
                if (resultSize == 1) {
                    return (DatatypeRecord)results.iterator().next();
                }
                if (resultSize == 0) {
                    throw new QueryMetadataException(uuid + NOT_EXISTS_MESSAGE);
                }
                throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.0", new Object[]{uuid}));
            }
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    protected Index[] getIndexes(char recordType, IndexSelector selector) throws MetaMatrixComponentException {
        try {
            return selector.getIndexes();
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException((Throwable)e, RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Error_trying_to_obtain_index_file_using_IndexSelector_1", new Object[]{selector}));
        }
    }

    protected String getDatatypeUUIDMatchPattern(String uuid) {
        ArgCheck.isNotNull((Object)uuid);
        String uuidString = uuid;
        if (StringUtil.startsWithIgnoreCase((String)uuid, (String)"mmuuid")) {
            uuidString = uuid.toLowerCase();
        }
        String patternStr = "M\u00a0*\u00a0*\u00a0*\u00a0" + uuidString + '\u00a0' + '*';
        return patternStr;
    }

    protected String getUUIDMatchPattern(char recordType, String uuid) {
        ArgCheck.isNotNull((Object)uuid);
        String uuidString = uuid;
        if (StringUtil.startsWithIgnoreCase((String)uuid, (String)"mmuuid")) {
            uuidString = uuid.toLowerCase();
        }
        String patternStr = "" + recordType + '\u00a0' + '*' + '\u00a0' + uuidString + '\u00a0' + '*';
        return patternStr;
    }

    protected String getMatchPattern(char recordType, String name) {
        ArgCheck.isNotNull((Object)name);
        String patternStr = "" + recordType + '\u00a0' + '*';
        if (name != null) {
            patternStr = patternStr + name.trim().toUpperCase() + '\u00a0' + '*';
        }
        return patternStr;
    }

    protected String getPrefixPattern(char recordType, String name) {
        String patternStr = "" + recordType + '\u00a0';
        if (name != null) {
            patternStr = patternStr + name.trim().toUpperCase() + '\u00a0';
        }
        return patternStr;
    }

    protected String getUUIDPrefixPattern(char recordType, String uuid) {
        String patternStr = "" + recordType + '\u00a0';
        if (uuid != null) {
            patternStr = patternStr + uuid.trim() + '\u00a0';
        }
        return patternStr;
    }

    protected String getParentPrefixPattern(char recordType, String name) {
        String patternStr = "" + recordType + '\u00a0';
        if (name != null) {
            patternStr = patternStr + name.trim().toUpperCase() + '.';
        }
        return patternStr;
    }

    protected MetadataRecord getRecordByType(String entityName, char recordType) throws MetaMatrixComponentException, QueryMetadataException {
        Collection results = this.findMetadataRecords(recordType, entityName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            return (MetadataRecord)results.iterator().next();
        }
        if (resultSize == 0) {
            throw new QueryMetadataException(entityName + NOT_EXISTS_MESSAGE);
        }
        throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.0", new Object[]{entityName}));
    }

    protected void filterMetadataRecordForUUID(String uuid, Collection records) {
        if (uuid != null && records != null) {
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                MetadataRecord record = (MetadataRecord)iter.next();
                if (record != null && uuid.equals(record.getUUID())) continue;
                iter.remove();
            }
        }
    }

    protected IndexSelector getIndexSelector() {
        return this.context.getIndexSelector();
    }

    protected QueryMetadataContext getContext() {
        return this.context;
    }

    protected Collection findChildRecords(MetadataRecord parentRecord, char childRecordType) throws MetaMatrixComponentException {
        IEntryResult[] results = this.queryIndexByParentPath(childRecordType, parentRecord.getFullName());
        Collection records = this.findMetadataRecords(results);
        if (childRecordType == 'I') {
            Collection primarKeyRecords = this.findMetadataRecords(this.queryIndexByParentPath('K', parentRecord.getFullName()));
            records.addAll(primarKeyRecords);
        }
        String groupUUID = parentRecord.getUUID();
        ArrayList<MetadataRecord> filteredRecords = new ArrayList<MetadataRecord>(records.size());
        for (MetadataRecord record : records) {
            String parentUUID = record.getParentUUID();
            if (parentUUID == null || !parentUUID.equalsIgnoreCase(groupUUID)) continue;
            filteredRecords.add(record);
        }
        return filteredRecords;
    }

    protected Collection findChildRecordsForColumns(MetadataRecord parentRecord, char childRecordType, List uuids) throws MetaMatrixComponentException {
        IEntryResult[] results = this.queryIndexByParentPath(childRecordType, parentRecord.getFullName());
        Collection records = this.findMetadataRecords(results);
        if (childRecordType == 'I') {
            Collection primarKeyRecords = this.findMetadataRecords(this.queryIndexByParentPath('K', parentRecord.getFullName()));
            records.addAll(primarKeyRecords);
        }
        ArrayList<MetadataRecord> columnRecords = new ArrayList<MetadataRecord>(uuids.size());
        for (MetadataRecord record : records) {
            if (record == null || !uuids.contains(record.getUUID())) continue;
            columnRecords.add(record);
        }
        return columnRecords;
    }

    protected Collection findChildRecordsWithoutFiltering(MetadataRecord parentRecord, char childRecordType) throws MetaMatrixComponentException {
        IEntryResult[] results = this.queryIndexByParentPath(childRecordType, parentRecord.getFullName());
        Collection records = this.findMetadataRecords(results);
        if (childRecordType == 'I') {
            Collection primarKeyRecords = this.findMetadataRecords(this.queryIndexByParentPath('K', parentRecord.getFullName()));
            records.addAll(primarKeyRecords);
        }
        return records;
    }

    protected Collection findMetadataRecords(IEntryResult[] results) {
        return RecordFactory.getMetadataRecord(results, null);
    }

    protected MetadataRecord findMetadataRecord(IEntryResult result) {
        return RecordFactory.getMetadataRecord(result, null);
    }

    protected Collection findMetadataRecords(char recordType, String entityName, boolean isPartialName) throws MetaMatrixComponentException {
        IEntryResult[] results = this.queryIndex(recordType, entityName, isPartialName);
        Collection records = this.findMetadataRecords(results);
        if (StringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            this.filterMetadataRecordForUUID(entityName, records);
        }
        return records;
    }

    protected IEntryResult[] queryIndex(char recordType, String entityName, boolean isPartialName) throws MetaMatrixComponentException {
        IEntryResult[] results = null;
        Index[] indexes = this.getIndexes(recordType, this.getIndexSelector());
        if (StringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            String patternString = null;
            patternString = recordType == 'M' ? this.getDatatypeUUIDMatchPattern(entityName) : this.getUUIDMatchPattern(recordType, entityName);
            results = this.queryIndex(indexes, patternString.toCharArray(), false, true);
        } else if (isPartialName) {
            String patternString = this.getMatchPattern(recordType, entityName);
            results = this.queryIndex(indexes, patternString.toCharArray(), false, false);
        } else {
            String prefixString = this.getPrefixPattern(recordType, entityName);
            results = this.queryIndex(indexes, prefixString.toCharArray(), true, true);
        }
        return results;
    }

    protected IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws MetaMatrixComponentException {
        try {
            return SimpleIndexUtil.queryIndex(indexes, pattern, isPrefix, returnFirstMatch);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
    }

    protected IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws MetaMatrixComponentException {
        try {
            return SimpleIndexUtil.queryIndex(null, indexes, pattern, isPrefix, isCaseSensitive, returnFirstMatch);
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
    }

    private String getProcedurePlan(String procedureName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)procedureName);
        Collection results = this.findMetadataRecords('T', procedureName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
            return transformRecord.getTransformation();
        }
        if (resultSize > 1) {
            throw new MetaMatrixComponentException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Procedure_ambiguous_there_are_multiple_procedure_plans_available_for_this_name___4") + procedureName);
        }
        return null;
    }

    private ColumnRecord[] getColumnRecordsForUUIDs(List uuids) throws MetaMatrixComponentException, QueryMetadataException {
        ColumnRecord[] columnRecords = new ColumnRecord[uuids.size()];
        for (int i = 0; i < uuids.size(); ++i) {
            String colUUID = (String)uuids.get(i);
            columnRecords[i] = (ColumnRecord)this.getElementID(colUUID);
        }
        return columnRecords;
    }

    private IEntryResult[] queryIndexByParentPath(char recordType, String parentFullName) throws MetaMatrixComponentException {
        String prefixString = this.getParentPrefixPattern(recordType, parentFullName);
        Index[] indexes = this.getIndexes(recordType, this.getIndexSelector());
        IEntryResult[] results = this.queryIndex(indexes, prefixString.toCharArray(), true, false);
        return results;
    }
}

