/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.LRUCache;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.TableRecord;
import com.metamatrix.modeler.internal.transformation.util.UuidUtil;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadata;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.StoredProcedureInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TransformationMetadataFacade
implements QueryMetadataInterface {
    public static final int DEFAULT_SPACELIMIT = 4000;
    public static final int DEFAULT_SPACELIMIT_PARTIAL_NAME_CACHE = 100;
    private static final int GROUP_INFO_CACHE_SIZE = 500;
    private final TransformationMetadata metadata;
    private final Map<String, Object> nameToIdCache;
    private final Map<Object, MetadataRecord> idToRecordCache;
    private final Map<String, String> partialNameToFullNameCache;
    private final Map groupInfoCache = Collections.synchronizedMap(new LRUCache(500));

    public TransformationMetadataFacade(TransformationMetadata delegate) {
        this(delegate, 4000);
    }

    public TransformationMetadataFacade(TransformationMetadata delegate, int cacheSize) {
        ArgCheck.isNotNull((Object)((Object)delegate));
        this.metadata = delegate;
        this.nameToIdCache = Collections.synchronizedMap(new LRUCache(cacheSize));
        this.idToRecordCache = Collections.synchronizedMap(new LRUCache(cacheSize));
        this.partialNameToFullNameCache = Collections.synchronizedMap(new LRUCache(100));
    }

    public Object getElementID(String elementName) throws MetaMatrixComponentException, QueryMetadataException {
        MetadataRecord record = this.getRecordByName(elementName, 'G');
        if (record == null && (record = (MetadataRecord)this.metadata.getElementID(elementName)) != null) {
            this.updateNameToIdCache(elementName, 'G', record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        return record;
    }

    public Object getGroupID(String groupName) throws MetaMatrixComponentException, QueryMetadataException {
        MetadataRecord record = this.getRecordByName(groupName, 'B');
        if (record == null && (record = (MetadataRecord)this.metadata.getGroupID(groupName)) != null) {
            this.updateNameToIdCache(groupName, 'B', record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getGroupsForPartialName(String partialGroupName) throws MetaMatrixComponentException, QueryMetadataException {
        String fullName = this.getFullNameByPartialName(partialGroupName, 'B');
        if (fullName == null) {
            Map<String, String> map = this.partialNameToFullNameCache;
            synchronized (map) {
                fullName = this.getFullNameByPartialName(partialGroupName, 'B');
                if (fullName == null) {
                    Collection partialNameRecords = this.metadata.getGroupsForPartialName(partialGroupName);
                    if (partialNameRecords != null && partialNameRecords.size() == 1) {
                        this.updatePartialNameToFullName(partialGroupName, (String)partialNameRecords.iterator().next(), 'B');
                    }
                    return partialNameRecords;
                }
            }
        }
        ArrayList<String> partialNameRecords = new ArrayList<String>(1);
        partialNameRecords.add(fullName);
        return partialNameRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getModelID(Object groupOrElementID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)groupOrElementID);
        MetadataRecord record = (MetadataRecord)groupOrElementID;
        Object modelRecord = record.getPropertyValue("modelForRecord");
        if (modelRecord == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                modelRecord = record.getPropertyValue("modelForRecord");
                if (modelRecord == null) {
                    modelRecord = this.metadata.getModelID(groupOrElementID);
                    record.setPropertyValue("modelForRecord", modelRecord);
                }
            }
        }
        return modelRecord;
    }

    public String getFullName(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getFullName(metadataID);
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotZeroLength((String)fullGroupName);
        ArgCheck.isNotZeroLength((String)shortElementName);
        if (UuidUtil.isStringifiedUUID(shortElementName)) {
            return UuidUtil.stripPrefixFromUUID(shortElementName);
        }
        if (UuidUtil.isStringifiedUUID(fullGroupName)) {
            MetadataRecord group = (MetadataRecord)this.getGroupID(fullGroupName);
            if (group == null) {
                throw new QueryMetadataException(RuntimeMetadataPlugin.Util.getString("TransformationMetadata.Unable_to_determine_fullname_for_element__1") + shortElementName);
            }
            String groupName = group.getFullName();
            return groupName + '.' + shortElementName;
        }
        return fullGroupName + '.' + shortElementName;
    }

    public String getShortElementName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getShortElementName(fullElementName);
    }

    public String getGroupName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotZeroLength((String)fullElementName);
        int index = fullElementName.lastIndexOf(46);
        if (index >= 0) {
            return fullElementName.substring(0, index);
        }
        if (UuidUtil.isStringifiedUUID(fullElementName)) {
            String newFullElementName = UuidUtil.stripPrefixFromUUID(fullElementName);
            MetadataRecord record = this.getRecordByID(newFullElementName);
            if (record == null) {
                record = (MetadataRecord)this.metadata.getElementID(newFullElementName);
                this.updateIdToRecordCache(newFullElementName, record);
            }
            return record.getParentUUID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInGroupID(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        List elementIDs = (List)record.getPropertyValue("elementsInGroup");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInGroup");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInGroupID(groupID)) != null) {
                    record.setPropertyValue("elementsInGroup", elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    public Object getGroupIDForElementID(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ColumnRecord.class, (Object)elementID);
        ColumnRecord columnRecord = (ColumnRecord)elementID;
        String tableUUID = columnRecord.getParentUUID();
        MetadataRecord record = this.getRecordByID(tableUUID);
        if (record == null && (record = (MetadataRecord)this.metadata.getGroupID(tableUUID)) != null) {
            this.updateNameToIdCache(record.getFullName(), record.getRecordType(), record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        return record;
    }

    public StoredProcedureInfo getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws MetaMatrixComponentException, QueryMetadataException {
        StoredProcedureInfo procInfo = null;
        MetadataRecord record = this.getRecordByName(fullyQualifiedProcedureName, 'E');
        if (record == null && (procInfo = this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName)) != null) {
            record = (MetadataRecord)procInfo.getProcedureID();
            record.setPropertyValue("storedProcInfoForRecord", procInfo);
            this.updateNameToIdCache(fullyQualifiedProcedureName, 'E', record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        if (procInfo == null && record != null && (procInfo = (StoredProcedureInfo)record.getPropertyValue("storedProcInfoForRecord")) == null) {
            procInfo = this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName);
            record.setPropertyValue("storedProcInfoForRecord", procInfo);
        }
        return procInfo;
    }

    public String getElementType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getElementType(elementID);
    }

    public Object getDefaultValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getDefaultValue(elementID);
    }

    public Object getMaximumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaximumValue(elementID);
    }

    public Object getMinimumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMinimumValue(elementID);
    }

    public int getPosition(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getPosition(elementID);
    }

    public int getPrecision(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getPrecision(elementID);
    }

    public int getRadix(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getRadix(elementID);
    }

    public String getFormat(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getFormat(elementID);
    }

    public int getScale(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getScale(elementID);
    }

    public int getDistinctValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getDistinctValues(elementID);
    }

    public int getNullValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNullValues(elementID);
    }

    public boolean isVirtualGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isVirtualGroup(groupID);
    }

    public boolean hasMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.hasMaterialization(groupID);
    }

    public Object getMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaterialization(groupID);
    }

    public Object getMaterializationStage(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaterializationStage(groupID);
    }

    public boolean isVirtualModel(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isVirtualModel(modelID);
    }

    public boolean isProcedure(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isProcedure(elementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryNode getVirtualPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        QueryNode queryPlan = (QueryNode)tableRecord.getPropertyValue("queryPlan");
        if (queryPlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                queryPlan = (QueryNode)tableRecord.getPropertyValue("queryPlan");
                if (queryPlan == null) {
                    queryPlan = this.metadata.getVirtualPlan(groupID);
                    tableRecord.setPropertyValue("queryPlan", queryPlan);
                }
            }
        }
        return queryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInsertPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String insertPlan = (String)tableRecord.getPropertyValue("insertPlan");
        if (insertPlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                insertPlan = (String)tableRecord.getPropertyValue("insertPlan");
                if (insertPlan == null) {
                    insertPlan = this.metadata.getInsertPlan(groupID);
                    tableRecord.setPropertyValue("insertPlan", insertPlan);
                }
            }
        }
        return insertPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUpdatePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String updatePlan = (String)tableRecord.getPropertyValue("updatePlan");
        if (updatePlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                updatePlan = (String)tableRecord.getPropertyValue("updatePlan");
                if (updatePlan == null) {
                    updatePlan = this.metadata.getUpdatePlan(groupID);
                    tableRecord.setPropertyValue("updatePlan", updatePlan);
                }
            }
        }
        return updatePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeletePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String deletePlan = (String)tableRecord.getPropertyValue("deletePlan");
        if (deletePlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                deletePlan = (String)tableRecord.getPropertyValue("deletePlan");
                if (deletePlan == null) {
                    deletePlan = this.metadata.getDeletePlan(groupID);
                    tableRecord.setPropertyValue("deletePlan", deletePlan);
                }
            }
        }
        return deletePlan;
    }

    public boolean modelSupports(Object modelID, int modelConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.modelSupports(modelID, modelConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.groupSupports(groupID, groupConstant);
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.elementSupports(elementID, elementConstant);
    }

    public int getMaxSetSize(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaxSetSize(modelID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getIndexesInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection indexes = (Collection)record.getPropertyValue("indexesInGroup");
        if (indexes == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                indexes = (Collection)record.getPropertyValue("indexesInGroup");
                if (indexes == null) {
                    indexes = this.metadata.getIndexesInGroup(groupID);
                    record.setPropertyValue("indexesInGroup", indexes);
                }
            }
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getUniqueKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection uks = (Collection)record.getPropertyValue("uksInGroup");
        if (uks == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                uks = (Collection)record.getPropertyValue("uksInGroup");
                if (uks == null) {
                    uks = this.metadata.getUniqueKeysInGroup(groupID);
                    record.setPropertyValue("uksInGroup", uks);
                }
            }
        }
        return uks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getForeignKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection fks = (Collection)record.getPropertyValue("fksInGroup");
        if (fks == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                fks = (Collection)record.getPropertyValue("fksInGroup");
                if (fks == null) {
                    fks = this.metadata.getForeignKeysInGroup(groupID);
                    record.setPropertyValue("fksInGroup", fks);
                }
            }
        }
        return fks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)foreignKeyID);
        MetadataRecord keyRecord = (MetadataRecord)foreignKeyID;
        Object primaryKey = keyRecord.getPropertyValue("primaryKeyForForeignKey");
        if (primaryKey == null) {
            MetadataRecord metadataRecord = keyRecord;
            synchronized (metadataRecord) {
                primaryKey = keyRecord.getPropertyValue("primaryKeyForForeignKey");
                if (primaryKey == null) {
                    primaryKey = this.metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
                    keyRecord.setPropertyValue("primaryKeyForForeignKey", primaryKey);
                }
            }
        }
        return primaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAccessPatternsInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection accPatterns = (Collection)record.getPropertyValue("accPttrnsInGroup");
        if (accPatterns == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                accPatterns = (Collection)record.getPropertyValue("accPttrnsInGroup");
                if (accPatterns == null) {
                    accPatterns = this.metadata.getAccessPatternsInGroup(groupID);
                    record.setPropertyValue("accPttrnsInGroup", accPatterns);
                }
            }
        }
        return accPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInIndex(Object index) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)index);
        MetadataRecord record = (MetadataRecord)index;
        List elementIDs = (List)record.getPropertyValue("elementsInIndex");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInIndex");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInIndex(index)) != null) {
                    record.setPropertyValue("elementsInIndex", elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInKey(Object key) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)key);
        MetadataRecord record = (MetadataRecord)key;
        List elementIDs = (List)record.getPropertyValue("elementsInKey");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInKey");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInKey(key)) != null) {
                    record.setPropertyValue("elementsInKey", elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInAccessPattern(Object accessPattern) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)accessPattern);
        MetadataRecord record = (MetadataRecord)accessPattern;
        List elementIDs = (List)record.getPropertyValue("elementsInAccPttrn");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInAccPttrn");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInAccessPattern(accessPattern)) != null) {
                    record.setPropertyValue("elementsInAccPttrn", elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    public boolean isXMLGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isXMLGroup(groupID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingNode getMappingNode(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        MappingDocument mappingNode = (MappingDocument)record.getPropertyValue("mappingNodeForRecord");
        if (mappingNode == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                mappingNode = (MappingDocument)record.getPropertyValue("mappingNodeForRecord");
                if (mappingNode == null) {
                    mappingNode = (MappingDocument)this.metadata.getMappingNode(groupID);
                    record.setPropertyValue("mappingNodeForRecord", mappingNode);
                }
            }
        }
        return (MappingNode)mappingNode.clone();
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getVirtualDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getXMLTempGroups(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection tempGroups = (Collection)record.getPropertyValue("tempGroupsForDocument");
        if (tempGroups == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                tempGroups = (Collection)record.getPropertyValue("tempGroupsForDocument");
                if (tempGroups == null) {
                    tempGroups = this.metadata.getXMLTempGroups(groupID);
                    record.setPropertyValue("tempGroupsForDocument", tempGroups);
                }
            }
        }
        return tempGroups;
    }

    public int getCardinality(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getCardinality(groupID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getXMLSchemas(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        List schemas = (List)record.getPropertyValue("schemasForDocument");
        if (schemas == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                schemas = (List)record.getPropertyValue("schemasForDocument");
                if (schemas == null) {
                    schemas = this.metadata.getXMLSchemas(groupID);
                    record.setPropertyValue("schemasForDocument", schemas);
                }
            }
        }
        return schemas;
    }

    public String getNameInSource(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNameInSource(metadataID);
    }

    public int getElementLength(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getElementLength(elementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord record = (MetadataRecord)metadataID;
        Properties extentions = (Properties)record.getPropertyValue("extentionsForRecord");
        if (extentions == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                extentions = (Properties)record.getPropertyValue("extentionsForRecord");
                if (extentions == null) {
                    extentions = this.metadata.getExtensionProperties(metadataID);
                    record.setPropertyValue("extentionsForRecord", extentions);
                }
            }
        }
        return extentions;
    }

    public String getNativeType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNativeType(elementID);
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    public String getModeledType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getModeledType(elementID);
    }

    public String getModeledBaseType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getModeledBaseType(elementID);
    }

    public String getModeledPrimitiveType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getModeledPrimitiveType(elementID);
    }

    public boolean isTemporaryTable(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isTemporaryTable(groupID);
    }

    public TransformationMetadata getDelegate() {
        return this.metadata;
    }

    private MetadataRecord getRecordByName(String fullname, char recordType) {
        Assertion.isNotZeroLength((String)fullname);
        Object id = this.nameToIdCache.get(this.getLookupKey(fullname, recordType));
        if (id != null) {
            return this.getRecordByID(id);
        }
        return null;
    }

    private String getFullNameByPartialName(String partialName, char recordType) {
        Assertion.isNotZeroLength((String)partialName);
        return this.partialNameToFullNameCache.get(this.getLookupKey(partialName, recordType));
    }

    private MetadataRecord getRecordByID(Object id) {
        Assertion.isNotNull((Object)id);
        return this.idToRecordCache.get(id);
    }

    private void updateNameToIdCache(String fullName, char recordType, Object id) {
        if (!StringUtil.isEmpty((String)fullName) && id != null) {
            this.nameToIdCache.put(this.getLookupKey(fullName, recordType), id);
        }
    }

    private void updateIdToRecordCache(Object id, MetadataRecord record) {
        if (id != null && record != null) {
            this.idToRecordCache.put(id, record);
        }
    }

    private void updatePartialNameToFullName(String partialName, String fullName, char recordType) {
        if (!StringUtil.isEmpty((String)partialName) && !StringUtil.isEmpty((String)fullName)) {
            this.partialNameToFullNameCache.put(this.getLookupKey(partialName, recordType), fullName);
        }
    }

    private String getLookupKey(String name, char recordType) {
        return name.toUpperCase() + recordType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addToMetadataCache(Object metadataID, String key, Object value) throws MetaMatrixComponentException, QueryMetadataException {
        MetadataRecord record;
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        if (key.startsWith("groupinfo/")) {
            return this.groupInfoCache.put(metadataID + "/" + key, value);
        }
        MetadataRecord metadataRecord = record = (MetadataRecord)metadataID;
        synchronized (metadataRecord) {
            Object result = record.getPropertyValue(key);
            record.setPropertyValue(key, value);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromMetadataCache(Object metadataID, String key) throws MetaMatrixComponentException, QueryMetadataException {
        MetadataRecord record;
        ArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        if (key.startsWith("groupinfo/")) {
            return this.groupInfoCache.get(metadataID + "/" + key);
        }
        MetadataRecord metadataRecord = record = (MetadataRecord)metadataID;
        synchronized (metadataRecord) {
            return record.getPropertyValue(key);
        }
    }

    public boolean isScalarGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isScalarGroup(groupID);
    }
}

