/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.IOException;
import org.teiid.core.index.IDocument;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.index.IQueryResult;
import org.teiid.internal.core.index.IndexedFile;
import org.teiid.internal.core.index.WordEntry;

public abstract class IndexInput {
    protected int filePosition = 1;
    protected WordEntry currentWordEntry;
    protected int wordPosition = 1;
    private boolean openState;

    public abstract void clearCache();

    public abstract void close() throws IOException;

    public abstract IndexedFile getCurrentFile() throws IOException;

    public WordEntry getCurrentWordEntry() throws IOException {
        if (!this.hasMoreWords()) {
            return null;
        }
        return this.currentWordEntry;
    }

    public int getFilePosition() {
        return this.filePosition;
    }

    public void setOpen(boolean state) {
        this.openState = state;
    }

    public boolean isOpen() {
        return this.openState;
    }

    public abstract IndexedFile getIndexedFile(int var1) throws IOException;

    public abstract IndexedFile getIndexedFile(IDocument var1) throws IOException;

    public abstract int getNumFiles();

    public abstract int getNumWords();

    public abstract Object getSource();

    public boolean hasMoreFiles() {
        return this.getFilePosition() <= this.getNumFiles();
    }

    public boolean hasMoreWords() {
        return this.wordPosition <= this.getNumWords();
    }

    public abstract void moveToNextFile() throws IOException;

    public abstract void moveToNextWordEntry() throws IOException;

    public abstract void open() throws IOException;

    public abstract IEntryResult[] queryEntriesPrefixedBy(char[] var1) throws IOException;

    public abstract IQueryResult[] queryFilesReferringToPrefix(char[] var1) throws IOException;

    public abstract IQueryResult[] queryInDocumentNames(String var1) throws IOException;

    protected abstract void setFirstFile() throws IOException;

    protected abstract void setFirstWord() throws IOException;
}

