/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.util.Arrays;
import org.teiid.internal.core.index.Block;
import org.teiid.internal.core.index.CharOperation;
import org.teiid.internal.core.index.WordEntry;

public abstract class IndexBlock
extends Block {
    public IndexBlock(int blockSize) {
        super(blockSize);
    }

    public WordEntry findEntryPrefixedBy(char[] word, boolean isCaseSensitive) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.prefixEquals(entry.getWord(), word, isCaseSensitive)) continue;
            return entry;
        }
        return null;
    }

    public WordEntry findExactEntry(char[] word) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!Arrays.equals(entry.getWord(), word)) continue;
            return entry;
        }
        return null;
    }

    public abstract boolean isEmpty();

    public abstract boolean nextEntry(WordEntry var1);

    public void reset() {
    }
}

