/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import junit.framework.TestCase;
import org.teiid.internal.core.index.CharOperation;

public class TestCharOperation
extends TestCase {
    public TestCharOperation(String name) {
        super(name);
    }

    public void testCaseSentivieMatchWithoutWildCards1() {
        String pattern = "MyStringWithOutWildCards";
        String name = "MyStringWithOutWildCards";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true));
    }

    public void testCaseSentivieMatchWithoutWildCards2() {
        String pattern = "MyStringWithOutWildCards".toUpperCase();
        String name = "MyStringWithOutWildCards";
        TestCharOperation.assertTrue((!CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void testCaseSentivieMatchWithWildCards1() {
        String pattern = "MyString*Wild*";
        String name = "MyStringWithWildCards";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true));
    }

    public void testCaseSentivieMatchWithWildCards2() {
        String pattern = "MyString????Wil?Cards";
        String name = "MyStringWithWildCards";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true));
    }

    public void testCaseSentivieMatchWithWildCards3() {
        String pattern = "MyString*WildCards".toUpperCase();
        String name = "MyStringWithWildCards";
        TestCharOperation.assertTrue((!CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void testCaseSentivieMatchWithWildCards4() {
        String pattern = "MyString????WildCards".toUpperCase();
        String name = "MyStringWithWildCards";
        TestCharOperation.assertTrue((!CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void testCaseSentivieMatchWithWildCards5() {
        String pattern = "*Supplie?";
        String name = "PartsSupplier";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true));
    }

    public void testCaseSentivieMatchWithWildCards6() {
        String pattern = "*Supplie*";
        String name = "PartsSupplier";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)true));
    }

    public void testCaseInSentivieMatchWithoutWildCards() {
        String pattern = "MyStringWithOutWildCards".toUpperCase();
        String name = "MyStringWithOutWildCards";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)false));
    }

    public void testCaseInSentivieMatchWithWildCards1() {
        String pattern = "MyString*WildCards".toUpperCase();
        String name = "MyStringWithWildCards";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)false));
    }

    public void testCaseInSentivieMatchWithWildCards2() {
        String pattern = "MyString????WildCards".toUpperCase();
        String name = "MyStringWithWildCards";
        TestCharOperation.assertTrue((boolean)CharOperation.match((char[])pattern.toCharArray(), (char[])name.toCharArray(), (boolean)false));
    }
}

