/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.vfs.VirtualFile;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.LRUCache;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionMetadataReader;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.PureZipFileSystem;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.VDBResources;

public class VDBMetadataFactory {
    public static LRUCache<URL, TransformationMetadata> VDB_CACHE = new LRUCache(10);

    public static TransformationMetadata getVDBMetadata(String vdbFile) {
        try {
            File f = new File(vdbFile);
            return VDBMetadataFactory.getVDBMetadata(f.getName(), f.toURI().toURL(), null);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static TransformationMetadata getVDBMetadata(String vdbName, URL vdbURL, URL udfFile) throws IOException {
        TransformationMetadata vdbmetadata = (TransformationMetadata)VDB_CACHE.get((Object)vdbURL);
        if (vdbmetadata != null) {
            return vdbmetadata;
        }
        try {
            IndexVDB imf = VDBMetadataFactory.loadMetadata(vdbName, vdbURL);
            VDBResources.Resource r = (VDBResources.Resource)imf.resources.getEntriesPlusVisibilities().get("/META-INF/vdb.xml");
            VDBMetaData vdb = null;
            if (r != null) {
                vdb = VDBMetadataParser.unmarshell((InputStream)r.openStream());
            }
            List methods = null;
            List<FunctionTree> trees = null;
            if (udfFile != null) {
                String schema = FileUtils.getFilenameWithoutExtension((String)udfFile.getPath());
                methods = FunctionMetadataReader.loadFunctionMethods((InputStream)udfFile.openStream());
                trees = Arrays.asList(new FunctionTree(schema, (FunctionMetadataSource)new UDFSource((Collection)methods), true));
            }
            SystemFunctionManager sfm = SystemMetadata.getInstance().getSystemFunctionManager();
            vdbmetadata = new TransformationMetadata(vdb, new CompositeMetadataStore(Arrays.asList(SystemMetadata.getInstance().getSystemStore(), imf.store)), (Map)imf.resources.getEntriesPlusVisibilities(), sfm.getSystemFunctions(), trees);
            VDB_CACHE.put((Object)vdbURL, (Object)vdbmetadata);
            return vdbmetadata;
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public static IndexVDB loadMetadata(String vdbName, URL url) throws IOException, MalformedURLException {
        VirtualFile root;
        try {
            root = PureZipFileSystem.mount((URL)url);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        IndexVDB result = new IndexVDB();
        result.resources = new VDBResources(root, null);
        IndexMetadataRepository store = new IndexMetadataRepository();
        result.store = store.load((Collection)SystemMetadata.getInstance().getDataTypes(), result.resources);
        return result;
    }

    public static class IndexVDB {
        public MetadataStore store;
        public VDBResources resources;
    }
}

