/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.EmbeddedContainer;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.resources.EntitiesRequestResource;
import org.odata4j.producer.resources.EntityRequestResource;
import org.odata4j.producer.resources.MetadataResource;
import org.odata4j.producer.resources.ODataBatchProvider;
import org.odata4j.producer.resources.ServiceDocumentResource;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.Client;
import org.teiid.odata.EntityList;
import org.teiid.odata.LocalClient;
import org.teiid.odata.MockProvider;
import org.teiid.odata.ODataExceptionMappingProvider;
import org.teiid.odata.SQLParam;
import org.teiid.odata.UpdateResponse;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestODataIntegration
extends BaseResourceTest {
    private static TransformationMetadata metadata;

    @BeforeClass
    public static void before() throws Exception {
        deployment = EmbeddedContainer.start((String)"/odata/northwind");
        dispatcher = deployment.getDispatcher();
        deployment.getRegistry().addPerRequestResource(EntitiesRequestResource.class);
        deployment.getRegistry().addPerRequestResource(EntityRequestResource.class);
        deployment.getRegistry().addPerRequestResource(MetadataResource.class);
        deployment.getRegistry().addPerRequestResource(ServiceDocumentResource.class);
        deployment.getProviderFactory().registerProvider(ODataBatchProvider.class);
        deployment.getProviderFactory().addExceptionMapper(ODataExceptionMappingProvider.class);
        deployment.getProviderFactory().addContextResolver(MockProvider.class);
        metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
    }

    @Test
    public void testMetadata() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        StringWriter sw = new StringWriter();
        EdmxFormatWriter.write((EdmDataServices)client.getMetadata(), (Writer)sw);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/$metadata"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)sw.toString(), (Object)response.getEntity());
    }

    protected Client mockClient2() {
        Client client = (Client)Mockito.mock(Client.class);
        VDBMetaData vdb = (VDBMetaData)Mockito.mock(VDBMetaData.class);
        ModelMetaData model = (ModelMetaData)Mockito.mock(ModelMetaData.class);
        Mockito.stub((Object)model.isVisible()).toReturn((Object)false);
        Mockito.stub((Object)vdb.getModel("nw")).toReturn((Object)model);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        EdmDataServices eds = LocalClient.buildMetadata((VDBMetaData)vdb, (MetadataStore)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        return client;
    }

    @Test
    public void testMetadataVisibility() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient2();
        StringWriter sw = new StringWriter();
        EdmxFormatWriter.write((EdmDataServices)client.getMetadata(), (Writer)sw);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/$metadata"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)sw.toString(), (Object)response.getEntity());
        String edm = "<?xml version=\"1.0\" encoding=\"utf-8\"?><edmx:Edmx Version=\"1.0\" xmlns:edmx=\"http://schemas.microsoft.com/ado/2007/06/edmx\"><edmx:DataServices m:DataServiceVersion=\"2.0\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"></edmx:DataServices></edmx:Edmx>";
        Assert.assertEquals((Object)edm, (Object)response.getEntity());
    }

    protected Client mockClient() {
        Client client = (Client)Mockito.mock(Client.class);
        VDBMetaData vdb = (VDBMetaData)Mockito.mock(VDBMetaData.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        EdmDataServices eds = LocalClient.buildMetadata((VDBMetaData)vdb, (MetadataStore)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        return client;
    }

    @Test
    public void testProjectedColumns() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor entitySet = ArgumentCaptor.forClass(EdmEntitySet.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        Mockito.when((Object)result.get(0)).thenReturn((Object)entity);
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class))).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)entitySet.capture(), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class));
        Assert.assertEquals((Object)"SELECT g0.CustomerID, g0.CompanyName, g0.Address FROM nw.Customers AS g0 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testCheckGeneratedColumns() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor insertCmd = ArgumentCaptor.forClass(Command.class);
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor entitySet = ArgumentCaptor.forClass(EdmEntitySet.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        Mockito.when((Object)result.get(0)).thenReturn((Object)entity);
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class))).thenReturn((Object)result);
        UpdateResponse respose = new UpdateResponse(){

            public int getUpdateCount() {
                return 1;
            }

            public Map<String, Object> getGeneratedKeys() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", 1234);
                return map;
            }
        };
        String post = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<entry xml:base=\"http://host/service.svc/\"\nxmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\"\nxmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"\nxmlns=\"http://www.w3.org/2005/Atom\">\n    <content type=\"application/xml\">\n        <m:properties>\n            <d:CompanyName>JBoss</d:CompanyName>\n            <d:ContactName>Joe</d:ContactName>\n            <d:ContactTitle>1970</d:ContactTitle>\n            <d:Address>123 Main Street</d:Address>\n            <d:City>STL</d:City>\n            <d:Region>MidWest</d:Region>\n            <d:PostalCode>12345</d:PostalCode>\n            <d:Country>USA</d:Country>\n            <d:Phone>123234</d:Phone>\n        </m:properties>\n    </content>\n</entry>";
        Mockito.when((Object)client.executeUpdate((Command)Mockito.any(Command.class), Mockito.anyListOf(SQLParam.class))).thenReturn((Object)respose);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers"));
        request.body("application/atom+xml", (Object)post);
        ClientResponse response = request.post();
        ((Client)Mockito.verify((Object)client)).executeUpdate((Command)insertCmd.capture(), Mockito.anyListOf(SQLParam.class));
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)entitySet.capture(), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class));
        Assert.assertEquals((Object)"INSERT INTO nw.Customers (CompanyName, ContactName, ContactTitle, Address, City, Region, PostalCode, Country, Phone) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object)((Command)insertCmd.getValue()).toString());
        Assert.assertEquals((Object)"SELECT g0.CustomerID, g0.CompanyName, g0.ContactName, g0.ContactTitle, g0.Address, g0.City, g0.Region, g0.PostalCode, g0.Country, g0.Phone, g0.Fax FROM nw.Customers AS g0 WHERE g0.CustomerID = 1234 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)201L, (long)response.getStatus());
    }

    @Test
    public void testProcedure() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor params = ArgumentCaptor.forClass(List.class);
        Mockito.when((Object)client.executeCall((String)Mockito.any(String.class), Mockito.anyListOf(SQLParam.class), (EdmType)Mockito.any(EdmType.class))).thenReturn((Object)Responses.simple((EdmSimpleType)EdmSimpleType.INT32, (String)"return", null));
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/getCustomers?p2=datetime'2011-09-11T00:00:00'&p3=2.0M"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeCall((String)sql.capture(), (List)params.capture(), (EdmType)Mockito.any(EdmType.class));
        Assert.assertEquals((Object)"{? = call nw.getCustomers(p2=>?,p3=>?)}", (Object)((String)sql.getValue()).toString());
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)111, (int)8, (int)11, (int)0, (int)0, (int)0, (int)0), (Object)((SQLParam)((List)params.getValue()).get((int)0)).value);
        Assert.assertEquals((Object)BigDecimal.valueOf(2.0), (Object)((SQLParam)((List)params.getValue()).get((int)1)).value);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testSkipNoPKTable() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/NoPKTable"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity()).endsWith("<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>NotFoundException</code><message lang=\"en-US\">TEIID16011 EntitySet \"NoPKTable\" is not found; Check the spelling, use modelName.tableName; The table that representing the Entity type must either have a PRIMARY KEY or UNIQUE key(s)</message></error>"));
    }

    @Test
    public void testError() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class))).thenThrow(new Throwable[]{new NullPointerException()});
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity()).endsWith("<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>ServerErrorException</code><message lang=\"en-US\">Internal Server Error</message></error>"));
    }

    @Test
    public void testSelect() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor entitySet = ArgumentCaptor.forClass(EdmEntitySet.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        Mockito.when((Object)result.get(0)).thenReturn((Object)entity);
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class))).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)entitySet.capture(), (LinkedHashMap)Mockito.any(), (QueryInfo)Mockito.any(QueryInfo.class));
        Assert.assertEquals((Object)"SELECT g0.CustomerID, g0.CompanyName, g0.Address FROM nw.Customers AS g0 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntity() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key) as select 'a';");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCharacterReplacement() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.setSchemaSourceType("ddl");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.setSchemaText("create view x (a string primary key, b char, c string[], d integer) as select 'ab\u0000cd\u0001', char(22), ('a\u00021','b1'), 1;");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("invalid-xml10-character-replacement", " ");
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("ab cd "));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("a 1"));
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayResults() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.setSchemaSourceType("ddl");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.setSchemaText("create view x (a string primary key, b integer[], c string[][]) as select 'x', (1, 2, 3), (('a','b'),('c','d'));");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$select=a,b"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("1, 2, 3"));
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            response = request.get(String.class);
            Assert.assertEquals((long)500L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipToken() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.setSchemaSourceType("ddl");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.setSchemaText("create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            JSONValueExtractor contentHandler = new JSONValueExtractor("__next");
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNotNull((Object)contentHandler.next);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("abc"));
            Assert.assertTrue((!((String)response.getEntity()).contains("xyz") ? 1 : 0) != 0);
            URL url = new URL((String)contentHandler.value);
            String skip = this.getQueryParameter(URLDecoder.decode(url.getQuery(), "UTF-8"), "$skiptoken");
            Assert.assertTrue((skip.indexOf("--") != -1 ? 1 : 0) != 0);
            request = new ClientRequest((String)contentHandler.value);
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((!((String)response.getEntity()).contains("abc") ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("xyz"));
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNull((Object)contentHandler.value);
        }
        finally {
            es.stop();
        }
    }

    public String getQueryParameter(String queryPath, String param) {
        if (queryPath != null) {
            StringTokenizer st = new StringTokenizer(queryPath, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(61);
                if (index == -1) continue;
                String key = token.substring(0, index);
                String value = token.substring(index + 1);
                if (!key.equals(param)) continue;
                return value;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSkipToken() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.setSchemaSourceType("ddl");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.setSchemaText("create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("batch-size", "0");
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            JSONValueExtractor contentHandler = new JSONValueExtractor("__next");
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNotNull((Object)contentHandler.next);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("abc"));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("xyz"));
            Assert.assertNull((Object)contentHandler.value);
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCount() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.setSchemaSourceType("ddl");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.setSchemaText("create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$inlinecount=allpages&$top=1&$skip=1"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            JSONValueExtractor contentHandler = new JSONValueExtractor("__count");
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertEquals((Object)"2", (Object)contentHandler.value);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("xyz"));
            Assert.assertTrue((!((String)response.getEntity()).contains("abc") ? 1 : 0) != 0);
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$inlinecount=allpages&$skip=1"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertEquals((Object)"2", (Object)contentHandler.value);
            contentHandler.key = "__next";
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNull((Object)contentHandler.value);
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$inlinecount=allpages"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNotNull((Object)contentHandler.value);
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x/$count"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"2", (Object)response.getEntity());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompositeKeyUpdates() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        hc.addUpdate("UPDATE x SET c = 5 WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setSchemaSourceType("ddl");
            mmd.setSchemaText("create foreign table x (a string, b string, c integer, primary key (a, b)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',b='b')"));
            ClientResponse response = request.delete(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')"));
            response = request.delete(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',a='b')"));
            response = request.delete(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',b='b')"));
            request.body("application/json", (Object)"{\"c\":5}");
            response = request.put(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatch() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setSchemaSourceType("ddl");
            mmd.setSchemaText("create foreign table x (a string, b string, c integer, primary key (a, b)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            String post = "Content-Type: application/http\nContent-Transfer-Encoding:binary\n\nDELETE /odata/northwind/x(a='a',b='b') HTTP/1.1\n--batch_36522ad7-fc75-4b56-8c71-56071383e77b\n";
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers/$batch"));
            request.body("multipart/mixed", (Object)post);
            ClientResponse response = request.post(String.class);
            Assert.assertEquals((long)202L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJsonProcedureResultSet() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory();
        hc.addData("EXEC x()", Arrays.asList(Arrays.asList("x"), Arrays.asList("y")));
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setSchemaSourceType("ddl");
            mmd.setSchemaText("create foreign procedure x () returns table(y string);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicTypes() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setSchemaSourceType("ddl");
            mmd.addSourceMapping("x", "x", null);
            MetadataStore ms = RealMetadataFactory.exampleBQTStore();
            Schema s = ms.getSchema("BQT1");
            KeyRecord pk = new KeyRecord(KeyRecord.Type.Primary);
            Table smalla = s.getTable("SmallA");
            pk.setName("pk");
            pk.addColumn(smalla.getColumnByName("IntKey"));
            smalla.setPrimaryKey(pk);
            String ddl = DDLStringVisitor.getDDLString((Schema)s, EnumSet.allOf(Admin.SchemaObjectType.class), (String)"SmallA");
            mmd.setSchemaText(ddl);
            HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

                protected List<? extends List<?>> getData(QueryExpression command) {
                    Class[] colTypes = command.getProjectedQuery().getColumnTypes();
                    ArrayList<ElementSymbol> cols = new ArrayList<ElementSymbol>();
                    for (int i = 0; i < colTypes.length; ++i) {
                        ElementSymbol elementSymbol = new ElementSymbol("X");
                        elementSymbol.setType(colTypes[i]);
                        cols.add(elementSymbol);
                    }
                    return Arrays.asList(AutoGenDataService.createResults(cols, (int)1, (boolean)false));
                }
            };
            es.addTranslator("x", (ExecutionFactory)hc);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/SmallA?$format=json&$select=TimeValue"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionProperties() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.setSchemaSourceType("ddl");
            mmd.setSchemaText("create view v as select 1");
            Properties props = new Properties();
            props.setProperty("connection.resultSetCacheMode", "true");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            LocalClient lc = new LocalClient("northwind", 1, props);
            lc.setDriver(td);
            ConnectionImpl impl = lc.getConnection();
            Assert.assertEquals((Object)"true", (Object)impl.getExecutionProperty("resultSetCacheMode"));
        }
        finally {
            es.stop();
        }
    }

    private OEntity createCustomersEntity(EdmDataServices metadata) {
        EdmEntitySet entitySet = metadata.findEdmEntitySet("Customers");
        OEntityKey entityKey = OEntityKey.parse((String)"CustomerID='12'");
        ArrayList<OProperty> properties = new ArrayList<OProperty>();
        properties.add(OProperties.string((String)"CompanyName", (String)"teiid"));
        properties.add(OProperties.string((String)"ContactName", (String)"contact-name"));
        properties.add(OProperties.string((String)"ContactTitle", (String)"contact-title"));
        properties.add(OProperties.string((String)"Address", (String)"address"));
        properties.add(OProperties.string((String)"City", (String)"city"));
        properties.add(OProperties.string((String)"Region", (String)"region"));
        properties.add(OProperties.string((String)"PostalCode", (String)"postal-code"));
        properties.add(OProperties.string((String)"Country", (String)"country"));
        properties.add(OProperties.string((String)"Phone", (String)"555-1212"));
        properties.add(OProperties.string((String)"Fax", (String)"555-1212"));
        OEntity entity = OEntities.create((EdmEntitySet)entitySet, (OEntityKey)entityKey, properties, null);
        return entity;
    }

    private static final class JSONValueExtractor
    implements ContentHandler {
        Object value;
        boolean next;
        String key;

        private JSONValueExtractor(String key) {
            this.key = key;
        }

        public boolean startObjectEntry(String key) throws ParseException, IOException {
            if (key.equals(this.key)) {
                this.next = true;
            }
            return true;
        }

        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        public void startJSON() throws ParseException, IOException {
        }

        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        public boolean primitive(Object value) throws ParseException, IOException {
            if (this.next) {
                this.value = value;
                this.next = false;
            }
            return true;
        }

        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        public void endJSON() throws ParseException, IOException {
        }

        public boolean endArray() throws ParseException, IOException {
            return true;
        }
    }
}

