/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.util.LinkedHashMap;
import java.util.Map;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotFoundException;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;
import org.teiid.odata.DocumentNode;
import org.teiid.odata.ODataPlugin;
import org.teiid.query.sql.symbol.GroupSymbol;

public class DocumentNode {
    private Table entityTable;
    private Procedure entityProcedure;
    private GroupSymbol group;
    private DocumentNode expandNode;
    private DocumentNode parentNode;
    private EdmEntitySet edmEntitySet;
    private LinkedHashMap<String, ProjectedColumn> projectedColumns = new LinkedHashMap();

    public DocumentNode(Table entityTable, GroupSymbol group) {
        this.entityTable = entityTable;
        this.group = group;
    }

    public DocumentNode(Procedure procedure, GroupSymbol group) {
        this.entityProcedure = procedure;
        this.group = group;
    }

    public Table getEntityTable() {
        return this.entityTable;
    }

    public GroupSymbol getEntityGroup() {
        return this.group;
    }

    public EdmEntityType getEntityType(EdmDataServices metadata) {
        return this.getEntitySet(metadata).getType();
    }

    public Map<String, ProjectedColumn> getProjectedColumns() {
        return this.projectedColumns;
    }

    public void addProjectColumn(String columnName, int ordinal, boolean visible, EdmType type) {
        this.projectedColumns.put(columnName, new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setExpandNode(DocumentNode node) {
        this.expandNode = node;
        this.expandNode.parentNode = this;
    }

    public DocumentNode getExpandNode() {
        return this.expandNode;
    }

    public DocumentNode getParentNode() {
        return this.parentNode;
    }

    public EdmEntitySet getEntitySet(EdmDataServices metadata) {
        assert (metadata != null);
        if (this.edmEntitySet == null) {
            this.edmEntitySet = metadata.findEdmEntitySet(this.entityTable.getFullName());
            if (this.edmEntitySet == null) {
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16011, new Object[]{this.entityTable.getFullName()}));
            }
        }
        return this.edmEntitySet;
    }
}

