/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.servlet.ConfigurationBootstrap;
import org.jboss.resteasy.plugins.server.servlet.HttpRequestFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpResponseFactory;
import org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.teiid.odata.ProxyHttpServletRequest;

public class ODataServletContainerDispatcher
extends ServletContainerDispatcher {
    private static final Logger logger = Logger.getLogger(ServletContainerDispatcher.class);
    ThreadLocal<String> servletMapping = new ThreadLocal();
    ThreadLocal<String> proxyBaseURI = new ThreadLocal();

    public void init(ServletContext servletContext, ConfigurationBootstrap bootstrap, HttpRequestFactory requestFactory, HttpResponseFactory responseFactory) throws ServletException {
        super.init(servletContext, bootstrap, requestFactory, responseFactory);
        this.servletMapping.set(bootstrap.getParameter("resteasy.servlet.mapping.prefix"));
        String proxyURI = bootstrap.getParameter("proxy-base-uri");
        if (proxyURI != null && proxyURI.startsWith("${") && proxyURI.endsWith("}")) {
            proxyURI = proxyURI.substring(2, proxyURI.length() - 1);
            proxyURI = System.getProperty(proxyURI);
        }
        this.proxyBaseURI.set(proxyURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response, boolean handleNotFound) throws IOException, NotFoundException {
        try {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.providerFactory);
            }
            HttpHeaders headers = null;
            UriInfoImpl uriInfo = null;
            try {
                String proxyURI = (String)this.proxyBaseURI.get();
                if (proxyURI != null) {
                    request = new ProxyHttpServletRequest(request, proxyURI);
                }
                headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
                uriInfo = ServletUtil.extractUriInfo((HttpServletRequest)request, (String)((String)this.servletMapping.get()));
            }
            catch (Exception e) {
                response.sendError(400);
                logger.warn("Failed to parse request.", (Throwable)e);
                ResteasyProviderFactory defaultInstance2 = ResteasyProviderFactory.getInstance();
                if (defaultInstance2 instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.pop();
                }
                return;
            }
            HttpResponse theResponse = this.responseFactory.createResteasyHttpResponse(response);
            HttpRequest in = this.requestFactory.createResteasyHttpRequest(httpMethod, request, headers, uriInfo, theResponse, response);
            try {
                ResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)request);
                ResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)response);
                ResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(request));
                if (handleNotFound) {
                    this.dispatcher.invoke(in, theResponse);
                } else {
                    ((SynchronousDispatcher)this.dispatcher).invokePropagateNotFound(in, theResponse);
                }
            }
            finally {
                ResteasyProviderFactory.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }

    public void setServletMapping(String mapping) {
        this.servletMapping.set(mapping);
    }
}

