/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotAcceptableException;
import org.odata4j.producer.CollectionResponse;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.QueryInfo;
import org.teiid.core.types.TransformationException;
import org.teiid.odata.DocumentNode;
import org.teiid.odata.EntityCollector;
import org.teiid.odata.LocalClient;

public class ComplexCollection
extends ArrayList<OComplexObject>
implements CollectionResponse<OComplexObject>,
EntityCollector<OComplexObject> {
    private static final long serialVersionUID = -337908504068541458L;
    private EdmComplexType type;
    private QueryInfo queryInfo;
    private int count = 0;
    private String skipToken;
    private DocumentNode documentNode;

    public ComplexCollection(EdmComplexType type, DocumentNode node, QueryInfo queryInfo) {
        this.type = type;
        this.queryInfo = queryInfo;
        this.documentNode = node;
    }

    private EdmType getType(String name) {
        for (EdmProperty property : this.type.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property.getType();
        }
        return EdmSimpleType.STRING;
    }

    public OComplexObject addRow(Object previous, ResultSet rs, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        ArrayList<OProperty> row = new ArrayList<OProperty>();
        if (this.documentNode.getProjectedColumns().isEmpty()) {
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                Object value = rs.getObject(i + 1);
                String propName = rs.getMetaData().getColumnLabel(i + 1);
                OProperty property = LocalClient.buildPropery((String)propName, (EdmType)this.getType(propName), (Object)value, (String)invalidCharacterReplacement);
                row.add(property);
            }
        } else {
            for (DocumentNode.ProjectedColumn pc : this.documentNode.getProjectedColumns().values()) {
                OProperty property = LocalClient.buildPropery((String)pc.name(), (EdmType)pc.type(), (Object)rs.getObject(pc.ordinal()), (String)invalidCharacterReplacement);
                row.add(property);
            }
        }
        OComplexObject erow = OComplexObjects.create((EdmComplexType)this.type, row);
        this.add((Object)erow);
        return erow;
    }

    public void lastRow(Object last) {
    }

    public boolean isSameRow(Object previous, Object current) {
        return false;
    }

    public void setInlineCount(int count) {
        this.count = count;
    }

    public void setSkipToken(String skipToken) {
        this.skipToken = skipToken;
    }

    public OCollection<OComplexObject> getCollection() {
        OCollection.Builder resultRows = OCollections.newBuilder((EdmType)this.type);
        for (OComplexObject oco : this) {
            resultRows.add((OObject)oco);
        }
        return resultRows.build();
    }

    public String getCollectionName() {
        String collectionName = this.type.getFullyQualifiedTypeName();
        collectionName = collectionName.replace("(", "_");
        collectionName = collectionName.replace(")", "_");
        return collectionName;
    }

    public Integer getInlineCount() {
        if (this.queryInfo.inlineCount == InlineCount.ALLPAGES) {
            return this.count;
        }
        return null;
    }

    public String getSkipToken() {
        return this.skipToken;
    }

    public EdmEntitySet getEntitySet() {
        throw new NotAcceptableException("Only Complex types");
    }
}

