/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmType;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.QueryInfo;
import org.teiid.core.types.TransformationException;
import org.teiid.odata.DocumentNode;
import org.teiid.odata.EntityCollector;
import org.teiid.odata.LocalClient;
import org.teiid.translator.odata.ODataTypeManager;

/*
 * Exception performing whole class analysis ignored.
 */
class EntityList
extends ArrayList<OEntity>
implements EntitiesResponse,
EntityCollector<OEntity> {
    private static final long serialVersionUID = -6805594611842072222L;
    private int count = 0;
    private String skipToken;
    private QueryInfo queryInfo;
    private ArrayList<OEntity> expandEntities = new ArrayList();
    private DocumentNode documentNode;
    private EdmDataServices metadata;

    public EntityList(DocumentNode node, EdmDataServices metadata, QueryInfo queryInfo) {
        this.documentNode = node;
        this.metadata = metadata;
        this.queryInfo = queryInfo;
    }

    public OEntity addRow(Object previous, ResultSet rs, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        OEntity previousEntity = (OEntity)previous;
        OEntity entity = this.buildEntity(rs, this.documentNode, this.documentNode.getEntitySet(this.metadata), invalidCharacterReplacement);
        if (previousEntity != null && !this.isSameRow(previousEntity, entity)) {
            if (this.expandEntities.isEmpty()) {
                this.add((Object)previousEntity);
            } else {
                EdmEntitySet expandEntitySet = this.documentNode.getExpandNode().getEntitySet(this.metadata);
                this.add((Object)EntityList.buildEntityWithExpand((OEntity)previousEntity, (EdmEntitySet)expandEntitySet, (List)this.expandEntities));
                this.expandEntities.clear();
            }
        }
        if (this.documentNode.getExpandNode() != null) {
            EdmEntitySet expandES = this.documentNode.getExpandNode().getEntitySet(this.metadata);
            OEntity expand = this.buildEntity(rs, this.documentNode.getExpandNode(), expandES, invalidCharacterReplacement);
            this.expandEntities.add(expand);
        }
        return entity;
    }

    private static OEntity buildEntityWithExpand(OEntity srcEntity, EdmEntitySet expandES, List<OEntity> expands) {
        if (expands.isEmpty()) {
            return srcEntity;
        }
        ArrayList<Object> links = new ArrayList<Object>();
        for (OLink link : srcEntity.getLinks()) {
            if (link.getTitle().equals(expandES.getName())) {
                if (link.isCollection()) {
                    links.add(OLinks.relatedEntitiesInline((String)link.getRelation(), (String)link.getTitle(), (String)link.getHref(), new ArrayList<OEntity>(expands)));
                    continue;
                }
                links.add(OLinks.relatedEntityInline((String)link.getRelation(), (String)link.getTitle(), (String)link.getHref(), (OEntity)expands.get(0)));
                continue;
            }
            links.add(link);
        }
        return OEntities.create((EdmEntitySet)srcEntity.getEntitySet(), (OEntityKey)srcEntity.getEntityKey(), (List)srcEntity.getProperties(), links);
    }

    private boolean isSameRow(OEntity previous, OEntity current) {
        EdmEntityType entityType = current.getEntityType();
        for (String name : entityType.getKeys()) {
            if (current.getProperty(name).getValue().equals(previous.getProperty(name).getValue())) continue;
            return false;
        }
        return true;
    }

    public void lastRow(Object last) {
        OEntity entity = (OEntity)last;
        if (entity != null) {
            if (this.expandEntities.isEmpty()) {
                this.add((Object)entity);
            } else {
                EdmEntitySet expandEntitySet = this.documentNode.getExpandNode().getEntitySet(this.metadata);
                this.add((Object)EntityList.buildEntityWithExpand((OEntity)entity, (EdmEntitySet)expandEntitySet, (List)this.expandEntities));
                this.expandEntities.clear();
            }
        }
    }

    public boolean isSameRow(Object previous, Object current) {
        return this.isSameRow((OEntity)previous, (OEntity)current);
    }

    private OEntity buildEntity(ResultSet rs, DocumentNode node, EdmEntitySet edmEntitySet, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        LinkedHashMap<String, OProperty> properties = new LinkedHashMap<String, OProperty>();
        if (node.getProjectedColumns().isEmpty()) {
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                Object value = rs.getObject(i + 1);
                String propName = rs.getMetaData().getColumnLabel(i + 1);
                String tableName = rs.getMetaData().getTableName(i + 1);
                if (!tableName.equals(node.getEntityTable().getName())) continue;
                EdmType type = ODataTypeManager.odataType((String)node.getEntityTable().getColumnByName(propName).getRuntimeType());
                OProperty property = LocalClient.buildPropery((String)propName, (EdmType)type, (Object)value, (String)invalidCharacterReplacement);
                properties.put(rs.getMetaData().getColumnLabel(i + 1), property);
            }
        } else {
            for (DocumentNode.ProjectedColumn pc : node.getProjectedColumns().values()) {
                Object value = rs.getObject(pc.ordinal());
                OProperty property = LocalClient.buildPropery((String)pc.name(), (EdmType)pc.type(), (Object)value, (String)invalidCharacterReplacement);
                properties.put(pc.name(), property);
            }
        }
        OEntityKey key = OEntityKey.infer((EdmEntitySet)edmEntitySet, new ArrayList(properties.values()));
        ArrayList<Object> links = new ArrayList<Object>();
        for (EdmNavigationProperty navProperty : edmEntitySet.getType().getNavigationProperties()) {
            if (node.getParentNode() != null && navProperty.getName().equals(node.getParentNode().getEntityTable().getName())) continue;
            if (navProperty.getToRole().getMultiplicity().equals((Object)EdmMultiplicity.ZERO_TO_ONE)) {
                links.add(OLinks.relatedEntity((String)navProperty.getRelationship().getName(), (String)navProperty.getToRole().getRole(), (String)key.toKeyString()));
                continue;
            }
            links.add(OLinks.relatedEntities((String)navProperty.getRelationship().getName(), (String)navProperty.getToRole().getRole(), (String)key.toKeyString()));
        }
        ArrayList<Object> projected = new ArrayList();
        if (node.getProjectedColumns().isEmpty()) {
            projected = new ArrayList(properties.values());
        } else {
            for (DocumentNode.ProjectedColumn pc : node.getProjectedColumns().values()) {
                if (!properties.containsKey(pc.name()) || !pc.visible()) continue;
                projected.add(properties.get(pc.name()));
            }
        }
        return OEntities.create((EdmEntitySet)edmEntitySet, (OEntityKey)key, projected, links);
    }

    public void setSkipToken(String skipToken) {
        this.skipToken = skipToken;
    }

    public void setInlineCount(int count) {
        this.count = count;
    }

    public EdmEntitySet getEntitySet() {
        return this.documentNode.getEntitySet(this.metadata);
    }

    public List<OEntity> getEntities() {
        return this;
    }

    public Integer getInlineCount() {
        if (this.queryInfo.inlineCount == InlineCount.ALLPAGES && this.documentNode.getExpandNode() == null) {
            return this.count;
        }
        return null;
    }

    public String getSkipToken() {
        return this.skipToken;
    }
}

