/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.odata4j.expression.AddExpression;
import org.odata4j.expression.AndExpression;
import org.odata4j.expression.BinaryLiteral;
import org.odata4j.expression.BoolMethodExpression;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.BooleanLiteral;
import org.odata4j.expression.ByteLiteral;
import org.odata4j.expression.CastExpression;
import org.odata4j.expression.CeilingMethodCallExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.ConcatMethodCallExpression;
import org.odata4j.expression.DateTimeLiteral;
import org.odata4j.expression.DateTimeOffsetLiteral;
import org.odata4j.expression.DayMethodCallExpression;
import org.odata4j.expression.DecimalLiteral;
import org.odata4j.expression.DivExpression;
import org.odata4j.expression.DoubleLiteral;
import org.odata4j.expression.EndsWithMethodCallExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.FloorMethodCallExpression;
import org.odata4j.expression.GeExpression;
import org.odata4j.expression.GtExpression;
import org.odata4j.expression.GuidLiteral;
import org.odata4j.expression.HourMethodCallExpression;
import org.odata4j.expression.IndexOfMethodCallExpression;
import org.odata4j.expression.Int64Literal;
import org.odata4j.expression.IntegralLiteral;
import org.odata4j.expression.IsofExpression;
import org.odata4j.expression.LeExpression;
import org.odata4j.expression.LengthMethodCallExpression;
import org.odata4j.expression.LtExpression;
import org.odata4j.expression.MinuteMethodCallExpression;
import org.odata4j.expression.ModExpression;
import org.odata4j.expression.MonthMethodCallExpression;
import org.odata4j.expression.MulExpression;
import org.odata4j.expression.NeExpression;
import org.odata4j.expression.NegateExpression;
import org.odata4j.expression.NotExpression;
import org.odata4j.expression.NullLiteral;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.ReplaceMethodCallExpression;
import org.odata4j.expression.RoundMethodCallExpression;
import org.odata4j.expression.SByteLiteral;
import org.odata4j.expression.SecondMethodCallExpression;
import org.odata4j.expression.SingleLiteral;
import org.odata4j.expression.StartsWithMethodCallExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.SubExpression;
import org.odata4j.expression.SubstringMethodCallExpression;
import org.odata4j.expression.SubstringOfMethodCallExpression;
import org.odata4j.expression.TimeLiteral;
import org.odata4j.expression.ToLowerMethodCallExpression;
import org.odata4j.expression.ToUpperMethodCallExpression;
import org.odata4j.expression.TrimMethodCallExpression;
import org.odata4j.expression.YearMethodCallExpression;
import org.teiid.core.types.DataTypeManager;
import org.teiid.odata.ODataHierarchyVisitor;
import org.teiid.odata.SQLParam;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.translator.odata.ODataTypeManager;

public class ODataExpressionVisitor
extends ODataHierarchyVisitor {
    private ArrayList<SQLParam> params = new ArrayList();
    private boolean prepared = true;
    private Stack<Expression> stack = new Stack();

    public ODataExpressionVisitor(boolean prepared) {
        this.prepared = prepared;
    }

    boolean isPrepared() {
        return this.prepared;
    }

    boolean isEmpty() {
        return this.stack.isEmpty();
    }

    Expression getExpression() {
        return (Expression)this.stack.pop();
    }

    void setExpression(Expression expr) {
        this.stack.push(expr);
    }

    public List<SQLParam> getParameters() {
        return this.params;
    }

    public void visit(AddExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("+", new Expression[]{lhs, rhs}));
    }

    public void visit(AndExpression expr) {
        this.visitNode((CommonExpression)expr.getLHS());
        this.visitNode((CommonExpression)expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompoundCriteria criteria = new CompoundCriteria(0, (Criteria)lhs, (Criteria)rhs);
        this.stack.push(criteria);
    }

    public void visit(BooleanLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(16)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(CastExpression expr) {
        this.visitNode(expr.getExpression());
        Constant rhs = new Constant((Object)ODataTypeManager.teiidType((String)expr.getType()));
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("CONVERT", new Expression[]{lhs, rhs}));
    }

    public void visit(ConcatMethodCallExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("CONCAT2", new Expression[]{lhs, rhs}));
    }

    public void visit(DateTimeLiteral expr) {
        Timestamp timestamp = new Timestamp(expr.getValue().toDateTime().getMillis());
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)timestamp, Integer.valueOf(93)));
        } else {
            this.stack.add(new Constant((Object)timestamp));
        }
    }

    public void visit(DateTimeOffsetLiteral expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(DecimalLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(3)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(DivExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("/", new Expression[]{lhs, rhs}));
    }

    public void visit(EndsWithMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        Expression target = (Expression)this.stack.pop();
        this.visitNode(expr.getValue());
        Expression value = (Expression)this.stack.pop();
        CompareCriteria criteria = new CompareCriteria((Expression)new Function("ENDSWITH", new Expression[]{value, target}), 1, (Expression)new Constant((Object)Boolean.TRUE));
        this.stack.push(criteria);
    }

    public void visit(EqExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        Object criteria = null;
        criteria = rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL ? new IsNullCriteria(lhs) : new CompareCriteria(lhs, 1, rhs);
        this.stack.push(criteria);
    }

    public void visit(GeExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompareCriteria criteria = new CompareCriteria(lhs, 6, rhs);
        this.stack.push(criteria);
    }

    public void visit(GtExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompareCriteria criteria = new CompareCriteria(lhs, 4, rhs);
        this.stack.push(criteria);
    }

    public void visit(GuidLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue().toString(), Integer.valueOf(12)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue().toString()));
        }
    }

    public void visit(BinaryLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-2)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(ByteLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-6)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(SByteLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-6)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(IndexOfMethodCallExpression expr) {
        this.visitNode(expr.getValue());
        this.visitNode(expr.getTarget());
        Expression target = (Expression)this.stack.pop();
        Expression value = (Expression)this.stack.pop();
        this.stack.push(new Function("LOCATE", new Expression[]{value, target}));
    }

    public void visit(SingleLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)Float.valueOf(expr.getValue()), Integer.valueOf(6)));
        } else {
            this.stack.add(new Constant((Object)Float.valueOf(expr.getValue())));
        }
    }

    public void visit(DoubleLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(8)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(IntegralLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(4)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(Int64Literal expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-5)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(IsofExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(LeExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompareCriteria criteria = new CompareCriteria(lhs, 5, rhs);
        this.stack.push(criteria);
    }

    public void visit(LengthMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("LENGTH", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(LtExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompareCriteria criteria = new CompareCriteria(lhs, 3, rhs);
        this.stack.push(criteria);
    }

    public void visit(ModExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("MOD", new Expression[]{lhs, rhs}));
    }

    public void visit(MulExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("*", new Expression[]{lhs, rhs}));
    }

    public void visit(NeExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompareCriteria criteria = null;
        if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
            IsNullCriteria crit = new IsNullCriteria(lhs);
            crit.setNegated(true);
            criteria = crit;
        } else {
            criteria = new CompareCriteria(lhs, 2, rhs);
        }
        this.stack.push(criteria);
    }

    public void visit(NegateExpression expr) {
        this.visitNode(expr.getExpression());
        Expression ex = (Expression)this.stack.pop();
        this.stack.push(new Function("*", new Expression[]{new Constant((Object)-1), ex}));
    }

    public void visit(NotExpression expr) {
        this.visitNode(expr.getExpression());
        NotCriteria criteria = new NotCriteria((Criteria)new ExpressionCriteria((Expression)this.stack.pop()));
        this.stack.push(criteria);
    }

    public void visit(NullLiteral expr) {
        this.stack.push(new Constant(null));
    }

    public void visit(OrExpression expr) {
        this.visitNode((CommonExpression)expr.getLHS());
        this.visitNode((CommonExpression)expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        CompoundCriteria criteria = new CompoundCriteria(1, (Criteria)lhs, (Criteria)rhs);
        this.stack.push(criteria);
    }

    public void visit(ParenExpression expr) {
        this.visitNode(expr.getExpression());
    }

    public void visit(BoolParenExpression expr) {
        this.visitNode(expr.getExpression());
    }

    public void visit(ReplaceMethodCallExpression expr) {
        ArrayList expressions = new ArrayList();
        this.visitNode(expr.getTarget());
        expressions.add(this.stack.pop());
        this.visitNode(expr.getFind());
        expressions.add(this.stack.pop());
        this.visitNode(expr.getReplace());
        expressions.add(this.stack.pop());
        this.stack.push(new Function("REPLACE", expressions.toArray(new Expression[expressions.size()])));
    }

    public void visit(StartsWithMethodCallExpression expr) {
        this.locate((BoolMethodExpression)expr, 1);
    }

    private void locate(BoolMethodExpression expr, int compare) {
        this.visitNode(expr.getTarget());
        Expression target = (Expression)this.stack.pop();
        this.visitNode(expr.getValue());
        Expression value = (Expression)this.stack.pop();
        CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{value, target, new Constant((Object)1)}), compare, (Expression)new Constant((Object)1));
        this.stack.push(criteria);
    }

    public void visit(StringLiteral expr) {
        if (this.prepared) {
            this.stack.push(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(12)));
        } else {
            this.stack.push(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(SubExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("-", new Expression[]{lhs, rhs}));
    }

    public void visit(SubstringMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        ArrayList expressions = new ArrayList();
        expressions.add(this.stack.pop());
        if (expr.getStart() != null) {
            this.visitNode(expr.getStart());
            expressions.add(this.stack.pop());
        }
        if (expr.getLength() != null) {
            this.visitNode(expr.getLength());
            expressions.add(this.stack.pop());
        }
        this.stack.push(new Function("SUBSTRING", expressions.toArray(new Expression[expressions.size()])));
    }

    public void visit(SubstringOfMethodCallExpression expr) {
        this.locate((BoolMethodExpression)expr, 6);
    }

    public void visit(TimeLiteral expr) {
        Time time = new Time(expr.getValue().toDateTimeToday().getMillis());
        if (this.prepared) {
            this.stack.push(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)time, Integer.valueOf(92)));
        } else {
            this.stack.push(new Constant((Object)time));
        }
    }

    public void visit(ToLowerMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("LCASE", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(ToUpperMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("UCASE", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(TrimMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("TRIM", new Expression[]{new Constant((Object)"BOTH"), new Constant((Object)Character.valueOf(' ')), (Expression)this.stack.pop()}));
    }

    public void visit(YearMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("YEAR", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(MonthMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("MONTH", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(DayMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("DAYOFMONTH", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(HourMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("HOUR", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(MinuteMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("MINUTE", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(SecondMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("SECOND", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(RoundMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("ROUND", new Expression[]{(Expression)this.stack.pop(), new Constant((Object)0)}));
    }

    public void visit(FloorMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("FLOOR", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(CeilingMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("CEILING", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(EntitySimpleProperty expr) {
        String property = expr.getPropertyName();
        if (property.indexOf(47) == -1) {
            this.stack.push(new ElementSymbol(property, this.getDocumentGroup()));
            return;
        }
        String[] segments = property.split("/");
        this.setExpression((Expression)new ElementSymbol(segments[1], this.getDocumentGroup()));
    }

    public GroupSymbol getDocumentGroup() {
        return null;
    }
}

