/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.util.List;
import java.util.Map;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OExtension;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.exceptions.NotAcceptableException;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataContext;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.edm.MetadataProducer;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.odata.Client;
import org.teiid.odata.ComplexCollection;
import org.teiid.odata.EntityCollector;
import org.teiid.odata.EntityList;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.ODataSQLBuilder;
import org.teiid.odata.UpdateResponse;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class TeiidProducer
implements ODataProducer {
    private Client client;

    public TeiidProducer(Client client) {
        this.client = client;
    }

    public <TExtension extends OExtension<ODataProducer>> TExtension findExtension(Class<TExtension> clazz) {
        return null;
    }

    public EdmDataServices getMetadata() {
        return this.client.getMetadata();
    }

    public MetadataProducer getMetadataProducer() {
        return new MetadataProducer((ODataProducer)this, null);
    }

    public EntitiesResponse getEntities(ODataContext context, String entitySetName, QueryInfo queryInfo) {
        return (EntitiesResponse)this.getNavProperty(context, entitySetName, null, null, queryInfo);
    }

    public BaseResponse getNavProperty(ODataContext context, String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        EdmEntitySet edmEntitySet = this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        boolean value = false;
        boolean propertyResponse = false;
        if (navProp != null && navProp.endsWith("/$value")) {
            navProp = navProp.replace("/$value", "");
            value = true;
        }
        EdmEntityType edmEntityType = edmEntitySet.getType();
        for (EdmProperty edmProperty : edmEntityType.getProperties()) {
            if (!edmProperty.getName().equals(navProp)) continue;
            propertyResponse = true;
            break;
        }
        Query query = visitor.selectString(entitySetName, queryInfo, entityKey, navProp, false);
        List parameters = visitor.getParameters();
        EntityList results = new EntityList(visitor.getDocumentNode(), this.getMetadata(), queryInfo);
        EntityList response = (EntityList)this.client.executeSQL(query, parameters, queryInfo, (EntityCollector)results);
        if (navProp != null) {
            if (propertyResponse) {
                OProperty property = ((OEntity)response.get(0)).getProperty(navProp);
                if (value) {
                    return Responses.raw((EdmSimpleType)((EdmSimpleType)property.getType()), (String)navProp, (Object)property.getValue());
                }
                return Responses.property((OProperty)property);
            }
            for (EdmNavigationProperty edmNavProperty : edmEntityType.getNavigationProperties()) {
                if (!edmNavProperty.getName().equals(navProp) || !edmNavProperty.getToRole().getMultiplicity().equals((Object)EdmMultiplicity.ZERO_TO_ONE)) continue;
                if (!response.isEmpty()) {
                    return Responses.entity((OEntity)((OEntity)response.get(0)));
                }
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16018, new Object[]{entityKey, entitySetName}));
            }
        }
        return response;
    }

    private boolean hasQueryOptions(QueryInfo queryInfo) {
        if (queryInfo != null) {
            if (queryInfo.top != null) {
                return true;
            }
            if (queryInfo.skip != null) {
                return true;
            }
            if (queryInfo.filter != null) {
                return true;
            }
            if (queryInfo.orderBy != null) {
                return true;
            }
            if (queryInfo.select != null & !queryInfo.select.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private EdmEntitySet getEntitySet(String entitySetName) {
        EdmDataServices eds = this.getMetadata();
        EdmEntitySet entity = eds.findEdmEntitySet(entitySetName);
        if (entity == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16011, new Object[]{entitySetName}));
        }
        return entity;
    }

    public CountResponse getEntitiesCount(ODataContext context, String entitySetName, QueryInfo queryInfo) {
        this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Query query = visitor.selectString(entitySetName, queryInfo, null, null, true);
        List parameters = visitor.getParameters();
        return this.client.executeCount(query, parameters);
    }

    public EntityResponse getEntity(ODataContext context, String entitySetName, OEntityKey entityKey, EntityQueryInfo queryInfo) {
        this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Query query = visitor.selectString(entitySetName, (QueryInfo)queryInfo, entityKey, null, false);
        List parameters = visitor.getParameters();
        EntityList results = new EntityList(visitor.getDocumentNode(), this.getMetadata(), (QueryInfo)queryInfo);
        EntitiesResponse response = (EntitiesResponse)this.client.executeSQL(query, parameters, null, (EntityCollector)results);
        if (response.getEntities().isEmpty()) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16018, new Object[]{entityKey, entitySetName}));
        }
        return Responses.entity((OEntity)((OEntity)response.getEntities().get(0)));
    }

    public CountResponse getNavPropertyCount(ODataContext context, String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Query query = visitor.selectString(entitySetName, queryInfo, entityKey, navProp, true);
        List parameters = visitor.getParameters();
        return this.client.executeCount(query, parameters);
    }

    public void close() {
    }

    public EntityResponse createEntity(ODataContext context, String entitySetName, OEntity entity) {
        List parameters;
        EdmEntitySet entitySet = this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Insert query = visitor.insert(entitySet, entity);
        UpdateResponse response = this.client.executeUpdate((Command)query, parameters = visitor.getParameters());
        if (response.getUpdateCount() == 1) {
            visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
            OEntityKey entityKey = visitor.buildEntityKey(entitySet, entity, response.getGeneratedKeys());
            LogManager.log((int)5, (String)"org.teiid.ODATA", null, (Object[])new Object[]{"created entity = ", entitySetName, " with key=", entityKey.toString()});
            return this.getEntity(context, entitySetName, entityKey, EntityQueryInfo.newBuilder().build());
        }
        return null;
    }

    public EntityResponse createEntity(ODataContext context, String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        throw new UnsupportedOperationException("Deep inserts are not supported");
    }

    public void deleteEntity(ODataContext context, String entitySetName, OEntityKey entityKey) {
        List parameters;
        EdmEntitySet entitySet = this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Delete query = visitor.delete(entitySet, entityKey);
        UpdateResponse response = this.client.executeUpdate((Command)query, parameters = visitor.getParameters());
        if (response.getUpdateCount() == 0) {
            LogManager.log((int)5, (String)"org.teiid.ODATA", null, (Object[])new Object[]{"no entity to delete in = ", entitySetName, " with key=", entityKey.toString()});
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16018, new Object[]{entityKey, entitySetName}));
        }
        if (response.getUpdateCount() == 1) {
            LogManager.log((int)5, (String)"org.teiid.ODATA", null, (Object[])new Object[]{"deleted entity = ", entitySetName, " with key=", entityKey.toString()});
        } else {
            LogManager.log((int)3, (String)"org.teiid.ODATA", null, (Object[])new Object[]{"deleted multiple entities = ", entitySetName, " with key=", entityKey.toString()});
        }
    }

    public void mergeEntity(ODataContext context, String entitySetName, OEntity entity) {
        int updateCount = this.update(entitySetName, entity);
        if (updateCount == 0) {
            this.createEntity(context, entitySetName, entity);
        }
    }

    public void updateEntity(ODataContext context, String entitySetName, OEntity entity) {
        int updateCount = this.update(entitySetName, entity);
        if (updateCount <= 0) {
            LogManager.log((int)5, (String)"org.teiid.ODATA", null, (Object[])new Object[]{"no entity to update in = ", entitySetName, " with key=", entity.getEntityKey().toString()});
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16018, new Object[]{entity.getEntityKey(), entitySetName}));
        }
        LogManager.log((int)5, (String)"org.teiid.ODATA", null, (Object[])new Object[]{"updated entity = ", entitySetName, " with key=", entity.getEntityKey().toString()});
    }

    private int update(String entitySetName, OEntity entity) {
        EdmEntitySet entitySet = this.getEntitySet(entitySetName);
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Update query = visitor.update(entitySet, entity);
        List parameters = visitor.getParameters();
        UpdateResponse response = this.client.executeUpdate((Command)query, parameters);
        return response.getUpdateCount();
    }

    public EntityIdResponse getLinks(ODataContext context, OEntityId sourceEntity, String targetNavProp) {
        BaseResponse response = this.getNavProperty(context, sourceEntity.getEntitySetName(), sourceEntity.getEntityKey(), targetNavProp, new QueryInfo());
        if (response instanceof EntitiesResponse) {
            EntitiesResponse er = (EntitiesResponse)response;
            return Responses.multipleIds((Iterable)er.getEntities());
        }
        if (response instanceof EntityResponse) {
            EntityResponse er = (EntityResponse)response;
            return Responses.singleId((OEntityId)er.getEntity());
        }
        throw new NotImplementedException(sourceEntity + " " + targetNavProp);
    }

    public void createLink(ODataContext context, OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        throw new UnsupportedOperationException();
    }

    public void updateLink(ODataContext context, OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        throw new UnsupportedOperationException();
    }

    public void deleteLink(ODataContext context, OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        throw new UnsupportedOperationException();
    }

    public BaseResponse callFunction(ODataContext context, EdmFunctionImport function, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        EdmEntityContainer eec = this.findEntityContainer(function);
        boolean hasQueryInfo = this.hasQueryOptions(queryInfo);
        boolean hasScalarOrNoReturn = function.getReturnType() == null || function.getReturnType() != null && function.getReturnType().isSimple();
        String procedureName = eec.getName() + "." + SQLStringVisitor.escapeSinglePart((String)function.getName());
        if (hasScalarOrNoReturn) {
            if (hasQueryInfo) {
                throw new NotAcceptableException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16019, new Object[]{function.getName()}));
            }
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
            StoredProcedure sp = visitor.storedProcedure(procedureName, function, params);
            StringBuilder sql = new StringBuilder(sp.toString());
            sql.replace(0, 4, "CALL");
            if (function.getReturnType() != null) {
                sql.insert(0, "{ ? = ");
                sql.append(" }");
            }
            return this.client.executeCall(sql.toString(), visitor.getParameters(), function.getReturnType());
        }
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), true);
        Query query = visitor.callFunctionQuery(procedureName, function, params, queryInfo);
        List parameters = visitor.getParameters();
        EdmComplexType type = (EdmComplexType)((EdmCollectionType)function.getReturnType()).getItemType();
        ComplexCollection result = new ComplexCollection(type, visitor.getDocumentNode(), queryInfo);
        return this.client.executeSQL(query, parameters, queryInfo, (EntityCollector)result);
    }

    EdmEntityContainer findEntityContainer(EdmFunctionImport function) {
        EdmDataServices eds = this.getMetadata();
        for (EdmSchema schema : eds.getSchemas()) {
            for (EdmEntityContainer eec : schema.getEntityContainers()) {
                for (EdmFunctionImport func : eec.getFunctionImports()) {
                    if (func != function) continue;
                    return eec;
                }
            }
        }
        return null;
    }
}

