/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.NamespacedAnnotation;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDocumentation;

public class EdmItem {
    private final EdmDocumentation documentation;
    private final ImmutableList<? extends NamespacedAnnotation<?>> annotations;
    private final ImmutableList<? extends NamespacedAnnotation<?>> annotationElements;

    protected EdmItem(EdmDocumentation documentation, ImmutableList<EdmAnnotation<?>> annotations, ImmutableList<EdmAnnotation<?>> annotationElements) {
        this.documentation = documentation;
        this.annotations = annotations;
        this.annotationElements = annotationElements;
    }

    public EdmDocumentation getDocumentation() {
        return this.documentation;
    }

    public Iterable<? extends NamespacedAnnotation<?>> getAnnotations() {
        return this.annotations;
    }

    public Iterable<? extends NamespacedAnnotation<?>> getAnnotationElements() {
        return this.annotationElements;
    }

    public NamespacedAnnotation<?> findAnnotation(String namespaceUri, String localName) {
        if (this.annotations != null) {
            for (NamespacedAnnotation<?> annotation : this.annotations) {
                if (!annotation.getNamespace().getUri().equals(namespaceUri) || !annotation.getName().equals(localName)) continue;
                return annotation;
            }
        }
        return null;
    }

    public NamespacedAnnotation<?> findAnnotationElement(String namespaceUri, String name) {
        if (this.annotationElements != null) {
            for (NamespacedAnnotation<?> element : this.annotationElements) {
                if (!element.getNamespace().getUri().equals(namespaceUri) || !element.getName().equals(name)) continue;
                return element;
            }
        }
        return null;
    }

    public static abstract class Builder<T, TBuilder> {
        private EdmDocumentation documentation;
        private List<EdmAnnotation<?>> annotations;
        private List<EdmAnnotation<?>> annotationElements;

        abstract TBuilder newBuilder(T var1, BuilderContext var2);

        public EdmDocumentation getDocumentation() {
            return this.documentation;
        }

        public List<EdmAnnotation<?>> getAnnotations() {
            return this.annotations;
        }

        public List<EdmAnnotation<?>> getAnnotationElements() {
            return this.annotationElements;
        }

        public TBuilder setDocumentation(EdmDocumentation documentation) {
            this.documentation = documentation;
            return (TBuilder)this;
        }

        public TBuilder setAnnotations(List<EdmAnnotation<?>> annotations) {
            this.annotations = annotations;
            return (TBuilder)this;
        }

        public TBuilder setAnnotationElements(List<EdmAnnotation<?>> annotationElements) {
            this.annotationElements = annotationElements;
            return (TBuilder)this;
        }
    }

    static class BuilderContext {
        private final Map<Object, Builder<?, ?>> newBuilders = new HashMap();
        private final EdmDataServices.Builder dataServices;

        public BuilderContext(EdmDataServices.Builder ds) {
            this.dataServices = ds;
        }

        public EdmDataServices.Builder getDataServices() {
            return this.dataServices;
        }

        public <T, TBuilder> TBuilder newBuilder(T item, Builder<T, TBuilder> builder) {
            if (!this.newBuilders.containsKey(item)) {
                this.newBuilders.put(item, (Builder)builder.newBuilder(item, this));
            }
            return (TBuilder)this.newBuilders.get(item);
        }

        public <T, TBuilder extends Builder<?, ?>> void register(T item, TBuilder builder) {
            this.newBuilders.put(item, builder);
        }
    }
}

