/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.math.BigDecimal;
import org.odata4j.core.Guid;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.format.json.JsonStreamReaderFactory;
import org.odata4j.internal.InternalUtil;
import org.odata4j.repack.org.apache.commons.codec.binary.Base64;

public class JsonTypeConverter {
    public static OProperty<?> parse(String name, EdmSimpleType<?> type, String value, JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType tokenType) {
        if (type == null) {
            return OProperties.string(name, value);
        }
        if (value == null) {
            return OProperties.null_(name, type);
        }
        if (EdmSimpleType.STRING.equals(type)) {
            if (tokenType == JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.STRING) {
                return OProperties.string(name, value);
            }
            throw new JsonStreamReaderFactory.JsonParseException("Illegal JSON string-value format");
        }
        if (EdmSimpleType.GUID.equals(type)) {
            return OProperties.guid(name, Guid.fromString(value));
        }
        if (EdmSimpleType.BOOLEAN.equals(type)) {
            if (tokenType == JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.FALSE || tokenType == JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.TRUE) {
                return OProperties.boolean_(name, Boolean.valueOf(value));
            }
            throw new JsonStreamReaderFactory.JsonParseException("Illegal JSON boolean-value format");
        }
        if (EdmSimpleType.BYTE.equals(type)) {
            return OProperties.byte_(name, UnsignedByte.parseUnsignedByte(value));
        }
        if (EdmSimpleType.SBYTE.equals(type)) {
            return OProperties.sbyte_(name, Byte.parseByte(value));
        }
        if (EdmSimpleType.INT16.equals(type)) {
            return OProperties.int16(name, Short.parseShort(value));
        }
        if (EdmSimpleType.INT32.equals(type)) {
            return OProperties.int32(name, Integer.parseInt(value));
        }
        if (EdmSimpleType.INT64.equals(type)) {
            return OProperties.int64(name, Long.parseLong(value));
        }
        if (EdmSimpleType.SINGLE.equals(type)) {
            return OProperties.single(name, Float.valueOf(Float.parseFloat(value)));
        }
        if (EdmSimpleType.DOUBLE.equals(type)) {
            return OProperties.double_(name, Double.parseDouble(value));
        }
        if (EdmSimpleType.DECIMAL.equals(type)) {
            return OProperties.decimal(name, new BigDecimal(value));
        }
        if (EdmSimpleType.BINARY.equals(type)) {
            return OProperties.binary(name, new Base64().decode(value));
        }
        if (EdmSimpleType.DATETIME.equals(type)) {
            return OProperties.datetime(name, InternalUtil.parseDateTimeFromJson(value));
        }
        if (EdmSimpleType.DATETIMEOFFSET.equals(type)) {
            return OProperties.datetimeOffset(name, InternalUtil.parseDateTimeOffsetFromJson(value));
        }
        if (EdmSimpleType.TIME.equals(type)) {
            return OProperties.time(name, InternalUtil.parseTime(value));
        }
        throw new UnsupportedOperationException("type:" + type);
    }
}

