/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.expression;

import org.odata4j.expression.AddExpression;
import org.odata4j.expression.AggregateAllFunction;
import org.odata4j.expression.AggregateAnyFunction;
import org.odata4j.expression.AndExpression;
import org.odata4j.expression.BinaryLiteral;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.BooleanLiteral;
import org.odata4j.expression.ByteLiteral;
import org.odata4j.expression.CastExpression;
import org.odata4j.expression.CeilingMethodCallExpression;
import org.odata4j.expression.ConcatMethodCallExpression;
import org.odata4j.expression.DateTimeLiteral;
import org.odata4j.expression.DateTimeOffsetLiteral;
import org.odata4j.expression.DayMethodCallExpression;
import org.odata4j.expression.DecimalLiteral;
import org.odata4j.expression.DivExpression;
import org.odata4j.expression.DoubleLiteral;
import org.odata4j.expression.EndsWithMethodCallExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.Expression;
import org.odata4j.expression.FloorMethodCallExpression;
import org.odata4j.expression.GeExpression;
import org.odata4j.expression.GtExpression;
import org.odata4j.expression.GuidLiteral;
import org.odata4j.expression.HourMethodCallExpression;
import org.odata4j.expression.IndexOfMethodCallExpression;
import org.odata4j.expression.Int64Literal;
import org.odata4j.expression.IntegralLiteral;
import org.odata4j.expression.IsofExpression;
import org.odata4j.expression.LeExpression;
import org.odata4j.expression.LengthMethodCallExpression;
import org.odata4j.expression.LtExpression;
import org.odata4j.expression.MinuteMethodCallExpression;
import org.odata4j.expression.ModExpression;
import org.odata4j.expression.MonthMethodCallExpression;
import org.odata4j.expression.MulExpression;
import org.odata4j.expression.NeExpression;
import org.odata4j.expression.NegateExpression;
import org.odata4j.expression.NotExpression;
import org.odata4j.expression.NullLiteral;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.ReplaceMethodCallExpression;
import org.odata4j.expression.RoundMethodCallExpression;
import org.odata4j.expression.SByteLiteral;
import org.odata4j.expression.SecondMethodCallExpression;
import org.odata4j.expression.SingleLiteral;
import org.odata4j.expression.StartsWithMethodCallExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.SubExpression;
import org.odata4j.expression.SubstringMethodCallExpression;
import org.odata4j.expression.SubstringOfMethodCallExpression;
import org.odata4j.expression.TimeLiteral;
import org.odata4j.expression.ToLowerMethodCallExpression;
import org.odata4j.expression.ToUpperMethodCallExpression;
import org.odata4j.expression.TrimMethodCallExpression;
import org.odata4j.expression.YearMethodCallExpression;
import org.odata4j.internal.InternalUtil;
import org.odata4j.repack.org.apache.commons.codec.binary.Hex;

public class FilterExpressionVisitor
extends Expression.DefaultHierarchyVisitor {
    private String fragment;

    private void push(String fragment) {
        this.fragment = fragment;
    }

    public String toString() {
        return this.fragment;
    }

    @Override
    public void visit(NullLiteral expr) {
        this.push("null");
    }

    @Override
    public void visit(BooleanLiteral expr) {
        this.push(Boolean.toString(expr.getValue()));
    }

    @Override
    public void visit(GuidLiteral expr) {
        this.push("guid'" + expr.getValue() + "'");
    }

    @Override
    public void visit(StringLiteral expr) {
        this.push("'" + expr.getValue().replace("'", "''") + "'");
    }

    @Override
    public void visit(Int64Literal expr) {
        this.push(expr.getValue() + "L");
    }

    @Override
    public void visit(IntegralLiteral expr) {
        this.push(Integer.toString(expr.getValue()));
    }

    @Override
    public void visit(DoubleLiteral expr) {
        this.push(Double.toString(expr.getValue()) + "d");
    }

    @Override
    public void visit(SingleLiteral expr) {
        this.push(expr.getValue() + "f");
    }

    @Override
    public void visit(DecimalLiteral expr) {
        this.push(expr.getValue() + "M");
    }

    @Override
    public void visit(BinaryLiteral expr) {
        this.push("binary'" + Hex.encodeHexString(expr.getValue()) + "'");
    }

    @Override
    public void visit(DateTimeLiteral expr) {
        this.push("datetime'" + InternalUtil.formatDateTimeForXml(expr.getValue()) + "'");
    }

    @Override
    public void visit(DateTimeOffsetLiteral expr) {
        this.push("datetimeoffset'" + InternalUtil.formatDateTimeOffsetForXml(expr.getValue()) + "'");
    }

    @Override
    public void visit(TimeLiteral expr) {
        this.push("time'" + InternalUtil.formatTimeForXml(expr.getValue()) + "'");
    }

    @Override
    public void visit(ByteLiteral expr) {
        this.push(Integer.toString(expr.getValue().intValue()));
    }

    @Override
    public void beforeDescend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterDescend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void betweenDescend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(OrderByExpression.Direction direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(OrderByExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(SByteLiteral expr) {
        this.push(Byte.toString(expr.getValue()));
    }

    @Override
    public void visit(AddExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(AndExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(CastExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(ConcatMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(DivExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(EndsWithMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(EntitySimpleProperty expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(EqExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(GeExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(GtExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(IndexOfMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(IsofExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(LeExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(LengthMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(LtExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(ModExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(MulExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(NeExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(NegateExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(NotExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(OrExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(ParenExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(BoolParenExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(ReplaceMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(StartsWithMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(SubExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(SubstringMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(SubstringOfMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(ToLowerMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(ToUpperMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(TrimMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(YearMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(MonthMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(DayMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(HourMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(MinuteMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(SecondMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(RoundMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(FloorMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(CeilingMethodCallExpression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(AggregateAnyFunction expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(AggregateAllFunction expr) {
        throw new UnsupportedOperationException();
    }
}

