/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.util.LinkedHashMap;
import java.util.Map;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotFoundException;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;
import org.teiid.odata.ODataPlugin;
import org.teiid.query.sql.symbol.GroupSymbol;

public class DocumentNode {
    private Table entityTable;
    private Procedure entityProcedure;
    private GroupSymbol group;
    private DocumentNode expandNode;
    private DocumentNode parentNode;
    private EdmEntitySet edmEntitySet;
    private LinkedHashMap<String, ProjectedColumn> projectedColumns = new LinkedHashMap();

    public DocumentNode(Table entityTable, GroupSymbol group) {
        this.entityTable = entityTable;
        this.group = group;
    }

    public DocumentNode(Procedure procedure, GroupSymbol group) {
        this.entityProcedure = procedure;
        this.group = group;
    }

    public Table getEntityTable() {
        return this.entityTable;
    }

    public GroupSymbol getEntityGroup() {
        return this.group;
    }

    public EdmEntityType getEntityType(EdmDataServices metadata) {
        return this.getEntitySet(metadata).getType();
    }

    public Map<String, ProjectedColumn> getProjectedColumns() {
        return this.projectedColumns;
    }

    public void addProjectColumn(final String columnName, final int ordinal, final boolean visible, final EdmType type) {
        this.projectedColumns.put(columnName, new ProjectedColumn(){

            @Override
            public String name() {
                return columnName;
            }

            @Override
            public EdmType type() {
                return type;
            }

            @Override
            public int ordinal() {
                return ordinal;
            }

            @Override
            public boolean visible() {
                return visible;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name() == null ? 0 : this.name().hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ProjectedColumn other = (ProjectedColumn)obj;
                return !(this.name() == null ? other.name() != null : !this.name().equals(other.name()));
            }
        });
    }

    public void setExpandNode(DocumentNode node) {
        this.expandNode = node;
        this.expandNode.parentNode = this;
    }

    public DocumentNode getExpandNode() {
        return this.expandNode;
    }

    public DocumentNode getParentNode() {
        return this.parentNode;
    }

    public EdmEntitySet getEntitySet(EdmDataServices metadata) {
        assert (metadata != null);
        if (this.edmEntitySet == null) {
            this.edmEntitySet = metadata.findEdmEntitySet(this.entityTable.getFullName());
            if (this.edmEntitySet == null) {
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16011, new Object[]{this.entityTable.getFullName()}));
            }
        }
        return this.edmEntitySet;
    }

    static interface ProjectedColumn {
        public String name();

        public EdmType type();

        public int ordinal();

        public boolean visible();
    }
}

