/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.util.List;
import javax.ws.rs.core.Response;
import org.core4j.Enumerable;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatType;
import org.odata4j.format.SingleLink;
import org.odata4j.format.xml.AtomCollectionInfo;
import org.odata4j.format.xml.AtomServiceDocumentFormatParser;
import org.odata4j.format.xml.AtomSingleLinkFormatParser;
import org.odata4j.format.xml.AtomWorkspaceInfo;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.stax2.XMLEventReader2;

public abstract class AbstractODataClient
implements ODataClient {
    private FormatType formatType;

    protected AbstractODataClient(FormatType formatType) {
        this.formatType = formatType;
    }

    @Override
    public FormatType getFormatType() {
        return this.formatType;
    }

    @Override
    public EdmDataServices getMetadata(ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.doRequest(FormatType.ATOM, request, new Response.StatusType[]{Response.Status.OK});
        EdmDataServices metadata = new EdmxFormatParser().parseMetadata(this.toXml(response));
        response.close();
        return metadata;
    }

    @Override
    public Iterable<AtomCollectionInfo> getCollections(ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.doRequest(FormatType.ATOM, request, new Response.StatusType[]{Response.Status.OK});
        Enumerable collections = Enumerable.create(AtomServiceDocumentFormatParser.parseWorkspaces(this.toXml(response))).selectMany(AtomWorkspaceInfo.GET_COLLECTIONS);
        response.close();
        return collections;
    }

    @Override
    public Iterable<SingleLink> getLinks(ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.doRequest(FormatType.ATOM, request, new Response.StatusType[]{Response.Status.OK});
        Iterable<SingleLink> links = AtomSingleLinkFormatParser.parseLinks(this.toXml(response));
        response.close();
        return links;
    }

    @Override
    public ODataClientResponse getEntity(ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.OK, Response.Status.NO_CONTENT});
        return response;
    }

    @Override
    public ODataClientResponse getEntities(ODataClientRequest request) throws ODataProducerException {
        return this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.OK});
    }

    @Override
    public ODataClientResponse callFunction(ODataClientRequest request) throws ODataProducerException {
        return this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.OK, Response.Status.NO_CONTENT});
    }

    @Override
    public ODataClientResponse createEntity(ODataClientRequest request) throws ODataProducerException {
        return this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.CREATED});
    }

    @Override
    public void updateEntity(ODataClientRequest request) throws ODataProducerException {
        this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.OK, Response.Status.NO_CONTENT}).close();
    }

    @Override
    public void deleteEntity(ODataClientRequest request) throws ODataProducerException {
        this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.OK, Response.Status.NO_CONTENT}).close();
    }

    @Override
    public void deleteLink(ODataClientRequest request) throws ODataProducerException {
        this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.NO_CONTENT}).close();
    }

    @Override
    public void createLink(ODataClientRequest request) throws ODataProducerException {
        this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.NO_CONTENT}).close();
    }

    @Override
    public void updateLink(ODataClientRequest request) throws ODataProducerException {
        this.doRequest(this.getFormatType(), request, new Response.StatusType[]{Response.Status.NO_CONTENT}).close();
    }

    @Override
    public Entry createRequestEntry(EdmEntitySet entitySet, OEntityKey entityKey, List<OProperty<?>> props, List<OLink> links) {
        final OEntity entity = entityKey == null ? OEntities.createRequest(entitySet, props, links) : OEntities.create(entitySet, entityKey, props, links);
        return new Entry(){

            @Override
            public String getUri() {
                return null;
            }

            @Override
            public OEntity getEntity() {
                return entity;
            }
        };
    }

    protected abstract ODataClientResponse doRequest(FormatType var1, ODataClientRequest var2, Response.StatusType ... var3) throws ODataProducerException;

    protected abstract XMLEventReader2 toXml(ODataClientResponse var1);
}

