/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.UUID;
import java.util.regex.Pattern;

public class Guid {
    private static final Pattern GUID_FORMAT = Pattern.compile("^(urn\\:uuid\\:)?\\p{XDigit}{8}-?\\p{XDigit}{4}-?\\p{XDigit}{4}-?\\p{XDigit}{4}-?\\p{XDigit}{12}$");
    private final String value;

    private Guid(String value) {
        this.value = value;
    }

    public static Guid fromString(String value) {
        if (GUID_FORMAT.matcher(value).matches()) {
            return new Guid(value);
        }
        throw new IllegalArgumentException("Illegal GUID format " + value);
    }

    public static Guid fromUUID(UUID uuid) {
        return new Guid(uuid.toString());
    }

    public static Guid randomGuid() {
        return new Guid(UUID.randomUUID().toString());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Guid && ((Guid)other).value.equals(this.value);
    }

    public String toString() {
        return this.value;
    }
}

