/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.ServerErrorException;
import org.odata4j.internal.EdmDataServicesDecorator;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.PropertyResponse;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.odata.Client;
import org.teiid.odata.EntityCollector;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.SQLParam;
import org.teiid.odata.UpdateResponse;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;
import org.teiid.translator.odata.ODataTypeManager;
import org.teiid.transport.LocalServerConnection;

public class LocalClient
implements Client {
    private static final String BATCH_SIZE = "batch-size";
    private static final String SKIPTOKEN_TIME = "skiptoken-cache-time";
    static final String INVALID_CHARACTER_REPLACEMENT = "invalid-xml10-character-replacement";
    static final String DELIMITER = "--";
    private volatile VDBMetaData vdb;
    private String vdbName;
    private int vdbVersion;
    private int batchSize;
    private long cacheTime;
    private String connectionString;
    private Properties initProperties;
    private EdmDataServices edmMetaData;
    private TeiidDriver driver = TeiidDriver.getInstance();
    private String invalidCharacterReplacement;

    public LocalClient(String vdbName, int vdbVersion, Properties props) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.batchSize = PropertiesUtils.getIntProperty((Properties)props, (String)BATCH_SIZE, (int)256);
        this.cacheTime = PropertiesUtils.getLongProperty((Properties)props, (String)SKIPTOKEN_TIME, (long)300000L);
        this.invalidCharacterReplacement = props.getProperty(INVALID_CHARACTER_REPLACEMENT);
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:teiid:").append(this.vdbName).append(".").append(this.vdbVersion).append(";");
        this.initProperties = props;
        if (this.initProperties.getProperty("PassthroughAuthentication") == null) {
            this.initProperties.put("PassthroughAuthentication", "true");
        }
        if (this.initProperties.getProperty("transportName") == null) {
            this.initProperties.setProperty("transportName", "odata");
        }
        if (this.initProperties.getProperty("waitForLoad") == null) {
            this.initProperties.put("waitForLoad", "0");
        }
        this.connectionString = sb.toString();
    }

    @Override
    public VDBMetaData getVDB() {
        ConnectionImpl connection = null;
        if (this.vdb == null) {
            try {
                connection = this.getConnection();
                LocalServerConnection lsc = (LocalServerConnection)connection.getServerConnection();
                VDBMetaData vdb = lsc.getWorkContext().getVDB();
                if (vdb == null) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16001, new Object[]{this.vdbName, this.vdbVersion}));
                }
                this.vdb = vdb;
            }
            catch (SQLException e) {
                throw new ServerErrorException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return this.vdb;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    ConnectionImpl getConnection() throws SQLException {
        if (this.vdbName == null || !this.vdbName.matches("[\\w-\\.]+")) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16008, new Object[0]));
        }
        ConnectionImpl connection = this.driver.connect(this.connectionString, this.initProperties);
        if (connection == null) {
            throw new TeiidRuntimeException("URL not valid " + this.connectionString);
        }
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)connection);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)connection, (Properties)this.initProperties);
        return connection;
    }

    @Override
    public BaseResponse executeCall(String sql, List<SQLParam> parameters, EdmType returnType) {
        ConnectionImpl connection = null;
        try {
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            CallableStatementImpl stmt = connection.prepareCall(sql);
            int i = 1;
            if (returnType != null && returnType.isSimple()) {
                stmt.registerOutParameter(i++, JDBCSQLTypeInfo.getSQLType((String)ODataTypeManager.teiidType((String)returnType.getFullyQualifiedTypeName())));
            }
            if (!parameters.isEmpty()) {
                for (SQLParam param : parameters) {
                    stmt.setObject(i++, param.value, param.sqlType.intValue());
                }
            }
            boolean results = stmt.execute();
            if (returnType != null && !results) {
                Object result = stmt.getObject(1);
                OProperty<?> prop = LocalClient.buildPropery("return", returnType, result, this.invalidCharacterReplacement);
                PropertyResponse propertyResponse = Responses.property(prop);
                return propertyResponse;
            }
            BaseResponse baseResponse = null;
            return baseResponse;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public MetadataStore getMetadataStore() {
        return ((TransformationMetadata)this.getVDB().getAttachment(TransformationMetadata.class)).getMetadataStore();
    }

    @Override
    public BaseResponse executeSQL(Query query, List<SQLParam> parameters, QueryInfo queryInfo, EntityCollector<?> collector) {
        ConnectionImpl connection = null;
        try {
            boolean cache;
            boolean bl = cache = queryInfo != null && this.batchSize > 0;
            if (cache) {
                CacheHint hint = new CacheHint();
                hint.setTtl(Long.valueOf(this.cacheTime));
                hint.setScope(CacheDirective.Scope.USER);
                hint.setMinRows(Long.valueOf(this.batchSize));
                query.setCacheHint(hint);
            }
            boolean getCount = false;
            if (queryInfo != null) {
                boolean bl2 = getCount = queryInfo.inlineCount == InlineCount.ALLPAGES;
                if (!(getCount || queryInfo.top == null && queryInfo.skip == null)) {
                    query.setLimit(new Limit((Expression)(queryInfo.skip != null ? new Constant((Object)queryInfo.skip) : null), (Expression)(queryInfo.top != null ? new Constant((Object)queryInfo.top) : null)));
                }
            }
            connection = this.getConnection();
            String sessionId = connection.getServerConnection().getLogonResult().getSessionID();
            String skipToken = null;
            if (queryInfo != null && queryInfo.skipToken != null) {
                skipToken = queryInfo.skipToken;
                if (cache) {
                    int idx = queryInfo.skipToken.indexOf(DELIMITER);
                    sessionId = queryInfo.skipToken.substring(0, idx);
                    skipToken = queryInfo.skipToken.substring(idx + 2);
                }
            }
            String sql = query.toString();
            if (cache) {
                sql = sql + " /* " + sessionId + " */";
            }
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            PreparedStatementImpl stmt = connection.prepareStatement(sql, cache ? 1004 : 1003, 1007);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType);
                }
            }
            ResultSet rs = stmt.executeQuery();
            int skipcount = 0;
            int skipSize = 0;
            if (getCount && queryInfo.skip != null) {
                skipSize = queryInfo.skip;
            }
            if (skipToken != null) {
                skipSize += Integer.parseInt(skipToken);
            }
            if (skipSize > 0) {
                skipcount += this.skip(cache, rs, skipSize);
            }
            int size = this.batchSize;
            int top = Integer.MAX_VALUE;
            if (getCount && queryInfo.top != null) {
                size = top = queryInfo.top.intValue();
                if (this.batchSize > 0) {
                    size = Math.min(this.batchSize, size);
                }
            } else if (size < 1) {
                size = Integer.MAX_VALUE;
            }
            Object previous = null;
            block10: for (int i = 0; i < size && rs.next(); ++i) {
                if (previous != null) {
                    boolean sameRow = true;
                    while (sameRow) {
                        Object current = collector.addRow(previous, rs, this.invalidCharacterReplacement);
                        sameRow = collector.isSameRow(previous, current);
                        previous = current;
                        if (!sameRow || !rs.next()) continue block10;
                        ++skipcount;
                        ++i;
                    }
                    continue;
                }
                previous = collector.addRow(previous, rs, this.invalidCharacterReplacement);
                ++skipcount;
            }
            collector.lastRow(previous);
            if (getCount) {
                if (!cache) {
                    while (rs.next()) {
                        ++skipcount;
                    }
                } else {
                    rs.last();
                    skipcount = rs.getRow();
                }
            }
            collector.setInlineCount(skipcount);
            if (cache && collector.size() == this.batchSize) {
                int end = skipSize + collector.size();
                if (getCount) {
                    if (end < Math.min(top, skipcount)) {
                        collector.setSkipToken(this.nextToken(cache, sessionId, end));
                    }
                } else if (rs.next()) {
                    collector.setSkipToken(this.nextToken(cache, sessionId, end));
                    rs.last();
                }
            }
            EntityCollector<?> entityCollector = collector;
            return entityCollector;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String nextToken(boolean cache, String sessionid, int skip) {
        if (cache) {
            return sessionid + DELIMITER + String.valueOf(skip);
        }
        return String.valueOf(skip);
    }

    private int skip(boolean cache, ResultSet rs, int skipSize) throws SQLException {
        int skipped = 0;
        if (!cache) {
            for (int i = 0; i < skipSize; ++i) {
                ++skipped;
                if (rs.next()) {
                    continue;
                }
                break;
            }
        } else {
            rs.absolute(skipSize);
        }
        return skipped;
    }

    @Override
    public CountResponse executeCount(Query query, List<SQLParam> parameters) {
        ConnectionImpl connection = null;
        try {
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatementImpl stmt = connection.prepareStatement(sql);
            if (!parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType.intValue());
                }
            }
            ResultSetImpl rs = stmt.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            stmt.close();
            CountResponse countResponse = Responses.count((long)count);
            return countResponse;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public UpdateResponse executeUpdate(Command query, List<SQLParam> parameters) {
        ConnectionImpl connection = null;
        try {
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatementImpl stmt = connection.prepareStatement(sql, 1003, 1007, 1, 1);
            if (!parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType.intValue());
                }
            }
            final int count = stmt.executeUpdate();
            final Map<String, Object> keys = this.getGeneratedKeys(stmt.getGeneratedKeys());
            stmt.close();
            UpdateResponse updateResponse = new UpdateResponse(){

                @Override
                public Map<String, Object> getGeneratedKeys() {
                    return keys;
                }

                @Override
                public int getUpdateCount() {
                    return count;
                }
            };
            return updateResponse;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private Map<String, Object> getGeneratedKeys(ResultSet result) throws SQLException {
        if (result == null) {
            return null;
        }
        HashMap<String, Object> keys = new HashMap<String, Object>();
        ResultSetMetaData metadata = result.getMetaData();
        while (result.next()) {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                String label = metadata.getColumnLabel(i + 1);
                keys.put(label, result.getObject(i + 1));
            }
        }
        return keys;
    }

    @Override
    public EdmDataServices getMetadata() {
        if (this.edmMetaData == null) {
            this.edmMetaData = LocalClient.buildMetadata(this.getVDB(), this.getMetadataStore());
        }
        return this.edmMetaData;
    }

    public static EdmDataServices buildMetadata(VDBMetaData vdb, MetadataStore metadataStore) {
        try {
            ArrayList edmSchemas = new ArrayList();
            for (Schema schema : metadataStore.getSchemaList()) {
                if (!LocalClient.isVisible(vdb, schema)) continue;
                ODataEntitySchemaBuilder.buildEntityTypes((Schema)schema, edmSchemas, (boolean)false);
            }
            for (Schema schema : metadataStore.getSchemaList()) {
                if (!LocalClient.isVisible(vdb, schema)) continue;
                ODataEntitySchemaBuilder.buildFunctionImports((Schema)schema, edmSchemas, (boolean)false);
            }
            for (Schema schema : metadataStore.getSchemaList()) {
                if (!LocalClient.isVisible(vdb, schema)) continue;
                ODataEntitySchemaBuilder.buildAssosiationSets((Schema)schema, edmSchemas, (boolean)false);
            }
            final EdmDataServices edmDataServices = EdmDataServices.newBuilder().addSchemas(edmSchemas).build();
            EdmDataServicesDecorator decorator = new EdmDataServicesDecorator(){

                protected EdmDataServices getDelegate() {
                    return edmDataServices;
                }

                public EdmEntitySet findEdmEntitySet(String entitySetName) {
                    EdmEntitySet ees;
                    int idx = entitySetName.indexOf(46);
                    if (idx != -1 && (ees = super.findEdmEntitySet(entitySetName)) != null) {
                        return ees;
                    }
                    EdmEntitySet result = null;
                    for (EdmSchema schema : this.getSchemas()) {
                        for (EdmEntityContainer eec : schema.getEntityContainers()) {
                            for (EdmEntitySet ees2 : eec.getEntitySets()) {
                                if (!ees2.getName().equals(entitySetName)) continue;
                                if (result != null) {
                                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{entitySetName}));
                                }
                                result = ees2;
                            }
                        }
                    }
                    return result;
                }

                public EdmFunctionImport findEdmFunctionImport(String functionImportName) {
                    EdmFunctionImport efi;
                    int idx = functionImportName.indexOf(46);
                    if (idx != -1 && (efi = super.findEdmFunctionImport(functionImportName)) != null) {
                        return efi;
                    }
                    EdmFunctionImport result = null;
                    for (EdmSchema schema : this.getSchemas()) {
                        for (EdmEntityContainer eec : schema.getEntityContainers()) {
                            for (EdmFunctionImport efi2 : eec.getFunctionImports()) {
                                if (!efi2.getName().equals(functionImportName)) continue;
                                if (result != null) {
                                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{functionImportName}));
                                }
                                result = efi2;
                            }
                        }
                    }
                    return result;
                }
            };
            return decorator;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private static boolean isVisible(VDBMetaData vdb, Schema schema) {
        String schemaName = schema.getName();
        ModelMetaData model = vdb.getModel(schemaName);
        if (model == null) {
            return true;
        }
        return model.isVisible();
    }

    static OProperty<?> buildPropery(String propName, EdmType type, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        Class targetType;
        if (!(type instanceof EdmSimpleType)) {
            if (type instanceof EdmCollectionType) {
                EdmCollectionType collectionType = (EdmCollectionType)type;
                EdmType componentType = collectionType.getItemType();
                OCollection.Builder b = OCollections.newBuilder((EdmType)componentType);
                if (value instanceof java.sql.Array) {
                    value = ((java.sql.Array)value).getArray();
                }
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Object o = Array.get(value, i);
                    OProperty<?> p = LocalClient.buildPropery("x", componentType, o, invalidCharacterReplacement);
                    if (componentType instanceof EdmSimpleType) {
                        b.add((OObject)OSimpleObjects.create((EdmSimpleType)((EdmSimpleType)componentType), (Object)p.getValue()));
                        continue;
                    }
                    if (!(componentType instanceof EdmCollectionType)) continue;
                    b.add((OObject)((OCollection)p.getValue()));
                }
                return OProperties.collection((String)propName, (EdmCollectionType)collectionType, (OCollection)b.build());
            }
            throw new AssertionError((Object)"non-simple types are not yet supported");
        }
        EdmSimpleType expectedType = (EdmSimpleType)type;
        if (value == null) {
            return OProperties.null_((String)propName, (EdmSimpleType)expectedType);
        }
        Class sourceType = DataTypeManager.getRuntimeType(value.getClass());
        if (sourceType != (targetType = DataTypeManager.getDataTypeClass((String)ODataTypeManager.teiidType((String)expectedType.getFullyQualifiedTypeName())))) {
            Transform t = DataTypeManager.getTransform((Class)sourceType, (Class)targetType);
            if (t == null && BlobType.class == targetType) {
                if (sourceType == ClobType.class) {
                    return OProperties.binary((String)propName, (byte[])ClobType.getString((Clob)((Clob)value)).getBytes());
                }
                if (sourceType == SQLXML.class) {
                    return OProperties.binary((String)propName, (byte[])((SQLXML)value).getString().getBytes());
                }
            }
            value = DataTypeManager.convertToRuntimeType((Object)value, (boolean)true);
            value = t != null ? t.transform(value, targetType) : value;
            if ((value = LocalClient.replaceInvalidCharacters(expectedType, value, invalidCharacterReplacement)) instanceof BinaryType) {
                value = ((BinaryType)value).getBytesDirect();
            }
            return OProperties.simple((String)propName, (EdmSimpleType)expectedType, (Object)value);
        }
        value = LocalClient.replaceInvalidCharacters(expectedType, value, invalidCharacterReplacement);
        return OProperties.simple((String)propName, (EdmSimpleType)expectedType, (Object)value);
    }

    static Object replaceInvalidCharacters(EdmSimpleType expectedType, Object value, String invalidCharacterReplacement) {
        if (expectedType != EdmSimpleType.STRING || invalidCharacterReplacement == null) {
            return value;
        }
        if (value instanceof Character) {
            value = value.toString();
        }
        String s = (String)value;
        StringBuilder result = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= ' ' && c != ' ' && c != '\n' && c != '\t' && c != '\r') {
                if (result == null) {
                    result = new StringBuilder();
                    result.append(s.substring(0, i));
                }
                result.append(invalidCharacterReplacement);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        if (result == null) {
            return value;
        }
        return result.toString();
    }
}

