/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.ODataEntitySchemaBuilder;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestDataEntitySchemaBuilder {
    @Test
    public void testMetadata() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
        StringWriter sw = new StringWriter();
        EdmDataServices eds = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        EdmxFormatWriter.write((EdmDataServices)eds, (Writer)sw);
        EdmDataServices pds = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new StringReader(sw.toString())));
        Assert.assertEquals((long)eds.getSchemas().size(), (long)pds.getSchemas().size());
        for (int i = 0; i < eds.getSchemas().size(); ++i) {
            EdmSchema expected = (EdmSchema)eds.getSchemas().get(i);
            EdmSchema actual = (EdmSchema)pds.getSchemas().get(i);
            this.assertEdmSchema(expected, actual);
        }
    }

    private void assertEdmSchema(EdmSchema expected, EdmSchema actual) {
        int i;
        Assert.assertEquals((long)expected.getEntityTypes().size(), (long)actual.getEntityTypes().size());
        Assert.assertEquals((long)expected.getEntityContainers().size(), (long)actual.getEntityContainers().size());
        Assert.assertEquals((long)expected.getAssociations().size(), (long)actual.getAssociations().size());
        for (i = 0; i < expected.getEntityTypes().size(); ++i) {
            this.assertEntityType((EdmEntityType)expected.getEntityTypes().get(i), (EdmEntityType)actual.getEntityTypes().get(i));
        }
        for (i = 0; i < expected.getAssociations().size(); ++i) {
            this.assertEdmAssosiation((EdmAssociation)expected.getAssociations().get(i), (EdmAssociation)actual.getAssociations().get(i));
        }
        for (i = 0; i < expected.getEntityContainers().size(); ++i) {
            this.assertEntityContainer((EdmEntityContainer)expected.getEntityContainers().get(i), (EdmEntityContainer)actual.getEntityContainers().get(i));
        }
    }

    private void assertEntityType(EdmEntityType expected, EdmEntityType actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
        Assert.assertArrayEquals((Object[])expected.getKeys().toArray(new String[expected.getKeys().size()]), (Object[])actual.getKeys().toArray(new String[actual.getKeys().size()]));
        ArrayList propertiesExpected = new ArrayList();
        ArrayList propertiesActual = new ArrayList();
        Iterator it = expected.getProperties().iterator();
        while (it.hasNext()) {
            propertiesExpected.add(it.next());
        }
        it = actual.getProperties().iterator();
        while (it.hasNext()) {
            propertiesActual.add(it.next());
        }
        Assert.assertEquals((long)propertiesExpected.size(), (long)propertiesActual.size());
        for (int i = 0; i < propertiesExpected.size(); ++i) {
            this.assertEdmProperty((EdmProperty)propertiesExpected.get(i), (EdmProperty)propertiesActual.get(i));
        }
        ArrayList navExpected = new ArrayList();
        ArrayList navActual = new ArrayList();
        Iterator enpIt = expected.getDeclaredNavigationProperties().iterator();
        while (enpIt.hasNext()) {
            navExpected.add(enpIt.next());
        }
        enpIt = actual.getDeclaredNavigationProperties().iterator();
        while (enpIt.hasNext()) {
            navActual.add(enpIt.next());
        }
        Assert.assertEquals((long)navExpected.size(), (long)navActual.size());
        for (int i = 0; i < navExpected.size(); ++i) {
            this.assertEdmNavigationProperty((EdmNavigationProperty)navExpected.get(i), (EdmNavigationProperty)navActual.get(i));
        }
        Assert.assertArrayEquals((Object[])expected.getKeys().toArray(), (Object[])actual.getKeys().toArray());
    }

    private void assertEdmNavigationProperty(EdmNavigationProperty expected, EdmNavigationProperty actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEdmAssosiation(expected.getRelationship(), actual.getRelationship());
        this.assertEdmAssociationEnd(expected.getFromRole(), actual.getFromRole());
        this.assertEdmAssociationEnd(expected.getToRole(), actual.getToRole());
    }

    private void assertEdmAssociationEnd(EdmAssociationEnd expected, EdmAssociationEnd actual) {
        Assert.assertEquals((Object)expected.getRole(), (Object)actual.getRole());
    }

    private void assertEdmAssosiation(EdmAssociation expected, EdmAssociation actual) {
        Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEdmAssociationEnd(expected.getEnd1(), actual.getEnd1());
        this.assertEdmAssociationEnd(expected.getEnd2(), actual.getEnd2());
    }

    private void assertEdmProperty(EdmProperty expected, EdmProperty actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
    }

    private void assertEntityContainer(EdmEntityContainer expected, EdmEntityContainer actual) {
        int i;
        Assert.assertEquals((long)expected.getEntitySets().size(), (long)actual.getEntitySets().size());
        Assert.assertEquals((long)expected.getAssociationSets().size(), (long)actual.getAssociationSets().size());
        for (i = 0; i < expected.getEntitySets().size(); ++i) {
            this.assertEnititySet((EdmEntitySet)expected.getEntitySets().get(i), (EdmEntitySet)actual.getEntitySets().get(i));
        }
        for (i = 0; i < expected.getAssociationSets().size(); ++i) {
            this.assertAssosiationSet((EdmAssociationSet)expected.getAssociationSets().get(i), (EdmAssociationSet)actual.getAssociationSets().get(i));
        }
    }

    private void assertAssosiationSet(EdmAssociationSet expected, EdmAssociationSet actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEdmAssosiation(expected.getAssociation(), actual.getAssociation());
        this.assertEdmAssociationSetEnd(expected.getEnd1(), actual.getEnd1());
        this.assertEdmAssociationSetEnd(expected.getEnd1(), actual.getEnd1());
    }

    private void assertEdmAssociationSetEnd(EdmAssociationSetEnd expected, EdmAssociationSetEnd actual) {
        this.assertEdmAssociationEnd(expected.getRole(), actual.getRole());
    }

    private void assertEnititySet(EdmEntitySet expected, EdmEntitySet actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEntityType(expected.getType(), actual.getType());
    }

    @Test
    public void testUnquieTreatedAsKey() {
    }
}

