/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.EmbeddedContainer;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.expression.Expression;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.producer.Responses;
import org.odata4j.producer.resources.EntitiesRequestResource;
import org.odata4j.producer.resources.EntityRequestResource;
import org.odata4j.producer.resources.MetadataResource;
import org.odata4j.producer.resources.ODataBatchProvider;
import org.odata4j.producer.resources.ServiceDocumentResource;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.Client;
import org.teiid.odata.EntityList;
import org.teiid.odata.MockProvider;
import org.teiid.odata.ODataExceptionMappingProvider;
import org.teiid.odata.SQLParam;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;

public class TestODataIntegration
extends BaseResourceTest {
    private static TransformationMetadata metadata;
    private static EdmDataServices eds;

    @BeforeClass
    public static void before() throws Exception {
        deployment = EmbeddedContainer.start((String)"/odata/northwind");
        dispatcher = deployment.getDispatcher();
        deployment.getRegistry().addPerRequestResource(EntitiesRequestResource.class);
        deployment.getRegistry().addPerRequestResource(EntityRequestResource.class);
        deployment.getRegistry().addPerRequestResource(MetadataResource.class);
        deployment.getRegistry().addPerRequestResource(ServiceDocumentResource.class);
        deployment.getProviderFactory().registerProviderInstance(ODataBatchProvider.class);
        deployment.getProviderFactory().addExceptionMapper(ODataExceptionMappingProvider.class);
        deployment.getProviderFactory().addContextResolver(MockProvider.class);
        metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
        eds = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
    }

    @Test
    public void testMetadata() throws Exception {
        Client client = (Client)Mockito.mock(Client.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        MockProvider.CLIENT = client;
        StringWriter sw = new StringWriter();
        EdmxFormatWriter.write((EdmDataServices)eds, (Writer)sw);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/$metadata"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)sw.toString(), (Object)response.getEntity());
    }

    @Test
    public void testProjectedColumns() throws Exception {
        Client client = (Client)Mockito.mock(Client.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        MockProvider.CLIENT = client;
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor entitySet = ArgumentCaptor.forClass(EdmEntitySet.class);
        OEntity entity = this.createCustomersEntity(eds);
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        Mockito.when((Object)result.get(0)).thenReturn((Object)entity);
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), Mockito.anyMapOf(String.class, Boolean.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (String)Mockito.any(String.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)entitySet.capture(), Mockito.anyMapOf(String.class, Boolean.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (String)Mockito.any(String.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        Assert.assertEquals((Object)"SELECT g0.Address, g0.CustomerID, g0.CompanyName FROM Customers AS g0 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testProcedure() throws Exception {
        Client client = (Client)Mockito.mock(Client.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        MockProvider.CLIENT = client;
        ArgumentCaptor sql = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor params = ArgumentCaptor.forClass(List.class);
        Mockito.when((Object)client.executeCall((String)Mockito.any(String.class), Mockito.anyListOf(SQLParam.class), (EdmType)Mockito.any(EdmType.class))).thenReturn((Object)Responses.simple((EdmSimpleType)EdmSimpleType.INT32, (String)"return", (Object)Expression.null_()));
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/getCustomers?p2=datetime'2011-09-11T00:00:00'&p3=2.0M"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeCall((String)sql.capture(), (List)params.capture(), (EdmType)Mockito.any(EdmType.class));
        Assert.assertEquals((Object)"{? = call nw.getCustomers(p2=>?,p3=>?)}", (Object)((String)sql.getValue()).toString());
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)111, (int)8, (int)11, (int)0, (int)0, (int)0, (int)0), (Object)((SQLParam)((List)params.getValue()).get((int)0)).value);
        Assert.assertEquals((Object)BigDecimal.valueOf(2.0), (Object)((SQLParam)((List)params.getValue()).get((int)1)).value);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testSkipNoPKTable() throws Exception {
        Client client = (Client)Mockito.mock(Client.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        MockProvider.CLIENT = client;
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/NoPKTable"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity()).endsWith("<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>NotFoundException</code><message lang=\"en-US\">TEIID16011 EntitySet \"NoPKTable\" is not found; Check the spelling, use modelName.tableName; The table that representing the Entity type must either have a PRIMARY KEY or UNIQUE key(s)</message></error>"));
    }

    @Test
    public void testError() throws Exception {
        Client client = (Client)Mockito.mock(Client.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        MockProvider.CLIENT = client;
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), Mockito.anyMapOf(String.class, Boolean.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (String)Mockito.any(String.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenThrow(new Throwable[]{new NullPointerException()});
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity()).endsWith("<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>ServerErrorException</code><message lang=\"en-US\">Internal Server Error</message></error>"));
    }

    @Test
    public void testProcedureCall() throws Exception {
        Client client = (Client)Mockito.mock(Client.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        MockProvider.CLIENT = client;
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor entitySet = ArgumentCaptor.forClass(EdmEntitySet.class);
        OEntity entity = this.createCustomersEntity(eds);
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        Mockito.when((Object)result.get(0)).thenReturn((Object)entity);
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)Mockito.any(EdmEntitySet.class), Mockito.anyMapOf(String.class, Boolean.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (String)Mockito.any(String.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (EdmEntitySet)entitySet.capture(), Mockito.anyMapOf(String.class, Boolean.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (String)Mockito.any(String.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        Assert.assertEquals((Object)"SELECT g0.Address, g0.CustomerID, g0.CompanyName FROM Customers AS g0 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    private OEntity createCustomersEntity(EdmDataServices metadata) {
        EdmEntitySet entitySet = metadata.findEdmEntitySet("Customers");
        OEntityKey entityKey = OEntityKey.parse((String)"CustomerID='12'");
        ArrayList<OProperty> properties = new ArrayList<OProperty>();
        properties.add(OProperties.string((String)"CompanyName", (String)"teiid"));
        properties.add(OProperties.string((String)"ContactName", (String)"contact-name"));
        properties.add(OProperties.string((String)"ContactTitle", (String)"contact-title"));
        properties.add(OProperties.string((String)"Address", (String)"address"));
        properties.add(OProperties.string((String)"City", (String)"city"));
        properties.add(OProperties.string((String)"Region", (String)"region"));
        properties.add(OProperties.string((String)"PostalCode", (String)"postal-code"));
        properties.add(OProperties.string((String)"Country", (String)"country"));
        properties.add(OProperties.string((String)"Phone", (String)"555-1212"));
        properties.add(OProperties.string((String)"Fax", (String)"555-1212"));
        OEntity entity = OEntities.create((EdmEntitySet)entitySet, (OEntityKey)entityKey, properties, null);
        return entity;
    }
}

