/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import org.odata4j.producer.ODataContext;
import org.odata4j.producer.ODataHeadersContext;
import org.odata4j.producer.ODataHeadersImpl;

public class ODataContextImpl
implements ODataContext {
    private Map<Class, Object> contexts = new HashMap<Class, Object>();

    private ODataContextImpl() {
    }

    @Override
    public <T> T getContextAspect(Class<T> contextClass) {
        for (Map.Entry<Class, Object> aspect : this.contexts.entrySet()) {
            if (!contextClass.isAssignableFrom(aspect.getKey())) continue;
            return (T)aspect.getValue();
        }
        return null;
    }

    @Override
    public ODataHeadersContext getRequestHeadersContext() {
        return this.getContextAspect(ODataHeadersContext.class);
    }

    public static ODataContextBuilder builder() {
        return new ODataContextBuilder();
    }

    private void addContextAspect(Object aspect) {
        this.contexts.put(aspect.getClass(), aspect);
    }

    public static class ODataContextBuilder {
        private ODataContextImpl impl = new ODataContextImpl();

        protected ODataContextBuilder() {
        }

        public ODataContextBuilder aspect(Object aspect) {
            if (HttpHeaders.class.isAssignableFrom(aspect.getClass())) {
                this.impl.addContextAspect(new ODataHeadersImpl((HttpHeaders)aspect));
            }
            this.impl.addContextAspect(aspect);
            return this;
        }

        public ODataContextImpl build() {
            return this.impl;
        }
    }
}

