/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer;

import java.util.ArrayList;
import java.util.List;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.ExpressionParser;
import org.odata4j.producer.PropertyPath;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.RecursivePropertyPath;

public class PropertyPathHelper {
    public static final String OptionExpandR = "expandR";
    public static final String OptionSelectR = "selectR";
    private PropertyPath currentNavPath = new PropertyPath("");
    protected List<PropertyPath> selectPaths;
    protected List<PropertyPath> expandPaths;
    protected List<PropertyPath> selectRPaths;
    protected List<RecursivePropertyPath> expandRPaths;

    public PropertyPathHelper() {
        this.setup((String)null, null, null, null);
    }

    public PropertyPathHelper(QueryInfo qi) {
        this.setup(qi == null ? null : qi.select, qi == null ? null : qi.expand, null, null);
    }

    public PropertyPathHelper(String select, String expand) {
        this.setup(select, expand, null, null);
    }

    public PropertyPathHelper(String select, String expand, String selectR, String expandR) {
        this.setup(select, expand, selectR, expandR);
    }

    public PropertyPathHelper(List<EntitySimpleProperty> select, List<EntitySimpleProperty> expand) {
        this.setup(select, expand, null, null);
    }

    public PropertyPathHelper(List<EntitySimpleProperty> select, List<EntitySimpleProperty> expand, String selectR, String expandR) {
        this.setup(select, expand, selectR != null && selectR.length() > 0 ? ExpressionParser.parseExpand(selectR) : null, expandR != null && expandR.length() > 0 ? ExpressionParser.parseExpand(expandR) : null);
    }

    private void setup(String select, String expand, String selectR, String expandR) {
        this.setup(select != null && select.length() > 0 ? ExpressionParser.parseExpand(select) : null, expand != null && expand.length() > 0 ? ExpressionParser.parseExpand(expand) : null, selectR != null && selectR.length() > 0 ? ExpressionParser.parseExpand(selectR) : null, expandR != null && expandR.length() > 0 ? ExpressionParser.parseExpand(expandR) : null);
    }

    private void setup(List<EntitySimpleProperty> select, List<EntitySimpleProperty> expand, List<EntitySimpleProperty> selectR, List<EntitySimpleProperty> expandR) {
        PropertyPath path;
        if (select != null && select.size() > 0) {
            this.selectPaths = new ArrayList<PropertyPath>(select.size());
            for (EntitySimpleProperty p : select) {
                this.selectPaths.add(new PropertyPath(p.getPropertyName()));
            }
        }
        if (expand != null && expand.size() > 0) {
            this.expandPaths = new ArrayList<PropertyPath>(expand.size());
            for (EntitySimpleProperty p : expand) {
                this.expandPaths.add(new PropertyPath(p.getPropertyName()));
            }
        }
        if (selectR != null && selectR.size() > 0) {
            this.selectRPaths = new ArrayList<PropertyPath>(selectR.size());
            for (EntitySimpleProperty p : selectR) {
                path = new PropertyPath(p.getPropertyName());
                if (path.getNComponents() != 2) {
                    throw new RuntimeException("selectR clause must have 2 components: " + p.getPropertyName());
                }
                this.selectRPaths.add(path);
            }
        }
        if (expandR != null && expandR.size() > 0) {
            this.expandRPaths = new ArrayList<RecursivePropertyPath>(expandR.size());
            for (EntitySimpleProperty p : expandR) {
                path = new PropertyPath(p.getPropertyName());
                if (path.getNComponents() != 2) {
                    throw new RuntimeException("expandR clause must have 2 components: " + p.getPropertyName());
                }
                int depth = 0;
                try {
                    depth = Integer.parseInt(path.getLastComponent());
                }
                catch (Exception ex) {
                    throw new RuntimeException("2nd component of expandR clause must be the integer depth: " + p.getPropertyName());
                }
                this.expandRPaths.add(new RecursivePropertyPath(path.removeLastComponent(), depth));
            }
        }
    }

    protected boolean isSelectionLimited() {
        if (this.selectPaths == null) {
            return false;
        }
        int nComponentsToMatch = this.currentNavPath.getNComponents() + 1;
        for (PropertyPath p : this.selectPaths) {
            if (p.getNComponents() != nComponentsToMatch) continue;
            if (p.isWild()) {
                return false;
            }
            if (!p.startsWith(this.currentNavPath)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectionLimitedRecursive() {
        if (this.selectRPaths == null) {
            return false;
        }
        if (this.currentNavPath.isEmpty()) {
            return false;
        }
        for (PropertyPath p : this.selectRPaths) {
            if (!p.getFirstComponent().equals(this.currentNavPath.getLastComponent())) continue;
            return !p.isWild();
        }
        return false;
    }

    public boolean isSelected(String propName) {
        boolean limited = false;
        if (this.isSelectionLimited()) {
            limited = true;
            PropertyPath checkPath = this.currentNavPath.addComponent(propName);
            for (PropertyPath p : this.selectPaths) {
                if (!p.equals(checkPath)) continue;
                return true;
            }
        }
        if (this.isSelectionLimitedRecursive()) {
            limited = true;
            for (PropertyPath p : this.selectRPaths) {
                if (!p.getLastComponent().equals(propName) || this.currentNavPath.getNComponents() < 1 || !this.currentNavPath.getLastComponent().equals(p.getFirstComponent())) continue;
                return true;
            }
        }
        return !limited;
    }

    protected boolean isExpandedExplicit(String navPropName) {
        if (this.expandPaths == null) {
            return false;
        }
        PropertyPath checkPath = this.currentNavPath.addComponent(navPropName);
        for (PropertyPath p : this.expandPaths) {
            if (!p.equals(checkPath)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExpandedRecursive(String navPropName) {
        if (this.expandRPaths == null) {
            return false;
        }
        for (RecursivePropertyPath p : this.expandRPaths) {
            if (!p.getFirstComponent().equals(navPropName) || !p.isValidAtDepth(this.getCurrentDepth())) continue;
            return true;
        }
        return false;
    }

    public boolean isExpanded(String navPropName) {
        return this.isExpandedExplicit(navPropName) || this.isExpandedRecursive(navPropName);
    }

    public void navigate(String propName) {
        this.currentNavPath = this.currentNavPath.addComponent(propName);
    }

    public void popPath() {
        this.currentNavPath = this.currentNavPath.removeLastComponent();
    }

    public PropertyPath getCurrentNavPath() {
        return this.currentNavPath;
    }

    public int getCurrentDepth() {
        return this.currentNavPath.getNComponents() + 1;
    }

    public boolean isRecursive() {
        return this.selectRPaths != null || this.expandRPaths != null;
    }

    public String toString() {
        return this.currentNavPath.toString();
    }
}

