/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.AbstractConsumerEntityRequest;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.OEntityDeleteRequest;
import org.odata4j.core.OEntityKey;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.exceptions.ODataProducerException;

public class ConsumerDeleteEntityRequest
extends AbstractConsumerEntityRequest<Void>
implements OEntityDeleteRequest {
    private String ifMatch;

    public ConsumerDeleteEntityRequest(ODataClient client, String serviceRootUri, EdmDataServices metadata, String entitySetName, OEntityKey key, String ifMatch) {
        super(client, serviceRootUri, metadata, entitySetName, key);
        this.ifMatch = ifMatch;
    }

    @Override
    public Void execute() throws ODataProducerException {
        String path = Enumerable.create(this.getSegments()).join("/");
        ODataClientRequest request = ODataClientRequest.delete(this.getServiceRootUri() + path);
        if (this.ifMatch != null) {
            request.header("If-Match", this.ifMatch);
        }
        this.getClient().deleteEntity(request);
        return null;
    }

    @Override
    public OEntityDeleteRequest ifMatch(String precondition) {
        this.ifMatch = precondition;
        return this;
    }
}

