/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.ODataHttpMethod;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityIds;
import org.odata4j.core.OEntityKey;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.BadRequestException;
import org.odata4j.exceptions.MethodNotAllowedException;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataContext;
import org.odata4j.producer.ODataContextImpl;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.OMediaLinkExtension;
import org.odata4j.producer.resources.BaseResource;
import org.odata4j.producer.resources.FunctionResource;
import org.odata4j.producer.resources.LinksRequestResource;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.odata4j.producer.resources.PropertyRequestResource;
import org.odata4j.producer.resources.ValueRequestResource;

@Path(value="{entitySetName: [^/()]+?}{id: \\([^/()]+?\\)}")
public class EntityRequestResource
extends BaseResource {
    private static final Logger log = Logger.getLogger(EntityRequestResource.class.getName());

    @PUT
    public Response updateEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context Providers providers, @Context SecurityContext securityContext, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, InputStream payload) throws Exception {
        log.info(String.format("updateEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = EntityRequestResource.getODataProducer(providers);
        EdmEntitySet entitySet = producer.getMetadata().findEdmEntitySet(entitySetName);
        if (entitySet == null) {
            throw new NotFoundException();
        }
        OEntityKey entityKey = OEntityKey.parse(id);
        ODataContextImpl odataContext = ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).aspect(producer).aspect(entitySet).aspect(uriInfo).aspect(entityKey).build();
        if (Boolean.TRUE.equals(entitySet.getType().getHasStream())) {
            return this.updateMediaLinkEntry(httpHeaders, uriInfo, producer, entitySet, payload, OEntityKey.parse(id), odataContext);
        }
        OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, OEntityKey.parse(id));
        producer.updateEntity(odataContext, entitySetName, entity);
        return Response.noContent().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response updateEntity(HttpHeaders httpHeaders, UriInfo uriInfo, SecurityContext securityContext, @Context Providers providers, String entitySetName, String id, String payload, ODataContext odataContext) throws Exception {
        log.info(String.format("updateEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = EntityRequestResource.getODataProducer(providers);
        EdmEntitySet entitySet = producer.getMetadata().findEdmEntitySet(entitySetName);
        if (entitySet == null) {
            throw new NotFoundException();
        }
        OEntityKey entityKey = OEntityKey.parse(id);
        if (Boolean.TRUE.equals(entitySet.getType().getHasStream())) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(payload.getBytes());
            try {
                Response response = this.updateMediaLinkEntry(httpHeaders, uriInfo, producer, entitySet, inStream, OEntityKey.parse(id), odataContext);
                return response;
            }
            finally {
                inStream.close();
            }
        }
        OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, OEntityKey.parse(id));
        producer.updateEntity(odataContext, entitySetName, entity);
        return Response.noContent().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    protected Response updateMediaLinkEntry(HttpHeaders httpHeaders, UriInfo uriInfo, ODataProducer producer, EdmEntitySet entitySet, InputStream payload, OEntityKey key, ODataContext odataContext) throws IOException {
        OEntity mle = super.createOrUpdateMediaLinkEntry(httpHeaders, uriInfo, entitySet, producer, payload, key, odataContext);
        return Response.ok().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    @POST
    public Response mergeEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context Providers providers, @Context SecurityContext securityContext, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, String payload) {
        log.info(String.format("mergeEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = EntityRequestResource.getODataProducer(providers);
        OEntityKey entityKey = OEntityKey.parse(id);
        ODataContextImpl context = ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).aspect(producer).build();
        String method = (String)httpHeaders.getRequestHeaders().getFirst((Object)"X-HTTP-METHOD");
        if ("MERGE".equals(method)) {
            OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, entityKey);
            producer.mergeEntity(context, entitySetName, entity);
            return Response.noContent().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        if ("DELETE".equals(method)) {
            producer.deleteEntity(context, entitySetName, entityKey);
            return Response.ok().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        if ("PUT".equals(method)) {
            OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, OEntityKey.parse(id));
            producer.updateEntity(context, entitySetName, entity);
            return Response.noContent().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        if (method != null) {
            throw new RuntimeException("Expected a tunnelled PUT, MERGE or DELETE");
        }
        throw new MethodNotAllowedException("POST is not allowed for an entity");
    }

    @DELETE
    public Response deleteEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context Providers providers, @Context SecurityContext securityContext, @QueryParam(value="$format") String format, @QueryParam(value="$callback") String callback, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id) throws Exception {
        log.info(String.format("deleteEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = EntityRequestResource.getODataProducer(providers);
        if (producer.getMetadata().findEdmFunctionImport(entitySetName) != null) {
            return FunctionResource.callFunction(ODataHttpMethod.DELETE, httpHeaders, uriInfo, securityContext, producer, entitySetName, format, callback, null);
        }
        OEntityKey entityKey = OEntityKey.parse(id);
        EdmEntitySet entitySet = producer.getMetadata().findEdmEntitySet(entitySetName);
        if (entitySet == null) {
            throw new NotFoundException();
        }
        ODataContextImpl odataContext = ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).aspect(producer).aspect(entitySet).aspect(uriInfo).aspect(entityKey).build();
        if (Boolean.TRUE.equals(entitySet.getType().getHasStream())) {
            OMediaLinkExtension mediaLinkExtension = this.getMediaLinkExtension(httpHeaders, uriInfo, entitySet, producer, odataContext);
            OEntity mle = mediaLinkExtension.getMediaLinkEntryForUpdateOrDelete(odataContext, entitySet, entityKey, httpHeaders);
            mediaLinkExtension.deleteStream(odataContext, mle, null);
            return Response.ok().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        producer.deleteEntity(odataContext, entitySetName, entityKey);
        return Response.ok().header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    @GET
    @Produces(value={"application/atom+xml;charset=utf-8", "text/javascript;charset=utf-8", "application/json;charset=utf-8", "application/atom+xml", "application/xml", "application/json"})
    public Response getEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context Providers providers, @Context SecurityContext securityContext, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @QueryParam(value="$format") String format, @QueryParam(value="$callback") String callback, @QueryParam(value="$expand") String expand, @QueryParam(value="$select") String select) {
        ODataProducer producer = EntityRequestResource.getODataProducer(providers);
        return this.getEntityImpl(httpHeaders, uriInfo, securityContext, producer, entitySetName, id, format, callback, expand, select);
    }

    protected Response getEntityImpl(HttpHeaders httpHeaders, UriInfo uriInfo, SecurityContext securityContext, ODataProducer producer, String entitySetName, String id, String format, String callback, String expand, String select) {
        EntityResponse response;
        EntityQueryInfo query = new EntityQueryInfo(null, OptionsQueryParser.parseCustomOptions(uriInfo), OptionsQueryParser.parseExpand(expand), OptionsQueryParser.parseSelect(select));
        log.info(String.format("getEntity(%s,%s,%s,%s)", entitySetName, id, expand, select));
        try {
            response = producer.getEntity(ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).aspect(producer).build(), entitySetName, OEntityKey.parse(id), query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Illegal key " + id, e);
        }
        StringWriter sw = new StringWriter();
        FormatWriter<EntityResponse> fw = FormatWriterFactory.getFormatWriter(EntityResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
        fw.write(uriInfo, sw, response);
        String entity = sw.toString();
        return Response.ok((Object)entity, (String)fw.getContentType()).header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    @Path(value="{first: \\$}links/{targetNavProp:.+?}{targetId: (\\(.+?\\))?}")
    public LinksRequestResource getLinks(@PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @PathParam(value="targetNavProp") String targetNavProp, @PathParam(value="targetId") String targetId) {
        OEntityKey targetEntityKey = targetId == null || targetId.isEmpty() ? null : OEntityKey.parse(targetId);
        return new LinksRequestResource(OEntityIds.create(entitySetName, OEntityKey.parse(id)), targetNavProp, targetEntityKey);
    }

    @Path(value="{first: \\$}value")
    public ValueRequestResource getValue() {
        return new ValueRequestResource();
    }

    @Path(value="{navProp: .+}")
    public PropertyRequestResource getNavProperty() {
        return new PropertyRequestResource();
    }

    @Path(value="{navProp: .+?}{optionalParens: ((\\(\\)))}")
    public PropertyRequestResource getSimpleNavProperty() {
        return new PropertyRequestResource();
    }
}

