/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.EmbeddedContainer;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.odata4j.core.OCollection;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.resources.EntitiesRequestResource;
import org.odata4j.producer.resources.EntityRequestResource;
import org.odata4j.producer.resources.MetadataResource;
import org.odata4j.producer.resources.ODataBatchProvider;
import org.odata4j.producer.resources.ServiceDocumentResource;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.json.simple.SimpleContentHandler;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.Client;
import org.teiid.odata.ComplexCollection;
import org.teiid.odata.EntityCollector;
import org.teiid.odata.EntityList;
import org.teiid.odata.LocalClient;
import org.teiid.odata.MockProvider;
import org.teiid.odata.ODataExceptionMappingProvider;
import org.teiid.odata.SQLParam;
import org.teiid.odata.UpdateResponse;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestODataIntegration
extends BaseResourceTest {
    private static TransformationMetadata metadata;

    @BeforeClass
    public static void before() throws Exception {
        deployment = EmbeddedContainer.start((String)"/odata/northwind");
        dispatcher = deployment.getDispatcher();
        deployment.getRegistry().addPerRequestResource(EntitiesRequestResource.class);
        deployment.getRegistry().addPerRequestResource(EntityRequestResource.class);
        deployment.getRegistry().addPerRequestResource(MetadataResource.class);
        deployment.getRegistry().addPerRequestResource(ServiceDocumentResource.class);
        deployment.getProviderFactory().registerProvider(ODataBatchProvider.class);
        deployment.getProviderFactory().registerProvider(ODataExceptionMappingProvider.class);
        deployment.getProviderFactory().registerProvider(MockProvider.class);
        metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
    }

    @Test
    public void testMetadata() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        StringWriter sw = new StringWriter();
        EdmxFormatWriter.write((EdmDataServices)client.getMetadata(), (Writer)sw);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/$metadata"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)sw.toString(), (Object)response.getEntity());
    }

    protected Client mockClient2() {
        Client client = (Client)Mockito.mock(Client.class);
        VDBMetaData vdb = (VDBMetaData)Mockito.mock(VDBMetaData.class);
        ModelMetaData model = (ModelMetaData)Mockito.mock(ModelMetaData.class);
        Mockito.stub((Object)model.isVisible()).toReturn((Object)false);
        Mockito.stub((Object)vdb.getModel("nw")).toReturn((Object)model);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        EdmDataServices eds = LocalClient.buildMetadata((VDBMetaData)vdb, (MetadataStore)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        return client;
    }

    @Test
    public void testMetadataVisibility() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient2();
        StringWriter sw = new StringWriter();
        EdmxFormatWriter.write((EdmDataServices)client.getMetadata(), (Writer)sw);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/$metadata"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)sw.toString(), (Object)response.getEntity());
        String edm = "<?xml version=\"1.0\" encoding=\"utf-8\"?><edmx:Edmx Version=\"1.0\" xmlns:edmx=\"http://schemas.microsoft.com/ado/2007/06/edmx\"><edmx:DataServices m:DataServiceVersion=\"2.0\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"></edmx:DataServices></edmx:Edmx>";
        Assert.assertEquals((Object)edm, (Object)response.getEntity());
    }

    protected Client mockClient() {
        Client client = (Client)Mockito.mock(Client.class);
        VDBMetaData vdb = (VDBMetaData)Mockito.mock(VDBMetaData.class);
        Mockito.stub((Object)client.getMetadataStore()).toReturn((Object)metadata.getMetadataStore());
        EdmDataServices eds = LocalClient.buildMetadata((VDBMetaData)vdb, (MetadataStore)metadata.getMetadataStore());
        Mockito.stub((Object)client.getMetadata()).toReturn((Object)eds);
        return client;
    }

    @Test
    public void testProjectedColumns() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        EdmEntitySet entitySet = client.getMetadata().getEdmEntitySet("nw.Customers");
        Mockito.when((Object)result.getEntitySet()).thenReturn((Object)entitySet);
        Mockito.when((Object)result.getEntities()).thenReturn(Arrays.asList(entity));
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class));
        Assert.assertEquals((Object)"SELECT g0.CustomerID, g0.CompanyName, g0.Address FROM nw.Customers AS g0 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity()).contains("nw.Customer"));
        Assert.assertTrue((!((String)response.getEntity()).contains("//Customer") ? 1 : 0) != 0);
    }

    @Test
    public void testCheckGeneratedColumns() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor insertCmd = ArgumentCaptor.forClass(Command.class);
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        EdmEntitySet entitySet = client.getMetadata().getEdmEntitySet("nw.Customers");
        Mockito.when((Object)result.getEntitySet()).thenReturn((Object)entitySet);
        Mockito.when((Object)result.getEntities()).thenReturn(list);
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenReturn((Object)result);
        UpdateResponse respose = new UpdateResponse(){

            public int getUpdateCount() {
                return 1;
            }

            public Map<String, Object> getGeneratedKeys() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("CustomerID", 1234);
                return map;
            }
        };
        String post = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<entry xml:base=\"http://host/service.svc/\"\nxmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\"\nxmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"\nxmlns=\"http://www.w3.org/2005/Atom\">\n    <content type=\"application/xml\">\n        <m:properties>\n            <d:CompanyName>JBoss</d:CompanyName>\n            <d:ContactName>Joe</d:ContactName>\n            <d:ContactTitle>1970</d:ContactTitle>\n            <d:Address>123 Main Street</d:Address>\n            <d:City>STL</d:City>\n            <d:Region>MidWest</d:Region>\n            <d:PostalCode>12345</d:PostalCode>\n            <d:Country>USA</d:Country>\n            <d:Phone>123234</d:Phone>\n        </m:properties>\n    </content>\n</entry>";
        Mockito.when((Object)client.executeUpdate((Command)Mockito.any(Command.class), Mockito.anyListOf(SQLParam.class))).thenReturn((Object)respose);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers"));
        request.body("application/atom+xml", (Object)post);
        ClientResponse response = request.post();
        ((Client)Mockito.verify((Object)client)).executeUpdate((Command)insertCmd.capture(), Mockito.anyListOf(SQLParam.class));
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class));
        Assert.assertEquals((Object)"INSERT INTO nw.Customers (CompanyName, ContactName, ContactTitle, Address, City, Region, PostalCode, Country, Phone) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object)((Command)insertCmd.getValue()).toString());
        Assert.assertEquals((Object)"SELECT g0.* FROM nw.Customers AS g0 WHERE g0.CustomerID = 1234 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)201L, (long)response.getStatus());
    }

    @Test
    public void testProcedureOptions() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor params = ArgumentCaptor.forClass(List.class);
        OCollection collection = (OCollection)Mockito.mock(OCollection.class);
        Mockito.stub((Object)collection.getType()).toReturn(Mockito.mock(EdmType.class));
        Mockito.stub((Object)collection.iterator()).toReturn(Mockito.mock(Iterator.class));
        ComplexCollection result = (ComplexCollection)Mockito.mock(ComplexCollection.class);
        Mockito.stub((Object)result.getCollection()).toReturn((Object)collection);
        Mockito.stub((Object)result.getCollectionName()).toReturn((Object)"any");
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenReturn((Object)result);
        String url = TestPortProvider.generateURL((String)"/odata/northwind/getSuppliers?p3=2&$filter=SupplierID eq 1");
        ClientRequest request = new ClientRequest(url);
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), (List)params.capture(), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class));
        Assert.assertEquals((Object)"SELECT g0.* FROM LATERAL(EXEC nw.getSuppliers(p3 => ?)) AS g0 WHERE g0.SupplierID = ?", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((Object)2, (Object)((SQLParam)((List)params.getValue()).get((int)0)).value);
        Assert.assertEquals((Object)1, (Object)((SQLParam)((List)params.getValue()).get((int)1)).value);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testProcedureOptions2() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        ArgumentCaptor params = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor queryInfo = ArgumentCaptor.forClass(QueryInfo.class);
        OCollection collection = (OCollection)Mockito.mock(OCollection.class);
        Mockito.stub((Object)collection.getType()).toReturn(Mockito.mock(EdmType.class));
        Mockito.stub((Object)collection.iterator()).toReturn(Mockito.mock(Iterator.class));
        ComplexCollection result = (ComplexCollection)Mockito.mock(ComplexCollection.class);
        Mockito.stub((Object)result.getCollection()).toReturn((Object)collection);
        Mockito.stub((Object)result.getCollectionName()).toReturn((Object)"any");
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenReturn((Object)result);
        String url = TestPortProvider.generateURL((String)"/odata/northwind/getSuppliers?p3=2&$select=SupplierID&$top=10&$orderby=SupplierID");
        ClientRequest request = new ClientRequest(url);
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), (List)params.capture(), (QueryInfo)queryInfo.capture(), (EntityCollector)Mockito.any(EntityCollector.class));
        Assert.assertEquals((Object)"SELECT g0.SupplierID FROM LATERAL(EXEC nw.getSuppliers(p3 => ?)) AS g0 ORDER BY g0.SupplierID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((Object)2, (Object)((SQLParam)((List)params.getValue()).get((int)0)).value);
        Assert.assertEquals((Object)10, (Object)((QueryInfo)queryInfo.getValue()).top);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testProcedure() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor params = ArgumentCaptor.forClass(List.class);
        Mockito.when((Object)client.executeCall((String)Mockito.any(String.class), Mockito.anyListOf(SQLParam.class), (EdmType)Mockito.any(EdmType.class))).thenReturn((Object)Responses.simple((EdmSimpleType)EdmSimpleType.INT32, (String)"return", null));
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/getCustomers?p2=datetime'2011-09-11T00:00:00'&p3=2.0M"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeCall((String)sql.capture(), (List)params.capture(), (EdmType)Mockito.any(EdmType.class));
        Assert.assertEquals((Object)"{ ? = CALL nw.getCustomers(p2 => ?, p3 => ?) }", (Object)((String)sql.getValue()).toString());
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)111, (int)8, (int)11, (int)0, (int)0, (int)0, (int)0), (Object)((SQLParam)((List)params.getValue()).get((int)0)).value);
        Assert.assertEquals((Object)BigDecimal.valueOf(2.0), (Object)((SQLParam)((List)params.getValue()).get((int)1)).value);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcedureNoReturn() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create procedure proc () as BEGIN END");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/proc"));
            ClientResponse response = request.post(String.class);
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    @Test
    public void testSkipNoPKTable() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/NoPKTable"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        String endsWith = "<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>NotFoundException</code><message lang=\"en-US\">TEIID16011 EntitySet \"NoPKTable\" is not found; Check the spelling, use modelName.tableName; The table that representing the Entity type must either have a PRIMARY KEY or UNIQUE key(s)</message></error>";
        Assert.assertTrue((boolean)((String)response.getEntity()).endsWith(endsWith));
    }

    @Test
    public void testError() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenThrow(new Throwable[]{new NullPointerException()});
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        String endsWith = "<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>ServerErrorException</code><message lang=\"en-US\">Internal Server Error</message></error>";
        Assert.assertTrue((boolean)((String)response.getEntity()).endsWith(endsWith));
    }

    @Test
    public void testSelect() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        EdmEntitySet entitySet = client.getMetadata().getEdmEntitySet("nw.Customers");
        Mockito.when((Object)result.getEntitySet()).thenReturn((Object)entitySet);
        Mockito.when((Object)result.getEntities()).thenReturn(Arrays.asList(entity));
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$select=CustomerID,CompanyName,Address"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class));
        Assert.assertEquals((Object)"SELECT g0.CustomerID, g0.CompanyName, g0.Address FROM nw.Customers AS g0 ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testSelectWithExpand() throws Exception {
        Client client;
        MockProvider.CLIENT = client = this.mockClient();
        ArgumentCaptor sql = ArgumentCaptor.forClass(Query.class);
        OEntity entity = this.createCustomersEntity(client.getMetadata());
        ArrayList<OEntity> list = new ArrayList<OEntity>();
        list.add(entity);
        EntityList result = (EntityList)Mockito.mock(EntityList.class);
        EdmEntitySet entitySet = client.getMetadata().getEdmEntitySet("nw.Customers");
        Mockito.when((Object)result.getEntitySet()).thenReturn((Object)entitySet);
        Mockito.when((Object)result.getEntities()).thenReturn(Arrays.asList(entity));
        Mockito.when((Object)result.size()).thenReturn((Object)1);
        Mockito.when((Object)result.iterator()).thenReturn(list.iterator());
        Mockito.when((Object)client.executeSQL((Query)Mockito.any(Query.class), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class))).thenReturn((Object)result);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers?$expand=Orders"));
        ClientResponse response = request.get(String.class);
        ((Client)Mockito.verify((Object)client)).executeSQL((Query)sql.capture(), Mockito.anyListOf(SQLParam.class), (QueryInfo)Mockito.any(QueryInfo.class), (EntityCollector)Mockito.any(EntityCollector.class));
        Assert.assertEquals((Object)"SELECT g0.*, g1.* FROM nw.Customers AS g0 INNER JOIN nw.Orders AS g1 ON g0.CustomerID = g1.CustomerID ORDER BY g0.CustomerID", (Object)((Query)sql.getValue()).toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntity() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b string) as select 'a', 'b' union all select 'c', 'd';\ncreate view y (a1 string primary key, b1 string, foreign key (a1) references x (a)) as select 'a', 'b' union all select 'c', 'd';\ncreate view z (a1 string, b1 string primary key,foreign key (a1) references x (a)) as select 'a', 'b' union all select 'c', 'd';");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')"));
            ClientResponse response = request.get(String.class);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("('a')"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$skip=2&$format=json"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertFalse((boolean)((String)response.getEntity()).contains("('a')"));
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('v')"));
            response = request.get(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')?$filter=b eq 'd'"));
            response = request.get(String.class);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("('a')"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')/y"));
            response = request.get(String.class);
            Assert.assertTrue((!((String)response.getEntity()).contains("<feed") ? 1 : 0) != 0);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')/z"));
            response = request.get(String.class);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<feed"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')/y?$filter=a1 eq 'c'"));
            response = request.get(String.class);
            Assert.assertFalse((boolean)((String)response.getEntity()).contains("('c')"));
            Assert.assertEquals((long)404L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCharacterReplacement() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b char, c string[], d integer) as select 'ab\u0000cd\u0001', char(22), ('a\u00021','b1'), 1;");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("invalid-xml10-character-replacement", " ");
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("ab cd "));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("a 1"));
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayResults() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer[], c string[][]) as select 'x', (1, 2, 3), (('a','b'),('c','d'));");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$select=a,b"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("1, 2, 3"));
            String expected = "{\n\"d\" : {\n\"results\" : [\n{\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/vw.x('x')\", \"type\" : \"vw.x\"\n}, \"a\" : \"x\", \"b\" : {\n\"results\" : [\n1, 2, 3\n]\n}, \"c\" : {\n\"results\" : [\n{\n\"results\" : [\n\"a\", \"b\"\n]\n}, {\n\"results\" : [\n\"c\", \"d\"\n]\n}\n]\n}\n}\n]\n}\n}";
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            response = request.get(String.class);
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayResultsInAtom() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer[], c string[][]) as select 'x', (1, 2, 3), (('a','b'),('c','d'));");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$select=a,b"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String expected = "<content type=\"application/xml\"><m:properties><d:a>x</d:a><d:b m:type=\"Collection(Edm.Int32)\"><d:element>1</d:element><d:element>2</d:element><d:element>3</d:element></d:b></m:properties></content>";
            Assert.assertTrue((boolean)((String)response.getEntity()).contains(expected));
            expected = "<m:properties><d:a>x</d:a><d:b m:type=\"Collection(Edm.Int32)\"><d:element>1</d:element><d:element>2</d:element><d:element>3</d:element></d:b><d:c m:type=\"Collection(Collection(Edm.String))\"><d:element m:type=\"Collection(Edm.String)\"><d:element>a</d:element><d:element>b</d:element></d:element><d:element m:type=\"Collection(Edm.String)\"><d:element>c</d:element><d:element>d</d:element></d:element></d:c></m:properties>";
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x"));
            response = request.get(String.class);
            Assert.assertTrue((String)((String)response.getEntity()), (boolean)((String)response.getEntity()).contains(expected));
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipToken() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            JSONValueExtractor contentHandler = new JSONValueExtractor("__next");
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNotNull((Object)contentHandler.next);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("abc"));
            Assert.assertTrue((!((String)response.getEntity()).contains("xyz") ? 1 : 0) != 0);
            URL url = new URL((String)contentHandler.value);
            String skip = this.getQueryParameter(URLDecoder.decode(url.getQuery(), "UTF-8"), "$skiptoken");
            Assert.assertTrue((skip.indexOf("--") != -1 ? 1 : 0) != 0);
            request = new ClientRequest((String)contentHandler.value);
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((!((String)response.getEntity()).contains("abc") ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("xyz"));
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNull((Object)contentHandler.value);
        }
        finally {
            es.stop();
        }
    }

    public String getQueryParameter(String queryPath, String param) {
        if (queryPath != null) {
            StringTokenizer st = new StringTokenizer(queryPath, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(61);
                if (index == -1) continue;
                String key = token.substring(0, index);
                String value = token.substring(index + 1);
                if (!key.equals(param)) continue;
                return value;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSkipToken() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("batch-size", "0");
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            JSONValueExtractor contentHandler = new JSONValueExtractor("__next");
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNotNull((Object)contentHandler.next);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("abc"));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("xyz"));
            Assert.assertNull((Object)contentHandler.value);
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCount() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b integer) as select 'xyz', 123 union all select 'abc', 456;");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            props.setProperty("batch-size", "1");
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$inlinecount=allpages&$top=1&$skip=1"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            JSONValueExtractor contentHandler = new JSONValueExtractor("__count");
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertEquals((Object)"2", (Object)contentHandler.value);
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("xyz"));
            Assert.assertTrue((!((String)response.getEntity()).contains("abc") ? 1 : 0) != 0);
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$inlinecount=allpages&$skip=1"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertEquals((Object)"2", (Object)contentHandler.value);
            contentHandler.key = "__next";
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNull((Object)contentHandler.value);
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json&$inlinecount=allpages"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            contentHandler.value = null;
            parser.parse((String)response.getEntity(), (ContentHandler)contentHandler);
            Assert.assertNotNull((Object)contentHandler.value);
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x/$count"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"2", (Object)response.getEntity());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompositeKeyUpdates() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        hc.addUpdate("UPDATE x SET c = 5 WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a, b)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',b='b')"));
            ClientResponse response = request.delete(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')"));
            response = request.delete(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',a='b')"));
            response = request.delete(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',b='b')"));
            request.body("application/json", (Object)"{\"c\":5}");
            response = request.put(String.class);
            Assert.assertEquals((long)204L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdates() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a'", new int[]{0});
        hc.addUpdate("UPDATE x SET c = 5 WHERE x.a = 'a'", new int[]{0});
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a')"));
            ClientResponse response = request.delete(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x(a='a',b='b')"));
            request.body("application/json", (Object)"{\"c\":5}");
            response = request.put(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatch() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addUpdate("DELETE FROM x WHERE x.a = 'a' AND x.b = 'b'", new int[]{1});
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a, b)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            String post = "Content-Type: application/http\nContent-Transfer-Encoding:binary\n\nDELETE /odata/northwind/x(a='a',b='b') HTTP/1.1\n--batch_36522ad7-fc75-4b56-8c71-56071383e77b\n";
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Customers/$batch"));
            request.body("multipart/mixed", (Object)post);
            ClientResponse response = request.post(String.class);
            Assert.assertEquals((long)202L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJsonProcedureResultSet() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory();
        hc.addData("EXEC x()", Arrays.asList(Arrays.asList("x"), Arrays.asList("y")));
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign procedure x () returns table(y string);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            String expected = "{\n\"d\" : [\n{\n\"y\" : \"x\"\n}, {\n\"y\" : \"y\"\n}\n]\n}";
            ClientRequest clientRequest = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x?$format=json"));
            ClientResponse response = clientRequest.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicTypes() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setSchemaSourceType("ddl");
            mmd.addSourceMapping("x", "x", null);
            MetadataStore ms = RealMetadataFactory.exampleBQTStore();
            Schema s = ms.getSchema("BQT1");
            KeyRecord pk = new KeyRecord(KeyRecord.Type.Primary);
            Table smalla = s.getTable("SmallA");
            pk.setName("pk");
            pk.addColumn(smalla.getColumnByName("IntKey"));
            smalla.setPrimaryKey(pk);
            String ddl = DDLStringVisitor.getDDLString((Schema)s, EnumSet.allOf(Admin.SchemaObjectType.class), (String)"SmallA");
            mmd.setSchemaText(ddl);
            HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

                protected List<? extends List<?>> getData(QueryExpression command) {
                    Class[] colTypes = command.getProjectedQuery().getColumnTypes();
                    ArrayList<ElementSymbol> cols = new ArrayList<ElementSymbol>();
                    for (int i = 0; i < colTypes.length; ++i) {
                        ElementSymbol elementSymbol = new ElementSymbol("X");
                        elementSymbol.setType(colTypes[i]);
                        cols.add(elementSymbol);
                    }
                    return Arrays.asList(AutoGenDataService.createResults(cols, (int)1, (boolean)false));
                }
            };
            es.addTranslator("x", (ExecutionFactory)hc);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/SmallA?$format=json&$select=TimeValue"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionProperties() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.addSourceMetadata("ddl", "create view v as select 1");
            Properties props = new Properties();
            props.setProperty("connection.resultSetCacheMode", "true");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            ConnectionImpl impl = lc.getConnection();
            Assert.assertEquals((Object)"true", (Object)impl.getExecutionProperty("resultSetCacheMode"));
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmbeddedComplexType() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.setModelType(Model.Type.VIRTUAL);
            mmd.addSourceMetadata("ddl", "CREATE VIEW Employees ( EmployeeID integer primary key, LastName varchar(20), FirstName varchar(10), Address varchar(60) options (\"teiid_odata:columngroup\" 'Address', \"teiid_odata:complextype\" 'NorthwindModel.Address'),City varchar(15) options (\"teiid_odata:columngroup\" 'Address', \"teiid_odata:complextype\" 'NorthwindModel.Address')) as select 1, 'wayne', 'john', '123 place', 'hollywood'");
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/Employees?$format=json&$select=Address"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            JSONParser parser = new JSONParser();
            SimpleContentHandler sch = new SimpleContentHandler();
            parser.parse((String)response.getEntity(), (ContentHandler)sch);
            Map result = (Map)sch.getResult();
            List results = (List)((Map)result.get("d")).get("results");
            result = (Map)results.get(0);
            Assert.assertEquals((Object)"123 place", result.get("Address"));
            Assert.assertNull(result.get("City"));
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAmbiguities() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key) as select 'a'; create virtual procedure y () returns table(y string) as select 'a';");
            mmd.setModelType(Model.Type.VIRTUAL);
            ModelMetaData mmd1 = new ModelMetaData();
            mmd1.setName("vw1");
            mmd1.addSourceMetadata("ddl", "create view x (a string primary key) as select 'a'; create virtual procedure y () returns table(y string) as select 'a';");
            mmd1.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd, mmd1});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/y"));
            response = request.get(String.class);
            Assert.assertEquals((long)404L, (long)response.getStatus());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnselectable() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("vw");
            mmd.addSourceMetadata("ddl", "create view x (a string primary key, b string options (selectable false)) as select 'a', 'hello';");
            mmd.setModelType(Model.Type.VIRTUAL);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertFalse((boolean)((String)response.getEntity()).contains("hello"));
        }
        finally {
            es.stop();
        }
    }

    private OEntity createCustomersEntity(EdmDataServices metadata) {
        EdmEntitySet entitySet = metadata.findEdmEntitySet("Customers");
        OEntityKey entityKey = OEntityKey.parse((String)"CustomerID='12'");
        ArrayList<OProperty> properties = new ArrayList<OProperty>();
        properties.add(OProperties.string((String)"CompanyName", (String)"teiid"));
        properties.add(OProperties.string((String)"ContactName", (String)"contact-name"));
        properties.add(OProperties.string((String)"ContactTitle", (String)"contact-title"));
        properties.add(OProperties.string((String)"Address", (String)"address"));
        properties.add(OProperties.string((String)"City", (String)"city"));
        properties.add(OProperties.string((String)"Region", (String)"region"));
        properties.add(OProperties.string((String)"PostalCode", (String)"postal-code"));
        properties.add(OProperties.string((String)"Country", (String)"country"));
        properties.add(OProperties.string((String)"Phone", (String)"555-1212"));
        properties.add(OProperties.string((String)"Fax", (String)"555-1212"));
        OEntity entity = OEntities.create((EdmEntitySet)entitySet, (OEntityKey)entityKey, properties, null);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperty() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hc.addData("SELECT x.a FROM x WHERE x.a = 'a'", Arrays.asList(Arrays.asList("x"), Arrays.asList("y")));
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string, b string, c integer, primary key (a)) options (updatable true);");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')/a?$format=json"));
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String expected = "{\n\"d\" : {\n\"a\" : \"x\"\n}\n}";
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')/a/$value?$format=json"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            expected = "x";
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
            request = new ClientRequest(TestPortProvider.generateURL((String)"/odata/northwind/x('a')/a/$value"));
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            expected = "x";
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpandJson() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean supportsInnerJoins() {
                return true;
            }

            public boolean supportsOuterJoins() {
                return true;
            }
        };
        hc.addData("SELECT x.a, x.b, y.a1, y.b1 FROM x, y WHERE x.a = y.a1", Arrays.asList(Arrays.asList("xa", "xb", "xa", "yb"), Arrays.asList("xa1", "xb1", "xa1", "yb1"), Arrays.asList("xa2", "xb2", "xa2", "yb2")));
        hc.addData("SELECT x.a, x.b, z.a1, z.b1 FROM x, z WHERE x.a = z.a1", Arrays.asList(Arrays.asList("xa", "xb", "xa", "zb"), Arrays.asList("xa", "xb", "xa", "zb1"), Arrays.asList("xa", "xb", "xa", "zb2")));
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string primary key, b string);\ncreate foreign table y (a1 string primary key, b1 string, foreign key (a1) references x (a)); \ncreate foreign table z (a1 string, b1 string primary key,foreign key (a1) references x (a));");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            String url = TestPortProvider.generateURL((String)"/odata/northwind/x?$expand=y&$format=json&$inlinecount=allpages");
            ClientRequest request = new ClientRequest(url);
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String expected = "{\n\"d\" : {\n\"results\" : [\n{\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa')\", \"type\" : \"m.x\"\n}, \"a\" : \"xa\", \"b\" : \"xb\", \"y\" : {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.y('xa')\", \"type\" : \"m.y\"\n}, \"a1\" : \"xa\", \"b1\" : \"yb\"\n}, \"z\" : {\n\"__deferred\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa')/z\"\n}\n}\n}, {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa1')\", \"type\" : \"m.x\"\n}, \"a\" : \"xa1\", \"b\" : \"xb1\", \"y\" : {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.y('xa1')\", \"type\" : \"m.y\"\n}, \"a1\" : \"xa1\", \"b1\" : \"yb1\"\n}, \"z\" : {\n\"__deferred\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa1')/z\"\n}\n}\n}, {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa2')\", \"type\" : \"m.x\"\n}, \"a\" : \"xa2\", \"b\" : \"xb2\", \"y\" : {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.y('xa2')\", \"type\" : \"m.y\"\n}, \"a1\" : \"xa2\", \"b1\" : \"yb2\"\n}, \"z\" : {\n\"__deferred\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa2')/z\"\n}\n}\n}\n]\n}\n}";
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
            url = TestPortProvider.generateURL((String)"/odata/northwind/x?$expand=z&$format=json");
            request = new ClientRequest(url);
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            expected = "{\n\"d\" : {\n\"results\" : [\n{\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa')\", \"type\" : \"m.x\"\n}, \"a\" : \"xa\", \"b\" : \"xb\", \"y\" : {\n\"__deferred\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.x('xa')/y\"\n}\n}, \"z\" : {\n\"results\" : [\n{\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.z('zb')\", \"type\" : \"m.z\"\n}, \"a1\" : \"xa\", \"b1\" : \"zb\"\n}, {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.z('zb1')\", \"type\" : \"m.z\"\n}, \"a1\" : \"xa\", \"b1\" : \"zb1\"\n}, {\n\"__metadata\" : {\n\"uri\" : \"http://localhost:8081/odata/northwind/m.z('zb2')\", \"type\" : \"m.z\"\n}, \"a1\" : \"xa\", \"b1\" : \"zb2\"\n}\n]\n}\n}\n]\n}\n}";
            Assert.assertEquals((Object)expected, (Object)response.getEntity());
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpandXML() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean supportsInnerJoins() {
                return true;
            }

            public boolean supportsOuterJoins() {
                return true;
            }
        };
        hc.addData("SELECT x.a, x.b, y.a1, y.b1 FROM x, y WHERE x.a = y.a1", Arrays.asList(Arrays.asList("xa", "xb", "xa", "yb"), Arrays.asList("xa1", "xb1", "xa1", "yb1"), Arrays.asList("xa2", "xb2", "xa2", "yb2")));
        hc.addData("SELECT x.a, x.b, z.a1, z.b1 FROM x, z WHERE x.a = z.a1", Arrays.asList(Arrays.asList("xa", "xb", "xa", "zb"), Arrays.asList("xa", "xb", "xa", "zb1"), Arrays.asList("xa", "xb", "xa", "zb2")));
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string primary key, b string);\ncreate foreign table y (a1 string primary key, b1 string, foreign key (a1) references x (a)); \ncreate foreign table z (a1 string, b1 string primary key,foreign key (a1) references x (a));");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            String url = TestPortProvider.generateURL((String)"/odata/northwind/x?$expand=y");
            ClientRequest request = new ClientRequest(url);
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<m:inline>"));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<id>http://localhost:8081/odata/northwind/m.y('xa')</id>"));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<id>http://localhost:8081/odata/northwind/m.x('xa2')</id>"));
            url = TestPortProvider.generateURL((String)"/odata/northwind/x?$expand=z");
            request = new ClientRequest(url);
            response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<m:inline>"));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<id>http://localhost:8081/odata/northwind/m.z('zb')</id>"));
            Assert.assertTrue((boolean)((String)response.getEntity()).contains("<id>http://localhost:8081/odata/northwind/m.z('zb2')</id>"));
        }
        finally {
            es.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleNavigationsBetweenSameEntities() throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean supportsInnerJoins() {
                return true;
            }

            public boolean supportsOuterJoins() {
                return true;
            }
        };
        hc.addData("SELECT x.a, x.b, y.a1, y.b1 FROM x, y WHERE x.a = y.a1", Arrays.asList(Arrays.asList("xa", "xb", "xa", "yb"), Arrays.asList("xa1", "xb1", "xa1", "yb1"), Arrays.asList("xa2", "xb2", "xa2", "yb2")));
        hc.addData("SELECT x.a, x.b, z.a1, z.b1 FROM x, z WHERE x.a = z.a1", Arrays.asList(Arrays.asList("xa", "xb", "xa", "zb"), Arrays.asList("xa", "xb", "xa", "zb1"), Arrays.asList("xa", "xb", "xa", "zb2")));
        es.addTranslator("x", (ExecutionFactory)hc);
        es.start(new EmbeddedConfiguration());
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("m");
            mmd.addSourceMetadata("ddl", "create foreign table x (a string primary key, b string);\ncreate foreign table y (a1 string primary key, b1 string, foreign key (a1) references x (a),foreign key (b1) references x (a));");
            mmd.addSourceMapping("x", "x", null);
            es.deployVDB("northwind", new ModelMetaData[]{mmd});
            TeiidDriver td = es.getDriver();
            Properties props = new Properties();
            LocalClient lc = new LocalClient("northwind", "1", props);
            lc.setDriver(td);
            MockProvider.CLIENT = lc;
            String payload = "<NavigationProperty Name=\"y\" Relationship=\"m.y_FK0\" FromRole=\"x\" ToRole=\"y\"></NavigationProperty><NavigationProperty Name=\"y1\" Relationship=\"m.y_FK1\" FromRole=\"x\" ToRole=\"y\">";
            String url = TestPortProvider.generateURL((String)"/odata/northwind/$metadata");
            ClientRequest request = new ClientRequest(url);
            ClientResponse response = request.get(String.class);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)((String)response.getEntity()).contains(payload));
        }
        finally {
            es.stop();
        }
    }

    private static final class JSONValueExtractor
    implements ContentHandler {
        Object value;
        boolean next;
        String key;

        private JSONValueExtractor(String key) {
            this.key = key;
        }

        public boolean startObjectEntry(String key) throws ParseException, IOException {
            if (key.equals(this.key)) {
                this.next = true;
            }
            return true;
        }

        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        public void startJSON() throws ParseException, IOException {
        }

        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        public boolean primitive(Object value) throws ParseException, IOException {
            if (this.next) {
                this.value = value;
                this.next = false;
            }
            return true;
        }

        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        public void endJSON() throws ParseException, IOException {
        }

        public boolean endArray() throws ParseException, IOException {
            return true;
        }
    }
}

