/*
 * Decompiled with CFR 0.152.
 */
package org.core4j;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.Func2;
import org.core4j.Grouping;
import org.core4j.Predicate1;
import org.core4j.ReadOnlyIterator;

public class Enumerable<T>
implements Iterable<T> {
    private final Iterable<T> values;

    protected Enumerable(Iterable<T> values) {
        if (values == null) {
            throw new RuntimeException("values cannot be null");
        }
        this.values = values;
    }

    public static <T> Enumerable<T> create(T ... values) {
        return new Enumerable<T>(new ArrayIterable<T>(values));
    }

    public static <T> Enumerable<T> create(Iterable<T> values) {
        return new Enumerable<T>(values);
    }

    public static <T> Enumerable<T> create(Class<T> clazz, Enumeration<?> e) {
        ArrayList rt = new ArrayList();
        while (e.hasMoreElements()) {
            rt.add(e.nextElement());
        }
        return new Enumerable(rt);
    }

    public static <T> Enumerable<T> createFromIterator(Func<Iterator<T>> fn) {
        return new Enumerable<T>(Enumerable.makeIterable(fn));
    }

    public T[] toArray(Class<T> clazz) {
        List<T> rt = this.toList();
        Object[] array = (Object[])Array.newInstance(clazz, rt.size());
        for (int i = 0; i < array.length; ++i) {
            array[i] = rt.get(i);
        }
        return array;
    }

    public List<T> toList() {
        ArrayList<T> rt = new ArrayList<T>();
        for (T value : this.values) {
            rt.add(value);
        }
        return rt;
    }

    public Set<T> toSet() {
        HashSet<T> rt = new HashSet<T>();
        for (T value : this.values) {
            rt.add(value);
        }
        return rt;
    }

    public SortedSet<T> toSortedSet() {
        TreeSet<T> rt = new TreeSet<T>();
        for (T value : this.values) {
            rt.add(value);
        }
        return rt;
    }

    public SortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        TreeSet<T> rt = new TreeSet<T>(comparator);
        for (T value : this.values) {
            rt.add(value);
        }
        return rt;
    }

    public <K> Map<K, T> toMap(Func1<T, K> keyFn) {
        HashMap<K, T> rt = new HashMap<K, T>();
        for (T value : this.values) {
            rt.put(keyFn.apply(value), value);
        }
        return rt;
    }

    public int count() {
        int rt = 0;
        for (T value : this.values) {
            ++rt;
        }
        return rt;
    }

    public T first() {
        Iterator<T> iterator = this.values.iterator();
        if (iterator.hasNext()) {
            T value = iterator.next();
            return value;
        }
        throw new RuntimeException("No elements");
    }

    public T first(Predicate1<T> predicate) {
        for (T value : this.values) {
            if (!predicate.apply(value)) continue;
            return value;
        }
        throw new RuntimeException("No elements match the predicate");
    }

    public T firstOrNull() {
        Iterator<T> iterator = this.values.iterator();
        if (iterator.hasNext()) {
            T value = iterator.next();
            return value;
        }
        return null;
    }

    public T firstOrNull(Predicate1<T> predicate) {
        for (T value : this.values) {
            if (!predicate.apply(value)) continue;
            return value;
        }
        return null;
    }

    public Enumerable<T> where(Predicate1<T> predicate) {
        return new Enumerable<T>(new PredicateIterable<T>(this, predicate));
    }

    public <TOutput> Enumerable<TOutput> select(Func1<T, TOutput> projection) {
        return new Enumerable<T>(new FuncIterable<T, TOutput>(this, projection));
    }

    public static <K, E> Map<K, List<E>> group(Collection<E> c, Func1<E, K> projection) {
        HashMap<K, ArrayList<E>> map = new HashMap<K, ArrayList<E>>();
        for (E e : c) {
            K key = projection.apply(e);
            if (key == null) continue;
            ArrayList<E> list = (ArrayList<E>)map.get(key);
            if (list == null) {
                list = new ArrayList<E>();
                map.put(key, list);
            }
            list.add(e);
        }
        return map;
    }

    public T last() {
        T rt = null;
        boolean empty = true;
        for (T value : this.values) {
            empty = false;
            rt = value;
        }
        if (empty) {
            throw new RuntimeException("No elements");
        }
        return rt;
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    public Enumerable<T> reverse() {
        List<T> rt = this.toList();
        Collections.reverse(rt);
        return new Enumerable<T>(rt);
    }

    private List<Iterable<T>> thisThenOthers(Iterable<T> ... others) {
        ArrayList<Iterable<T>> rt = new ArrayList<Iterable<T>>();
        rt.add(this);
        for (Iterable<T> other : others) {
            rt.add(other);
        }
        return rt;
    }

    public Enumerable<T> concat(Iterable<T> other) {
        return this.concat(new Iterable[]{other});
    }

    public Enumerable<T> concat(Iterable<T> ... others) {
        List<Iterable<T>> rt = this.thisThenOthers(others);
        return new Enumerable<T>(new ConcatIterable<T>(rt));
    }

    public Enumerable<T> concat(T ... others) {
        return this.concat(new Enumerable[]{Enumerable.create(others)});
    }

    public Enumerable<T> take(final int count) {
        return Enumerable.createFromIterator(new Func<Iterator<T>>(){

            @Override
            public Iterator<T> apply() {
                return new TakeIterator(Enumerable.this, count);
            }
        });
    }

    public boolean any(Predicate1<T> predicate) {
        for (T value : this.values) {
            if (!predicate.apply(value)) continue;
            return true;
        }
        return false;
    }

    public boolean all(Predicate1<T> predicate) {
        for (T value : this.values) {
            if (predicate.apply(value)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(T value) {
        for (T existingValue : this.values) {
            if (!existingValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    public T elementAt(int index) {
        int i = 0;
        for (T value : this.values) {
            if (index != i++) continue;
            return value;
        }
        throw new RuntimeException("No element at index " + index);
    }

    public T elementAtOrNull(int index) {
        int i = 0;
        for (T value : this.values) {
            if (index != i++) continue;
            return value;
        }
        return null;
    }

    public <TReturn> TReturn aggregate(Class<TReturn> clazz, Func2<T, TReturn, TReturn> aggregation) {
        return this.aggregate(clazz, null, aggregation);
    }

    public <TReturn> TReturn aggregate(Class<TReturn> clazz, TReturn initialValue, Func2<T, TReturn, TReturn> aggregation) {
        TReturn rt = initialValue;
        for (T value : this.values) {
            rt = aggregation.apply(value, rt);
        }
        return rt;
    }

    public <TReturn> TReturn sum(final Class<TReturn> clazz) {
        if (clazz.equals(Double.class) || clazz.equals(Integer.class) || clazz.equals(BigDecimal.class)) {
            Func2 aggregation = new Func2<T, TReturn, TReturn>(){

                @Override
                public TReturn apply(T input1, TReturn input2) {
                    Number n1 = (Number)input1;
                    Number n2 = (Number)input2;
                    if (clazz.equals(Double.class)) {
                        Double rt = n1.doubleValue() + (n2 == null ? 0.0 : n2.doubleValue());
                        return rt;
                    }
                    if (clazz.equals(Integer.class)) {
                        Integer rt = n1.intValue() + (n2 == null ? 0 : n2.intValue());
                        return rt;
                    }
                    if (clazz.equals(BigDecimal.class)) {
                        if (n1 instanceof Integer) {
                            n1 = BigDecimal.valueOf(((Integer)n1).intValue());
                        }
                        if (n1 instanceof Double) {
                            n1 = BigDecimal.valueOf((Double)n1);
                        }
                        BigDecimal bd1 = n1 == null ? BigDecimal.ZERO : (BigDecimal)n1;
                        BigDecimal bd2 = n2 == null ? BigDecimal.ZERO : (BigDecimal)n2;
                        BigDecimal rt = bd1.add(bd2);
                        return rt;
                    }
                    throw new UnsupportedOperationException("No default aggregation for class " + clazz.getSimpleName());
                }
            };
            return this.aggregate(clazz, aggregation);
        }
        throw new UnsupportedOperationException("No default aggregation for class " + clazz.getSimpleName());
    }

    public <TReturn> TReturn sum(Class<TReturn> clazz, Func1<T, TReturn> projection) {
        Enumerable<TReturn> rt = this.select(projection);
        return rt.sum(clazz);
    }

    public <TKey extends Comparable<TKey>> Enumerable<T> orderBy(final Func1<T, TKey> projection) {
        return this.orderBy(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable lhs = (Comparable)projection.apply(o1);
                Comparable rhs = (Comparable)projection.apply(o2);
                return lhs.compareTo(rhs);
            }
        });
    }

    public Enumerable<T> orderBy(Comparator<T> comparator) {
        List<T> rt = this.toList();
        Collections.sort(rt, comparator);
        return Enumerable.create(rt);
    }

    public Enumerable<T> orderBy() {
        return this.orderBy(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable lhs = (Comparable)o1;
                return lhs.compareTo(o2);
            }
        });
    }

    public String join(String separator) {
        StringBuilder rt = new StringBuilder();
        boolean isFirst = true;
        for (T value : this) {
            if (isFirst) {
                isFirst = false;
            } else {
                rt.append(separator);
            }
            rt.append(value == null ? "" : value.toString());
        }
        return rt.toString();
    }

    public static <T> Enumerable<T> empty(Class<T> clazz) {
        return Enumerable.create(new Object[0]);
    }

    public static Enumerable<Integer> range(final int start, final int count) {
        return Enumerable.createFromIterator(new Func<Iterator<Integer>>(){

            @Override
            public Iterator<Integer> apply() {
                return new RangeIterator(start, count);
            }
        });
    }

    public <TOutput> Enumerable<TOutput> cast(Class<TOutput> clazz) {
        return this.select(new Func1<T, TOutput>(){

            @Override
            public TOutput apply(T input) {
                return input;
            }
        });
    }

    public <TOutput> Enumerable<TOutput> ofType(Class<TOutput> clazz) {
        final Class<TOutput> finalClazz = clazz;
        return this.where(new Predicate1<T>(){

            @Override
            public boolean apply(T input) {
                return input != null && finalClazz.isAssignableFrom(input.getClass());
            }
        }).cast(clazz);
    }

    public Enumerable<T> skip(int count) {
        return Enumerable.create(new SkipEnumerable(this, count));
    }

    public Enumerable<T> skipWhile(final Predicate1<T> predicate) {
        final Boolean[] skipping = new Boolean[]{true};
        return this.where(new Predicate1<T>(){

            @Override
            public boolean apply(T input) {
                if (!skipping[0].booleanValue()) {
                    return true;
                }
                if (!predicate.apply(input)) {
                    skipping[0] = false;
                    return true;
                }
                return false;
            }
        });
    }

    public Enumerable<T> intersect(Enumerable<T> other) {
        return this.intersect(new Enumerable[]{other});
    }

    public Enumerable<T> intersect(Enumerable<T> ... others) {
        List<T> rt = this.distinct().toList();
        for (Enumerable<T> other : others) {
            Set<T> set = other.toSet();
            for (T value : Enumerable.create(rt).toList()) {
                if (set.contains(value)) continue;
                rt.remove(value);
            }
        }
        return Enumerable.create(rt);
    }

    public Enumerable<T> union(Enumerable<T> other) {
        return this.union(new Enumerable[]{other});
    }

    public Enumerable<T> union(Enumerable<T> ... others) {
        final List<Iterable<T>> rt = this.thisThenOthers(others);
        return Enumerable.create(Enumerable.makeIterable(new Func<Iterator<T>>(){

            @Override
            public Iterator<T> apply() {
                return new UnionIterator(rt);
            }
        }));
    }

    private static <T> Iterable<T> makeIterable(final Func<Iterator<T>> fn) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)fn.apply();
            }
        };
    }

    public <TResult> Enumerable<TResult> selectMany(final Func1<T, Enumerable<TResult>> selector) {
        return Enumerable.createFromIterator(new Func<Iterator<TResult>>(){

            @Override
            public Iterator<TResult> apply() {
                return new SelectManyIterator(Enumerable.this, selector);
            }
        });
    }

    public Enumerable<T> distinct() {
        return Enumerable.createFromIterator(new Func<Iterator<T>>(){

            @Override
            public Iterator<T> apply() {
                return new DistinctIterator(Enumerable.this);
            }
        });
    }

    public <TKey> Enumerable<Grouping<TKey, T>> groupBy(Func1<T, TKey> keySelector) {
        ArrayList<TKey> ordering = new ArrayList<TKey>();
        final HashMap map = new HashMap();
        for (T value : this) {
            TKey key = keySelector.apply(value);
            if (!ordering.contains(key)) {
                ordering.add(key);
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(value);
        }
        return Enumerable.create(ordering).select(new Func1<TKey, Grouping<TKey, T>>(){

            @Override
            public Grouping<TKey, T> apply(TKey input) {
                return new Grouping(input, Enumerable.create((Iterable)map.get(input)));
            }
        });
    }

    public <TResult extends Comparable<TResult>> TResult max(Func1<T, TResult> fn) {
        Comparable rt = null;
        for (T value : this) {
            Comparable newValue = (Comparable)fn.apply(value);
            if (newValue == null) continue;
            if (rt == null) {
                rt = newValue;
                continue;
            }
            if (newValue.compareTo(rt) <= 0) continue;
            rt = newValue;
        }
        return (TResult)rt;
    }

    public <TResult extends Comparable<TResult>> TResult min(Func1<T, TResult> fn) {
        Comparable rt = null;
        for (T value : this) {
            Comparable newValue = (Comparable)fn.apply(value);
            if (newValue == null) continue;
            if (rt == null) {
                rt = newValue;
                continue;
            }
            if (newValue.compareTo(rt) >= 0) continue;
            rt = newValue;
        }
        return (TResult)rt;
    }

    private static class DistinctIterator<T>
    extends ReadOnlyIterator<T> {
        private final Iterator<T> iterator;
        private Set<T> seen;

        public DistinctIterator(Iterable<T> source) {
            this.iterator = source.iterator();
        }

        @Override
        protected ReadOnlyIterator.IterationResult<T> advance() throws Exception {
            if (this.seen == null) {
                this.seen = new HashSet<T>();
            }
            while (this.iterator.hasNext()) {
                T value = this.iterator.next();
                if (this.seen.contains(value)) continue;
                this.seen.add(value);
                return ReadOnlyIterator.IterationResult.next(value);
            }
            return ReadOnlyIterator.IterationResult.done();
        }
    }

    private static class SelectManyIterator<TSource, TResult>
    extends ReadOnlyIterator<TResult> {
        private final Iterator<TSource> sourceIterator;
        private final Func1<TSource, Enumerable<TResult>> selector;
        private Iterator<TResult> resultIterator;

        public SelectManyIterator(Iterable<TSource> source, Func1<TSource, Enumerable<TResult>> selector) {
            this.selector = selector;
            this.sourceIterator = source.iterator();
        }

        @Override
        protected ReadOnlyIterator.IterationResult<TResult> advance() throws Exception {
            while (true) {
                if (this.resultIterator == null) {
                    if (!this.sourceIterator.hasNext()) {
                        return ReadOnlyIterator.IterationResult.done();
                    }
                    TSource source = this.sourceIterator.next();
                    this.resultIterator = this.selector.apply(source).iterator();
                }
                if (this.resultIterator.hasNext()) break;
                this.resultIterator = null;
            }
            return ReadOnlyIterator.IterationResult.next(this.resultIterator.next());
        }
    }

    private static class UnionIterator<T>
    extends ReadOnlyIterator<T> {
        private final List<Iterable<T>> involved;
        private Set<T> seen;
        private int currentIndex = -1;
        private Iterator<T> currentIterator;

        public UnionIterator(List<Iterable<T>> involved) {
            this.involved = involved;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<T> advance() {
            T value;
            if (this.seen == null) {
                this.seen = new HashSet<T>();
            }
            while (true) {
                if (this.currentIterator == null) {
                    ++this.currentIndex;
                    if (this.currentIndex >= this.involved.size()) {
                        return ReadOnlyIterator.IterationResult.done();
                    }
                    this.currentIterator = this.involved.get(this.currentIndex).iterator();
                }
                if (!this.currentIterator.hasNext()) {
                    this.currentIterator = null;
                    continue;
                }
                value = this.currentIterator.next();
                if (!this.seen.contains(value)) break;
            }
            this.seen.add(value);
            return ReadOnlyIterator.IterationResult.next(value);
        }
    }

    private static class SkipEnumerable<T>
    implements Iterable<T> {
        private final Enumerable<T> target;
        private final int count;

        public SkipEnumerable(Enumerable<T> target, int count) {
            this.target = target;
            this.count = count;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator<T> rt = this.target.iterator();
            for (int i = 0; i < this.count; ++i) {
                if (!rt.hasNext()) {
                    return rt;
                }
                rt.next();
            }
            return rt;
        }
    }

    private static class RangeIterator
    extends ReadOnlyIterator<Integer> {
        private final int end;
        private Integer current;

        public RangeIterator(int start, int count) {
            this.current = start;
            this.end = start + count - 1;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<Integer> advance() throws Exception {
            if (this.current == null) {
                return ReadOnlyIterator.IterationResult.done();
            }
            int rt = this.current;
            this.current = rt == this.end ? null : Integer.valueOf(rt + 1);
            return ReadOnlyIterator.IterationResult.next(rt);
        }
    }

    private static class ConcatIterator<T>
    implements Iterator<T> {
        private final List<Iterator<T>> iterators;
        private int current;

        public ConcatIterator(List<Iterator<T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            boolean rt = this.iterators.get(this.current).hasNext();
            while (!rt) {
                if (this.current == this.iterators.size() - 1) {
                    return rt;
                }
                ++this.current;
                rt = this.iterators.get(this.current).hasNext();
            }
            return rt;
        }

        @Override
        public T next() {
            while (true) {
                try {
                    return this.iterators.get(this.current).next();
                }
                catch (NoSuchElementException e) {
                    if (this.current == this.iterators.size() - 1) {
                        throw new NoSuchElementException();
                    }
                    ++this.current;
                    continue;
                }
                break;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    private static class ConcatIterable<T>
    implements Iterable<T> {
        private final Iterable<Iterable<T>> iterables;

        public ConcatIterable(Iterable<Iterable<T>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new ConcatIterator(Enumerable.create(this.iterables).select(new Func1<Iterable<T>, Iterator<T>>(){

                @Override
                public Iterator<T> apply(Iterable<T> x) {
                    return x.iterator();
                }
            }).toList());
        }
    }

    private static class FuncIterator<X, Y>
    implements Iterator<Y> {
        private final Iterator<X> iterator;
        private final Func1<X, Y> projection;

        public FuncIterator(Iterator<X> iterator, Func1<X, Y> projection) {
            this.iterator = iterator;
            this.projection = projection;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Y next() {
            return this.projection.apply(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class FuncIterable<X, Y>
    implements Iterable<Y> {
        private final Iterable<X> iterable;
        private final Func1<X, Y> projection;

        public FuncIterable(Iterable<X> iterable, Func1<X, Y> projection) {
            this.iterable = iterable;
            this.projection = projection;
        }

        @Override
        public Iterator<Y> iterator() {
            return new FuncIterator<X, Y>(this.iterable.iterator(), this.projection);
        }
    }

    private static class PredicateIterator<T>
    extends ReadOnlyIterator<T> {
        private final Iterator<T> iterator;
        private final Predicate1<T> predicate;
        private boolean useEx = true;

        public PredicateIterator(Iterator<T> i, Predicate1<T> p) {
            this.iterator = i;
            this.predicate = p;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<T> advance() {
            if (this.useEx) {
                try {
                    T rt = this.iterator.next();
                    while (!this.predicate.apply(rt)) {
                        rt = this.iterator.next();
                    }
                    return ReadOnlyIterator.IterationResult.next(rt);
                }
                catch (NoSuchElementException e) {
                    return ReadOnlyIterator.IterationResult.done();
                }
            }
            if (this.iterator.hasNext()) {
                T rt = this.iterator.next();
                while (!this.predicate.apply(rt)) {
                    if (this.iterator.hasNext()) {
                        rt = this.iterator.next();
                        continue;
                    }
                    return ReadOnlyIterator.IterationResult.done();
                }
                return ReadOnlyIterator.IterationResult.next(rt);
            }
            return ReadOnlyIterator.IterationResult.done();
        }
    }

    private static class PredicateIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;
        private final Predicate1<T> predicate;

        public PredicateIterable(Iterable<T> i, Predicate1<T> p) {
            this.iterable = i;
            this.predicate = p;
        }

        @Override
        public Iterator<T> iterator() {
            return new PredicateIterator<T>(this.iterable.iterator(), this.predicate);
        }
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] values;
        private int current = -1;

        public ArrayIterator(T[] values) {
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.values.length - 1;
        }

        @Override
        public T next() {
            try {
                return this.values[++this.current];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    private static class ArrayIterable<T>
    implements Iterable<T> {
        private final T[] values;

        public ArrayIterable(T[] values) {
            this.values = values;
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayIterator<T>(this.values);
        }
    }

    private static class TakeIterator<T>
    extends ReadOnlyIterator<T> {
        private int left;
        private Iterator<T> iterator;

        public TakeIterator(Iterable<T> values, int count) {
            this.iterator = values.iterator();
            this.left = count;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<T> advance() throws Exception {
            if (this.left <= 0) {
                return ReadOnlyIterator.IterationResult.done();
            }
            if (!this.iterator.hasNext()) {
                return ReadOnlyIterator.IterationResult.done();
            }
            --this.left;
            return ReadOnlyIterator.IterationResult.next(this.iterator.next());
        }
    }
}

