/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.stax2.xppimpl;

import java.io.Reader;
import java.io.Writer;
import org.core4j.Enumerable;
import org.odata4j.core.Throwables;
import org.odata4j.stax2.Attribute2;
import org.odata4j.stax2.Characters2;
import org.odata4j.stax2.EndElement2;
import org.odata4j.stax2.Namespace2;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;
import org.odata4j.stax2.XMLEventWriter2;
import org.odata4j.stax2.XMLFactoryProvider2;
import org.odata4j.stax2.XMLInputFactory2;
import org.odata4j.stax2.XMLOutputFactory2;
import org.odata4j.stax2.XMLWriter2;
import org.odata4j.stax2.XMLWriterFactory2;
import org.odata4j.stax2.domimpl.ManualXMLWriter2;
import org.odata4j.stax2.util.InMemoryAttributes;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlPullXMLFactoryProvider2
extends XMLFactoryProvider2 {
    @Override
    public XMLInputFactory2 newXMLInputFactory2() {
        return new XmlPullXMLInputFactory2();
    }

    @Override
    public XMLOutputFactory2 newXMLOutputFactory2() {
        return new XmlPullXMLOutputFactory2();
    }

    @Override
    public XMLWriterFactory2 newXMLWriterFactory2() {
        return new XmlPullXMLWriterFactory2();
    }

    private static class XmlPullCharacters2
    implements Characters2 {
        private final XmlPullParser xpp;

        public XmlPullCharacters2(XmlPullParser xpp) {
            this.xpp = xpp;
        }

        @Override
        public String getData() {
            return this.xpp.getText();
        }
    }

    private static class XmlPullEndElement2
    implements EndElement2 {
        private final QName2 name;

        public XmlPullEndElement2(QName2 name) {
            this.name = name;
        }

        @Override
        public QName2 getName() {
            return this.name;
        }
    }

    private static class XmlPullStartElement2
    implements StartElement2 {
        private final XmlPullParser xpp;
        private final QName2 name;
        private InMemoryAttributes attributes;

        public XmlPullStartElement2(XmlPullParser xpp) {
            this.xpp = xpp;
            this.name = new QName2(xpp.getNamespace(), xpp.getName());
        }

        @Override
        public Attribute2 getAttributeByName(QName2 name) {
            this.ensureAttributesCached();
            return this.attributes.getAttributeByName(name);
        }

        @Override
        public Attribute2 getAttributeByName(String name) {
            this.ensureAttributesCached();
            return this.attributes.getAttributeByName(name);
        }

        @Override
        public QName2 getName() {
            return this.name;
        }

        private void ensureAttributesCached() {
            if (this.attributes != null) {
                return;
            }
            this.attributes = new InMemoryAttributes();
            for (int i = 0; i < this.xpp.getAttributeCount(); ++i) {
                String ns = this.xpp.getAttributeNamespace(i);
                this.attributes.put(ns == null || ns.length() == 0 ? null : ns, this.xpp.getAttributeName(i), this.xpp.getAttributePrefix(i), this.xpp.getAttributeValue(i));
            }
        }

        @Override
        public Enumerable<Attribute2> getAttributes() {
            this.ensureAttributesCached();
            return this.attributes.getAttributes();
        }

        @Override
        public Enumerable<Namespace2> getNamespaces() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class XmlPullXMLEvent2
    implements XMLEvent2 {
        private final XmlPullParser xpp;

        public XmlPullXMLEvent2(XmlPullParser xpp) {
            this.xpp = xpp;
        }

        public String toString() {
            return String.format("%s[%s]", XmlPullXMLEvent2.class.getSimpleName(), this.getEventTypeName());
        }

        private String getEventTypeName() {
            try {
                switch (this.xpp.getEventType()) {
                    case 0: {
                        return "START_DOCUMENT";
                    }
                    case 1: {
                        return "END_DOCUMENT";
                    }
                    case 2: {
                        return "START_TAG";
                    }
                    case 3: {
                        return "END_TAG";
                    }
                    case 4: {
                        return "TEXT";
                    }
                    case 5: {
                        return "CDSECT";
                    }
                    case 6: {
                        return "ENTITY_REF";
                    }
                    case 7: {
                        return "IGNORABLE_WHITESPACE";
                    }
                    case 8: {
                        return "PROCESSING_INSTRUCTION";
                    }
                    case 9: {
                        return "COMMENT";
                    }
                    case 10: {
                        return "DOCDECL";
                    }
                }
                return "UNKNOWN TYPE " + this.xpp.getEventType();
            }
            catch (XmlPullParserException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public EndElement2 asEndElement() {
            if (!this.isEndElement()) {
                return null;
            }
            return new XmlPullEndElement2(new QName2(this.xpp.getNamespace(), this.xpp.getName()));
        }

        @Override
        public StartElement2 asStartElement() {
            if (!this.isStartElement()) {
                return null;
            }
            return new XmlPullStartElement2(this.xpp);
        }

        @Override
        public Characters2 asCharacters() {
            if (!this.isCharacters()) {
                return null;
            }
            return new XmlPullCharacters2(this.xpp);
        }

        @Override
        public boolean isEndElement() {
            try {
                return this.xpp.getEventType() == 3;
            }
            catch (XmlPullParserException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public boolean isStartElement() {
            try {
                return this.xpp.getEventType() == 2;
            }
            catch (XmlPullParserException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public boolean isCharacters() {
            try {
                return this.xpp.getEventType() == 4;
            }
            catch (XmlPullParserException e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private static class XmlPullXMLEventReader2
    implements XMLEventReader2 {
        private final XmlPullParser xpp;
        private boolean peeked;
        private boolean hasNext;

        public XmlPullXMLEventReader2(XmlPullParser xpp) {
            this.xpp = xpp;
        }

        @Override
        public String getElementText() {
            try {
                if (this.xpp.getEventType() == 4) {
                    return this.xpp.getText();
                }
                this.peeked = false;
                return this.xpp.nextText();
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.peeked) {
                return this.hasNext;
            }
            int eventType = this.advance();
            this.peeked = true;
            this.hasNext = eventType != 1;
            return this.hasNext;
        }

        @Override
        public XMLEvent2 nextEvent() {
            if (this.peeked) {
                this.peeked = false;
            } else {
                this.advance();
            }
            return new XmlPullXMLEvent2(this.xpp);
        }

        private int advance() {
            try {
                return this.xpp.next();
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private static class XmlPullXMLInputFactory2
    implements XMLInputFactory2 {
        private XmlPullXMLInputFactory2() {
        }

        @Override
        public XMLEventReader2 createXMLEventReader(Reader reader) {
            try {
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XmlPullParser xpp = factory.newPullParser();
                xpp.setInput(reader);
                return new XmlPullXMLEventReader2(xpp);
            }
            catch (XmlPullParserException e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private static class XmlPullXMLEventWriter2
    implements XMLEventWriter2 {
        private final Writer writer;

        public XmlPullXMLEventWriter2(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void add(XMLEvent2 event) {
            throw new UnsupportedOperationException();
        }
    }

    private static class XmlPullXMLOutputFactory2
    implements XMLOutputFactory2 {
        private XmlPullXMLOutputFactory2() {
        }

        @Override
        public XMLEventWriter2 createXMLEventWriter(Writer writer) {
            return new XmlPullXMLEventWriter2(writer);
        }
    }

    private static class XmlPullXMLWriterFactory2
    implements XMLWriterFactory2 {
        private XmlPullXMLWriterFactory2() {
        }

        @Override
        public XMLWriter2 createXMLWriter(Writer writer) {
            return new ManualXMLWriter2(writer);
        }
    }
}

