/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.ConsumerCountRequest;
import org.odata4j.consumer.ConsumerCreateEntityRequest;
import org.odata4j.consumer.ConsumerCreateLinkRequest;
import org.odata4j.consumer.ConsumerDeleteEntityRequest;
import org.odata4j.consumer.ConsumerDeleteLinkRequest;
import org.odata4j.consumer.ConsumerEntityModificationRequest;
import org.odata4j.consumer.ConsumerFunctionCallRequest;
import org.odata4j.consumer.ConsumerGetEntityRequest;
import org.odata4j.consumer.ConsumerQueryEntitiesRequest;
import org.odata4j.consumer.ConsumerQueryLinksRequest;
import org.odata4j.consumer.ConsumerUpdateLinkRequest;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.core.EntitySetInfo;
import org.odata4j.core.OCountRequest;
import org.odata4j.core.OCreateRequest;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityDeleteRequest;
import org.odata4j.core.OEntityGetRequest;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OEntityRequest;
import org.odata4j.core.OFunctionRequest;
import org.odata4j.core.OModifyRequest;
import org.odata4j.core.OObject;
import org.odata4j.core.OQueryRequest;
import org.odata4j.core.ORelatedEntitiesLink;
import org.odata4j.core.ORelatedEntityLink;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.internal.EdmDataServicesDecorator;

public abstract class AbstractODataConsumer
implements ODataConsumer {
    private final String serviceRootUri;
    private EdmDataServices cachedMetadata;

    protected AbstractODataConsumer(String serviceRootUri) {
        if (!serviceRootUri.endsWith("/")) {
            serviceRootUri = serviceRootUri + "/";
        }
        this.serviceRootUri = serviceRootUri;
    }

    @Override
    public String getServiceRootUri() {
        return this.serviceRootUri;
    }

    @Override
    public Enumerable<EntitySetInfo> getEntitySets() throws ODataProducerException {
        ODataClientRequest request = ODataClientRequest.get(this.getServiceRootUri());
        return Enumerable.create(this.getClient().getCollections(request)).cast(EntitySetInfo.class);
    }

    @Override
    public EdmDataServices getMetadata() {
        if (this.cachedMetadata == null) {
            this.cachedMetadata = new CachedEdmDataServices();
        }
        return this.cachedMetadata;
    }

    @Override
    public OQueryRequest<OEntity> getEntities(ORelatedEntitiesLink link) {
        ParsedHref parsed = ParsedHref.parse(link.getHref());
        return this.getEntities(parsed.entitySetName).nav(parsed.entityKey, parsed.navProperty);
    }

    @Override
    public OQueryRequest<OEntity> getEntities(String entitySetHref) {
        return this.getEntities(OEntity.class, entitySetHref);
    }

    @Override
    public <T> OQueryRequest<T> getEntities(Class<T> entityType, String entitySetHref) {
        return new ConsumerQueryEntitiesRequest<T>(this.getClient(), entityType, this.getServiceRootUri(), this.getMetadata(), entitySetHref);
    }

    @Override
    public OEntityGetRequest<OEntity> getEntity(ORelatedEntityLink link) {
        ParsedHref parsed = ParsedHref.parse(link.getHref());
        return (OEntityGetRequest)this.getEntity(parsed.entitySetName, parsed.entityKey).nav(parsed.navProperty);
    }

    @Override
    public OEntityGetRequest<OEntity> getEntity(String entitySetName, Object keyValue) {
        return this.getEntity(entitySetName, OEntityKey.create(keyValue));
    }

    @Override
    public OEntityGetRequest<OEntity> getEntity(OEntity entity) {
        return this.getEntity(entity.getEntitySet().getName(), entity.getEntityKey());
    }

    @Override
    public OEntityGetRequest<OEntity> getEntity(String entitySetName, OEntityKey key) {
        return this.getEntity(OEntity.class, entitySetName, key);
    }

    @Override
    public <T> OEntityGetRequest<T> getEntity(Class<T> entityType, String entitySetName, Object keyValue) {
        return this.getEntity(entityType, entitySetName, OEntityKey.create(keyValue));
    }

    @Override
    public <T> OEntityGetRequest<T> getEntity(Class<T> entityType, String entitySetName, OEntityKey key) {
        return new ConsumerGetEntityRequest<T>(this.getClient(), entityType, this.getServiceRootUri(), this.getMetadata(), entitySetName, OEntityKey.create(key));
    }

    @Override
    public OQueryRequest<OEntityId> getLinks(OEntityId sourceEntity, String targetNavProp) {
        return new ConsumerQueryLinksRequest(this.getClient(), this.getServiceRootUri(), this.getMetadata(), sourceEntity, targetNavProp);
    }

    @Override
    public OEntityRequest<Void> createLink(OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        return new ConsumerCreateLinkRequest(this.getClient(), this.getServiceRootUri(), this.getMetadata(), sourceEntity, targetNavProp, targetEntity);
    }

    @Override
    public OEntityRequest<Void> deleteLink(OEntityId sourceEntity, String targetNavProp, Object ... targetKeyValues) {
        return new ConsumerDeleteLinkRequest(this.getClient(), this.getServiceRootUri(), this.getMetadata(), sourceEntity, targetNavProp, targetKeyValues);
    }

    @Override
    public OEntityRequest<Void> updateLink(OEntityId sourceEntity, OEntityId newTargetEntity, String targetNavProp, Object ... oldTargetKeyValues) {
        return new ConsumerUpdateLinkRequest(this.getClient(), this.getServiceRootUri(), this.getMetadata(), sourceEntity, newTargetEntity, targetNavProp, oldTargetKeyValues);
    }

    @Override
    public OCreateRequest<OEntity> createEntity(String entitySetName) {
        return new ConsumerCreateEntityRequest<OEntity>(this.getClient(), this.getServiceRootUri(), this.getMetadata(), entitySetName);
    }

    @Override
    public OModifyRequest<OEntity> updateEntity(OEntity entity) {
        return new ConsumerEntityModificationRequest<OEntity>(entity, this.getClient(), this.getServiceRootUri(), this.getMetadata(), entity.getEntitySet().getName(), entity.getEntityKey(), entity.getEntityTag());
    }

    @Override
    public OModifyRequest<OEntity> mergeEntity(OEntity entity) {
        return this.mergeEntity(entity.getEntitySet().getName(), entity.getEntityKey(), entity.getEntityTag());
    }

    @Override
    public OModifyRequest<OEntity> mergeEntity(String entitySetName, Object keyValue) {
        return this.mergeEntity(entitySetName, OEntityKey.create(keyValue));
    }

    @Override
    public OModifyRequest<OEntity> mergeEntity(String entitySetName, OEntityKey key) {
        return this.mergeEntity(entitySetName, key, null);
    }

    public OModifyRequest<OEntity> mergeEntity(String entitySetName, OEntityKey key, String entityTag) {
        return new ConsumerEntityModificationRequest<Object>(null, this.getClient(), this.getServiceRootUri(), this.getMetadata(), entitySetName, key, entityTag);
    }

    @Override
    public OEntityDeleteRequest deleteEntity(OEntity entity) {
        return new ConsumerDeleteEntityRequest(this.getClient(), this.getServiceRootUri(), this.getMetadata(), entity.getEntitySetName(), entity.getEntityKey(), entity.getEntityTag());
    }

    @Override
    public OEntityDeleteRequest deleteEntity(String entitySetName, Object keyValue) {
        return this.deleteEntity(entitySetName, OEntityKey.create(keyValue));
    }

    @Override
    public OEntityDeleteRequest deleteEntity(String entitySetName, OEntityKey key) {
        return new ConsumerDeleteEntityRequest(this.getClient(), this.getServiceRootUri(), this.getMetadata(), entitySetName, key, null);
    }

    @Override
    public OFunctionRequest<OObject> callFunction(String functionName) {
        return new ConsumerFunctionCallRequest<OObject>(this.getClient(), this.getServiceRootUri(), this.getMetadata(), functionName);
    }

    @Override
    public OCountRequest getEntitiesCount(String entitySetName) {
        return new ConsumerCountRequest(this.getClient(), this.getServiceRootUri()).entitySetName(entitySetName);
    }

    protected abstract ODataClient getClient();

    private class CachedEdmDataServices
    extends EdmDataServicesDecorator {
        private EdmDataServices delegate;

        private CachedEdmDataServices() {
        }

        @Override
        protected EdmDataServices getDelegate() {
            if (this.delegate == null) {
                this.refreshDelegate();
            }
            return this.delegate;
        }

        private void refreshDelegate() {
            ODataClientRequest request = ODataClientRequest.get(AbstractODataConsumer.this.getServiceRootUri() + "$metadata");
            try {
                this.delegate = AbstractODataConsumer.this.getClient().getMetadata(request);
            }
            catch (ODataProducerException e) {
                this.delegate = EdmDataServices.EMPTY;
            }
        }

        @Override
        public EdmEntitySet findEdmEntitySet(String entitySetName) {
            EdmEntitySet rt = super.findEdmEntitySet(entitySetName);
            if (rt == null && this.delegate != EdmDataServices.EMPTY) {
                this.refreshDelegate();
                rt = super.findEdmEntitySet(entitySetName);
            }
            return rt;
        }
    }

    private static class ParsedHref {
        public String entitySetName;
        public OEntityKey entityKey;
        public String navProperty;

        private ParsedHref() {
        }

        public static ParsedHref parse(String href) {
            int slashIndex = href.indexOf(47);
            String head = href.substring(0, slashIndex);
            String navProperty = href.substring(slashIndex + 1);
            int pIndex = head.indexOf(40);
            String entitySetName = head.substring(0, pIndex);
            String keyString = head.substring(pIndex + 1, head.length() - 1);
            ParsedHref rt = new ParsedHref();
            rt.entitySetName = entitySetName;
            rt.entityKey = OEntityKey.parse(keyString);
            rt.navProperty = navProperty;
            return rt;
        }
    }
}

