/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.OCountRequest;
import org.odata4j.exceptions.ODataProducerException;

public class ConsumerCountRequest
implements OCountRequest {
    private ODataClient client;
    private String baseUri;
    private String entitySetName;
    private Integer top;

    public ConsumerCountRequest(ODataClient client, String serviceRootUri) {
        this.client = client;
        this.baseUri = serviceRootUri;
    }

    @Override
    public ConsumerCountRequest entitySetName(String entitySetName) {
        this.entitySetName = entitySetName;
        return this;
    }

    @Override
    public ConsumerCountRequest top(int top) {
        this.top = top;
        return this;
    }

    @Override
    public int execute() throws ODataProducerException {
        String uri = this.baseUri;
        if (this.entitySetName != null) {
            uri = uri + this.entitySetName + "/";
        }
        uri = uri + "$count";
        if (this.top != null) {
            uri = uri + "?$top=" + this.top;
        }
        ODataClientRequest request = ODataClientRequest.get(uri);
        String valueString = this.client.requestBody(this.client.getFormatType(), request);
        return Integer.parseInt(valueString);
    }
}

