/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.consumer.behaviors.OClientBehaviors;
import org.odata4j.core.Throwables;
import org.odata4j.format.FormatType;

public class ODataConsumers {
    public static final String CONSUMERIMPL_PROPERTY = "odata4j.consumerimpl";
    public static final String JERSEY_CONSUMERIMPL = "jersey";
    public static final String CXF_CONSUMERIMPL = "cxf";
    public static final String JERSEY_CONSUMER_CLASSNAME = "org.odata4j.examples.jersey.consumer.ODataJerseyConsumer";
    public static final String CXF_CONSUMER_CLASSNAME = "org.odata4j.examples.cxf.consumer.ODataCxfConsumer";
    private static ClassLoader classLoader;

    public static ODataConsumer.Builder newBuilder(String serviceRootUri) {
        return new Builder(serviceRootUri);
    }

    public static ODataConsumer create(String serviceRootUri) {
        return ODataConsumers.newBuilder(serviceRootUri).build();
    }

    public static ODataConsumer azureTables(String account, String key) {
        String url = "http://" + account + ".table.core.windows.net/";
        return ODataConsumers.newBuilder(url).setClientBehaviors(OClientBehaviors.azureTables(account, key)).build();
    }

    public static ODataConsumer dallas(String serviceRootUri, String accountKey, String uniqueUserId) {
        OClientBehavior basicAuth = OClientBehaviors.basicAuth("accountKey", accountKey);
        return ODataConsumers.newBuilder(serviceRootUri).setClientBehaviors(basicAuth).build();
    }

    public static ODataConsumer dataMarket(String serviceRootUri, String accountKey) {
        OClientBehavior basicAuth = OClientBehaviors.basicAuth("accountKey", accountKey);
        return ODataConsumers.newBuilder(serviceRootUri).setClientBehaviors(basicAuth).build();
    }

    public static class Builder
    implements ODataConsumer.Builder {
        private ODataConsumer.Builder consumerBuilder;

        private Builder(String serviceRootUri) {
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                String[] classNames = this.getClassNames();
                Class<?> consumerClass = this.getConsumerClass(classNames);
                Method newBuilderMethod = consumerClass.getDeclaredMethod("newBuilder", String.class);
                this.consumerBuilder = (ODataConsumer.Builder)newBuilderMethod.invoke(consumerClass, serviceRootUri);
            }
            catch (Exception e) {
                Throwables.propagate(e);
            }
        }

        private String[] getClassNames() {
            String impl = System.getProperty(ODataConsumers.CONSUMERIMPL_PROPERTY);
            if (ODataConsumers.JERSEY_CONSUMERIMPL.equalsIgnoreCase(impl)) {
                return new String[]{ODataConsumers.JERSEY_CONSUMER_CLASSNAME};
            }
            if (ODataConsumers.CXF_CONSUMERIMPL.equalsIgnoreCase(impl)) {
                return new String[]{ODataConsumers.CXF_CONSUMER_CLASSNAME};
            }
            if (impl != null && impl.length() > 0) {
                return new String[]{impl};
            }
            return new String[]{ODataConsumers.JERSEY_CONSUMER_CLASSNAME, ODataConsumers.CXF_CONSUMER_CLASSNAME};
        }

        private Class<?> getConsumerClass(String[] classNames) throws ClassNotFoundException {
            for (String className : classNames) {
                try {
                    Class<?> consumerClass = Class.forName(className, true, classLoader);
                    if (consumerClass == null) continue;
                    return consumerClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException("Unable to load ODataConsumer implementation. The following class(es) could not be found: " + Arrays.toString(classNames));
        }

        @Override
        public ODataConsumer.Builder setFormatType(FormatType formatType) {
            return this.consumerBuilder.setFormatType(formatType);
        }

        @Override
        public ODataConsumer.Builder setClientBehaviors(OClientBehavior ... clientBehaviors) {
            return this.consumerBuilder.setClientBehaviors(clientBehaviors);
        }

        @Override
        public ODataConsumer build() {
            return this.consumerBuilder.build();
        }
    }
}

