/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

package org.teiid.metadata;

import static org.junit.Assert.*;

import org.junit.Test;

public class TestTable {

	@Test public void testCardinality() {
		Table t = new Table();
		assertEquals(-1, t.getCardinalityAsFloat(), 0);
		t.setCardinality(1000);
		assertEquals(1000, t.getCardinalityAsFloat(), 0);
		t.setCardinality(100000111000111100l);
		assertEquals(100000111000111100l/t.getCardinalityAsFloat(), 1, .01);
	}
	
	@Test public void testColumnPrecisionScale() {
	    Column c = new Column();
	    Datatype datatype = new Datatype();
	    datatype.setName("bigdecimal");
        c.setDatatype(datatype);
	    c.setPrecision(0);
	    c.setScale(2);
	    assertEquals(2, c.getScale());
	    assertEquals(BaseColumn.DEFAULT_PRECISION, c.getPrecision());
    }
	
}
