/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

package org.teiid.resource.adapter.google.gdata;

import java.io.IOException;
import java.util.List;

import org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Worksheet;

import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.ServiceException;

/**
 * Creates metadata by using GData API.
 * 
 * We retrieve worksheet names and possibly headers
 * @author fnguyen
 *
 */
public class SpreadsheetMetadataExtractor {
	private GDataClientLoginAPI gdataAPI = null;
	private GoogleDataProtocolAPI visualizationAPI= null;

	public GoogleDataProtocolAPI getVisualizationAPI() {
		return visualizationAPI;
	}

	public void setVisualizationAPI(GoogleDataProtocolAPI visualizationAPI) {
		this.visualizationAPI = visualizationAPI;
	}

	public GDataClientLoginAPI getGdataAPI() {
		return gdataAPI;
	}

	public void setGdataAPI(GDataClientLoginAPI gdataAPI) {
		this.gdataAPI = gdataAPI;
	}
	
	
	public SpreadsheetInfo extractMetadata(String spreadsheetName, boolean isKey){
	    SpreadsheetEntry sentry = gdataAPI.getSpreadsheetEntry(spreadsheetName, isKey);
		SpreadsheetInfo metadata = new SpreadsheetInfo(spreadsheetName);
		metadata.setSpreadsheetKey(sentry.getKey());
		try {
			for (WorksheetEntry wentry : sentry.getWorksheets()) {
				String title = wentry.getTitle().getPlainText();
				Worksheet worksheet = metadata.createWorksheet(title);
				worksheet.setId(wentry.getId().substring(wentry.getId().lastIndexOf('/')+1));
				List<Column> cols = visualizationAPI.getMetadata(sentry.getKey(), title);
				if(!cols.isEmpty()){
					if(cols.get(0).getLabel()!=null){
						worksheet.setHeaderEnabled(true);
					}
				}
				for(Column c: cols){
					worksheet.addColumn(c.getLabel()!=null ? c.getLabel(): c.getAlphaName(), c);
				}
			}
		} catch (IOException ex) {
			throw new SpreadsheetOperationException(
					SpreadsheetManagedConnectionFactory.UTIL.gs("metadata_error"), ex); //$NON-NLS-1$
		} catch (ServiceException ex) {
			throw new SpreadsheetOperationException(
					SpreadsheetManagedConnectionFactory.UTIL.gs("metadata_error"), ex); //$NON-NLS-1$
		}
		return metadata;
	}

}

