/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.util.ArrayList;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.security.Credentials;
import org.teiid.services.TeiidLoginContext;

public class TestMembershipServiceImpl
extends TestCase {
    public void testBaseUsername() throws Exception {
        TestMembershipServiceImpl.assertEquals((String)"foo@bar.com", (String)TeiidLoginContext.getBaseUsername((String)"foo\\@bar.com@foo"));
        TestMembershipServiceImpl.assertEquals((String)"foo", (String)TeiidLoginContext.getDomainName((String)"me\\@bar.com@foo"));
        TestMembershipServiceImpl.assertEquals(null, (String)TeiidLoginContext.getDomainName((String)"@"));
        TestMembershipServiceImpl.assertEquals((String)"@", (String)TeiidLoginContext.getBaseUsername((String)"@"));
    }

    private TeiidLoginContext createMembershipService() throws Exception {
        TeiidLoginContext membershipService = new TeiidLoginContext(){

            public LoginContext createLoginContext(String domain, CallbackHandler handler) throws LoginException {
                LoginContext context = (LoginContext)Mockito.mock(LoginContext.class);
                return context;
            }
        };
        return membershipService;
    }

    public void testAuthenticate() throws Exception {
        TeiidLoginContext ms = this.createMembershipService();
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("testFile");
        ms.authenticateUser("user1", new Credentials("pass1".toCharArray()), null, domains);
        ((LoginContext)Mockito.verify((Object)ms.getLoginContext())).login();
        TestMembershipServiceImpl.assertEquals((String)"user1@testFile", (String)ms.getUserName());
    }
}

