/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.VDBImport;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.CombinedClassLoader;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.VDBResources;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.vdb.runtime.VDBKey;

public class CompositeVDB {
    private VDBMetaData vdb;
    private MetadataStore store;
    private LinkedHashMap<String, VDBResources.Resource> visibilityMap;
    private UDFMetaData udf;
    LinkedHashMap<VDBKey, CompositeVDB> children;
    private MetadataStore[] additionalStores;
    private ConnectorManagerRepository cmr;
    private FunctionTree systemFunctions;
    private boolean metadataloadFinished = false;
    private VDBMetaData mergedVDB;
    private VDBMetaData originalVDB;
    private Collection<Future<?>> tasks = Collections.synchronizedSet(new HashSet());

    public CompositeVDB(VDBMetaData vdb, MetadataStore metadataStore, LinkedHashMap<String, VDBResources.Resource> visibilityMap, UDFMetaData udf, FunctionTree systemFunctions, ConnectorManagerRepository cmr, VDBRepository vdbRepository, MetadataStore ... additionalStores) throws VirtualDatabaseException {
        this.vdb = vdb;
        this.store = metadataStore;
        this.visibilityMap = visibilityMap;
        this.udf = udf;
        this.systemFunctions = systemFunctions;
        this.cmr = cmr;
        this.additionalStores = additionalStores;
        this.mergedVDB = vdb;
        this.originalVDB = vdb;
        this.buildCompositeState(vdbRepository);
    }

    private static TransformationMetadata buildTransformationMetaData(VDBMetaData vdb, LinkedHashMap<String, VDBResources.Resource> visibilityMap, MetadataStore store, UDFMetaData udf, FunctionTree systemFunctions, MetadataStore[] additionalStores) {
        ArrayList<FunctionTree> udfs = new ArrayList<FunctionTree>();
        if (udf != null) {
            for (Map.Entry<String, UDFSource> entry : udf.getFunctions().entrySet()) {
                udfs.add(new FunctionTree(entry.getKey(), (FunctionMetadataSource)entry.getValue(), true));
            }
        }
        CompositeMetadataStore compositeStore = new CompositeMetadataStore(store);
        for (MetadataStore s : additionalStores) {
            compositeStore.merge(s);
            for (Schema schema : s.getSchemas().values()) {
                FunctionTree ft;
                if (!schema.getFunctions().isEmpty()) {
                    UDFSource source = new UDFSource(schema.getFunctions().values());
                    if (udf != null) {
                        source.setClassLoader(udf.getClassLoader());
                    }
                    udfs.add(new FunctionTree(schema.getName(), (FunctionMetadataSource)source, true));
                }
                if (schema.getProcedures().isEmpty() || (ft = FunctionTree.getFunctionProcedures((Schema)schema)) == null) continue;
                udfs.add(ft);
            }
        }
        TransformationMetadata transformationMetadata = new TransformationMetadata(vdb, compositeStore, visibilityMap, systemFunctions, udfs);
        transformationMetadata.setUseOutputNames(false);
        return transformationMetadata;
    }

    public VDBMetaData getVDB() {
        return this.mergedVDB;
    }

    private void buildCompositeState(VDBRepository vdbRepository) throws VirtualDatabaseException {
        if (this.vdb.getVDBImports().isEmpty()) {
            this.vdb.addAttchment(ConnectorManagerRepository.class, (Object)this.cmr);
            return;
        }
        VDBMetaData newMergedVDB = this.vdb.clone();
        ConnectorManagerRepository mergedRepo = this.cmr;
        if (!this.cmr.isShared()) {
            mergedRepo = new ConnectorManagerRepository();
            mergedRepo.getConnectorManagers().putAll(this.cmr.getConnectorManagers());
        }
        newMergedVDB.addAttchment(ConnectorManagerRepository.class, (Object)mergedRepo);
        ClassLoader[] toSearch = new ClassLoader[this.vdb.getVDBImports().size() + 1];
        toSearch[0] = (ClassLoader)this.vdb.getAttachment(ClassLoader.class);
        this.children = new LinkedHashMap();
        newMergedVDB.setImportedModels(new TreeSet(String.CASE_INSENSITIVE_ORDER));
        int i = 1;
        for (VDBImport vdbImport : this.vdb.getVDBImports()) {
            CompositeVDB importedVDB = vdbRepository.getCompositeVDB(new VDBKey(vdbImport.getName(), vdbImport.getVersion()));
            if (importedVDB == null) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40083, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40083, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion()}));
            }
            VDBMetaData childVDB = importedVDB.getVDB();
            newMergedVDB.getVisibilityOverrides().putAll(childVDB.getVisibilityOverrides());
            toSearch[i++] = (ClassLoader)childVDB.getAttachment(ClassLoader.class);
            this.children.put(new VDBKey(childVDB.getName(), childVDB.getVersion()), importedVDB);
            if (vdbImport.isImportDataPolicies()) {
                for (DataPolicy dp : importedVDB.getVDB().getDataPolicies()) {
                    DataPolicyMetadata role = (DataPolicyMetadata)dp;
                    if (newMergedVDB.addDataPolicy(role) != null) {
                        throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40084, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40084, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion(), role.getName()}));
                    }
                    if (!role.isGrantAll()) continue;
                    role.setSchemas(childVDB.getModelMetaDatas().keySet());
                }
            }
            for (ModelMetaData m : childVDB.getModelMetaDatas().values()) {
                if (newMergedVDB.addModel(m) != null) {
                    throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40085, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40085, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion(), m.getName()}));
                }
                newMergedVDB.getImportedModels().add(m.getName());
                String visibilityOverride = newMergedVDB.getPropertyValue(m.getName() + ".visible");
                if (visibilityOverride == null) continue;
                boolean visible = Boolean.valueOf(visibilityOverride);
                newMergedVDB.setVisibilityOverride(m.getName(), visible);
            }
            ConnectorManagerRepository childCmr = (ConnectorManagerRepository)childVDB.getAttachment(ConnectorManagerRepository.class);
            if (childCmr == null) {
                throw new AssertionError((Object)"childVdb had not connector manager repository");
            }
            if (this.cmr.isShared()) continue;
            for (Map.Entry entry : childCmr.getConnectorManagers().entrySet()) {
                if (mergedRepo.getConnectorManagers().put(entry.getKey(), entry.getValue()) == null) continue;
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40086, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40086, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion(), entry.getKey()}));
            }
        }
        if (toSearch[0] != null) {
            CombinedClassLoader ccl = new CombinedClassLoader(toSearch[0].getParent(), toSearch);
            this.mergedVDB.addAttchment(ClassLoader.class, (Object)ccl);
        }
        this.mergedVDB = newMergedVDB;
    }

    private UDFMetaData getUDF() {
        Object funcs;
        UDFMetaData mergedUDF = new UDFMetaData();
        if (this.udf != null) {
            mergedUDF.addFunctions(this.udf);
        }
        for (Schema schema : this.store.getSchemas().values()) {
            funcs = schema.getFunctions().values();
            mergedUDF.addFunctions(schema.getName(), (Collection<FunctionMethod>)funcs);
        }
        if (this.cmr != null) {
            for (ConnectorManager cm : this.cmr.getConnectorManagers().values()) {
                funcs = cm.getPushDownFunctions();
                mergedUDF.addFunctions("SYS", (Collection<FunctionMethod>)funcs);
            }
        }
        if (this.children != null) {
            for (CompositeVDB child : this.children.values()) {
                funcs = child.getUDF();
                if (funcs == null) continue;
                mergedUDF.addFunctions((UDFMetaData)funcs);
            }
        }
        return mergedUDF;
    }

    private LinkedHashMap<String, VDBResources.Resource> getVisibilityMap() {
        if (this.children == null || this.children.isEmpty()) {
            return this.visibilityMap;
        }
        LinkedHashMap<String, VDBResources.Resource> mergedvisibilityMap = new LinkedHashMap<String, VDBResources.Resource>();
        for (CompositeVDB child : this.children.values()) {
            LinkedHashMap<String, VDBResources.Resource> vm = child.getVisibilityMap();
            if (vm == null) continue;
            mergedvisibilityMap.putAll(vm);
        }
        if (this.visibilityMap != null) {
            mergedvisibilityMap.putAll(this.visibilityMap);
        }
        return mergedvisibilityMap;
    }

    private MetadataStore getMetadataStore() {
        return this.store;
    }

    VDBMetaData getOriginalVDB() {
        return this.originalVDB;
    }

    public void metadataLoadFinished() {
        TransformationMetadata metadata;
        if (this.metadataloadFinished) {
            return;
        }
        this.metadataloadFinished = true;
        MetadataStore mergedStore = this.getMetadataStore();
        List schemas = mergedStore.getSchemaList();
        schemas.clear();
        for (ModelMetaData model : this.vdb.getModelMetaDatas().values()) {
            Schema s = mergedStore.getSchema(model.getName());
            if (s != null) {
                schemas.add(s);
                continue;
            }
            mergedStore.getSchemas().remove(model.getName());
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (CompositeVDB child : this.children.values()) {
                MetadataStore childStore = child.getMetadataStore();
                if (childStore == null) continue;
                mergedStore.merge(childStore);
            }
        }
        TransformationMetadata qmi = metadata = CompositeVDB.buildTransformationMetaData(this.mergedVDB, this.getVisibilityMap(), mergedStore, this.getUDF(), this.systemFunctions, this.additionalStores);
        Map multiSourceModels = MultiSourceMetadataWrapper.getMultiSourceModels((VDBMetaData)this.mergedVDB);
        if (multiSourceModels != null && !multiSourceModels.isEmpty()) {
            qmi = new MultiSourceMetadataWrapper((QueryMetadataInterface)metadata, multiSourceModels);
        }
        this.mergedVDB.addAttchment(QueryMetadataInterface.class, (Object)qmi);
        this.mergedVDB.addAttchment(TransformationMetadata.class, (Object)metadata);
        this.mergedVDB.addAttchment(MetadataStore.class, (Object)mergedStore);
    }

    LinkedHashMap<VDBKey, CompositeVDB> getChildren() {
        return this.children;
    }

    public Collection<Future<?>> clearTasks() {
        ArrayList copy = new ArrayList(this.tasks);
        this.tasks.clear();
        return copy;
    }

    public void removeTask(Future<?> future) {
        this.tasks.remove(future);
    }

    public void addTask(Future<?> future) {
        this.tasks.add(future);
    }
}

