/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.List;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.runtime.RuntimePlugin;

public abstract class RuntimeVDB {
    private VDBMetaData vdb;
    private VDBModificationListener listener;
    private volatile boolean restartInProgress = false;

    public RuntimeVDB(VDBMetaData vdb, VDBModificationListener listener) {
        this.vdb = vdb;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            List previous = policy.getMappedRoleNames();
            policy.addMappedRoleName(mappedRole);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setMappedRoleNames(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            List previous = policy.getMappedRoleNames();
            policy.removeMappedRoleName(mappedRole);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setMappedRoleNames(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnyAuthenticated(String policyName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            boolean previous = policy.isAnyAuthenticated();
            policy.setAnyAuthenticated(true);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setAnyAuthenticated(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnyAuthenticated(String policyName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            boolean previous = policy.isAnyAuthenticated();
            policy.setAnyAuthenticated(false);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setAnyAuthenticated(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConnectionType(VDB.ConnectionType type) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            VDB.ConnectionType previous = this.vdb.getConnectionType();
            this.vdb.setConnectionType(type);
            try {
                this.listener.connectionTypeChanged();
            }
            catch (AdminProcessingException e) {
                this.vdb.setConnectionType(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplaceResult updateSource(String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            ReplaceResult replaceResult;
            block13: {
                ConnectorManagerRepository cmr = (ConnectorManagerRepository)this.vdb.getAttachment(ConnectorManagerRepository.class);
                ConnectorManager cr = cmr.getConnectorManager(sourceName);
                if (cr == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, new Object[]{sourceName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                String previousTranslatorName = cr.getTranslatorName();
                String previousDsName = cr.getConnectionName();
                for (ModelMetaData m : this.vdb.getModelMetaDatas().values()) {
                    SourceMappingMetadata mapping = m.getSourceMapping(sourceName);
                    if (mapping == null) continue;
                    mapping.setTranslatorName(translatorName);
                    mapping.setConnectionJndiName(dsName);
                }
                boolean success = false;
                try {
                    boolean replaced;
                    this.listener.dataSourceChanged(null, sourceName, translatorName, dsName);
                    ReplaceResult rr = new ReplaceResult();
                    if (dsName != null) {
                        boolean bl = rr.isNew = !this.dsExists(dsName, cmr);
                    }
                    if ((replaced = this.getVDBStatusChecker().dataSourceReplaced(this.vdb.getName(), this.vdb.getVersion(), null, sourceName, translatorName, dsName)) && previousDsName != null && !this.dsExists(previousDsName, cmr)) {
                        rr.removedDs = previousDsName;
                    }
                    success = true;
                    replaceResult = rr;
                    if (success) break block13;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        for (ModelMetaData m : this.vdb.getModelMetaDatas().values()) {
                            SourceMappingMetadata mapping = m.getSourceMapping(sourceName);
                            if (mapping == null) continue;
                            mapping.setTranslatorName(previousTranslatorName);
                            mapping.setConnectionJndiName(previousDsName);
                        }
                    }
                    throw throwable;
                }
                for (ModelMetaData m : this.vdb.getModelMetaDatas().values()) {
                    SourceMappingMetadata mapping = m.getSourceMapping(sourceName);
                    if (mapping == null) continue;
                    mapping.setTranslatorName(previousTranslatorName);
                    mapping.setConnectionJndiName(previousDsName);
                }
            }
            return replaceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplaceResult addSource(String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            ReplaceResult replaceResult;
            block11: {
                ModelMetaData model = this.vdb.getModel(modelName);
                if (model == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                if (!model.isSupportsMultiSourceBindings()) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40108, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40108, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                SourceMappingMetadata source = model.getSourceMapping(sourceName);
                if (source != null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40107, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40107, new Object[]{sourceName, modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                boolean success = false;
                try {
                    SourceMappingMetadata mapping = new SourceMappingMetadata(sourceName, translatorName, dsName);
                    boolean updated = this.getVDBStatusChecker().updateSource(this.vdb.getName(), this.vdb.getVersion(), mapping, false);
                    model.addSourceMapping(mapping);
                    this.listener.dataSourceChanged(modelName, sourceName, translatorName, dsName);
                    ReplaceResult rr = new ReplaceResult();
                    if (dsName != null && updated) {
                        ConnectorManagerRepository cmr = (ConnectorManagerRepository)this.vdb.getAttachment(ConnectorManagerRepository.class);
                        rr.isNew = !this.dsExists(dsName, cmr);
                    }
                    success = true;
                    replaceResult = rr;
                    if (success) break block11;
                    model.getSources().remove(sourceName);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        model.getSources().remove(sourceName);
                    }
                    throw throwable;
                }
            }
            return replaceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplaceResult removeSource(String modelName, String sourceName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            ReplaceResult replaceResult;
            block15: {
                ModelMetaData model = this.vdb.getModel(modelName);
                if (model == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                if (!model.isSupportsMultiSourceBindings()) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40108, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40108, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                if (model.getSources().size() == 1) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40109, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40109, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                SourceMappingMetadata source = (SourceMappingMetadata)model.getSources().remove(sourceName);
                if (source == null) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, new Object[]{sourceName, modelName, this.vdb.getName(), this.vdb.getVersion()}));
                }
                if (model.getSources().size() == 1) {
                    model.setSupportsMultiSourceBindings(true);
                }
                String previousDsName = source.getConnectionJndiName();
                boolean success = false;
                try {
                    this.listener.dataSourceChanged(modelName, sourceName, null, null);
                    ConnectorManagerRepository cmr = (ConnectorManagerRepository)this.vdb.getAttachment(ConnectorManagerRepository.class);
                    boolean exists = false;
                    for (ModelMetaData m : this.vdb.getModelMetaDatas().values()) {
                        if (m == model || m.getSourceMapping(sourceName) == null) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        cmr.removeConnectorManager(sourceName);
                    }
                    ReplaceResult rr = new ReplaceResult();
                    if (!this.dsExists(previousDsName, cmr)) {
                        rr.removedDs = previousDsName;
                    }
                    success = true;
                    replaceResult = rr;
                    if (success) break block15;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        model.addSourceMapping(source);
                    }
                    throw throwable;
                }
                model.addSourceMapping(source);
            }
            return replaceResult;
        }
    }

    private boolean dsExists(String dsName, ConnectorManagerRepository cmr) {
        String baseDsName = VDBStatusChecker.stripContext(dsName);
        for (ConnectorManager cm : cmr.getConnectorManagers().values()) {
            if (!baseDsName.equals(VDBStatusChecker.stripContext(cm.getConnectionName()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(List<String> modelNames) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            this.restartInProgress = true;
            this.listener.onRestart(modelNames);
        }
    }

    private DataPolicyMetadata getPolicy(String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = (DataPolicyMetadata)this.vdb.getDataPolicyMap().get(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40092, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40092, new Object[]{policyName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        return policy;
    }

    public boolean isRestartInProgress() {
        return this.restartInProgress;
    }

    public VDBMetaData getVdb() {
        return this.vdb;
    }

    protected abstract VDBStatusChecker getVDBStatusChecker();

    public static interface VDBModificationListener {
        public void dataRoleChanged(String var1) throws AdminProcessingException;

        public void connectionTypeChanged() throws AdminProcessingException;

        public void dataSourceChanged(String var1, String var2, String var3, String var4) throws AdminProcessingException;

        public void onRestart(List<String> var1) throws AdminProcessingException;
    }

    public static class ReplaceResult {
        public boolean isNew;
        public String removedDs;
    }
}

