/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.postgresql.Driver;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.transport.WireProtocol;

public class TestEmbeddedServer {
    EmbeddedServer es;
    public static boolean started;
    public static boolean isES1started;
    public static boolean isES2started;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        this.es.stop();
    }

    @Test
    public void testDeploy() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("y", (ExecutionFactory)new ExecutionFactory<AtomicInteger, Object>(){

            public Object getConnection(AtomicInteger factory) throws TranslatorException {
                return factory.incrementAndGet();
            }

            public void closeConnection(Object connection, AtomicInteger factory) {
            }

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Assert.assertEquals((Object)conn, (Object)1);
                Table t = metadataFactory.addTable("my-table");
                t.setSupportsUpdate(true);
                Column c = metadataFactory.addColumn("my-column", "string", (ColumnSet)t);
                c.setUpdatable(true);
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                ResultSetExecution rse = new ResultSetExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        return null;
                    }
                };
                return rse;
            }

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                UpdateExecution ue = new UpdateExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{2};
                    }
                };
                return ue;
            }
        });
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        this.es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", "z");
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd, mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from \"my-view\"");
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"my-column", (Object)rs.getMetaData().getColumnLabel(1));
        s.execute("update \"my-view\" set \"my-column\" = 'a'");
        Assert.assertEquals((long)2L, (long)s.getUpdateCount());
        this.es.deployVDB("empty", new ModelMetaData[0]);
        c = this.es.getDriver().connect("jdbc:teiid:empty", null);
        s = c.createStatement();
        s.execute("select * from tables");
        Assert.assertNotNull((Object)this.es.getSchemaDdl("empty", "SYS"));
        Assert.assertNull((Object)this.es.getSchemaDdl("empty", "xxx"));
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testInvalidName() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt.1");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" as select 1");
        this.es.deployVDB("x", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testDeployZip() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        File f = UnitTestUtil.getTestScratchFile((String)"some.vdb");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
        out.putNextEntry(new ZipEntry("v1.ddl"));
        out.write("CREATE VIEW helloworld as SELECT 'HELLO WORLD';".getBytes("UTF-8"));
        out.putNextEntry(new ZipEntry("META-INF/vdb.xml"));
        out.write("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL-FILE\">/v1.ddl</metadata></model></vdb>".getBytes("UTF-8"));
        out.close();
        this.es.deployVDBZip(f.toURI().toURL());
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:test", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
    }

    @Test
    public void testDeployDesignerZip() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDBZip(UnitTestUtil.getTestDataFile((String)"matviews.vdb").toURI().toURL());
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:matviews", null).createStatement().executeQuery("select count(*) from tables where schemaname='test'");
        rs.next();
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
    }

    @Test
    public void testXMLDeploy() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:test", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
    }

    @Test
    public void testXMLDeployWithVDBImport() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"importer\" version=\"1\"><import-vdb name=\"test\" version=\"1\"/></vdb>".getBytes()));
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:importer", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"importer1\" version=\"1\"><import-vdb name=\"importer\" version=\"1\"/></vdb>".getBytes()));
        rs = this.es.getDriver().connect("jdbc:teiid:importer1", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteJDBCTrasport() throws Exception {
        SocketConfiguration s = new SocketConfiguration();
        InetSocketAddress addr = new InetSocketAddress(0);
        s.setBindAddress(addr.getHostName());
        s.setPortNumber(addr.getPort());
        s.setProtocol(WireProtocol.teiid);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.addTransport(s);
        this.es.start(config);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        Connection conn = null;
        try {
            TeiidDriver driver = new TeiidDriver();
            conn = driver.connect("jdbc:teiid:test@mm://" + addr.getHostName() + ":" + ((SocketListener)this.es.transports.get(0)).getPort(), null);
            ResultSet rs = conn.createStatement().executeQuery("select * from helloworld");
            rs.next();
            Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteODBCTrasport() throws Exception {
        SocketConfiguration s = new SocketConfiguration();
        InetSocketAddress addr = new InetSocketAddress(0);
        s.setBindAddress(addr.getHostName());
        s.setPortNumber(addr.getPort());
        s.setProtocol(WireProtocol.pg);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.addTransport(s);
        this.es.start(config);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        Connection conn = null;
        try {
            Driver d = new Driver();
            Properties p = new Properties();
            p.setProperty("user", "testuser");
            p.setProperty("password", "testpassword");
            conn = d.connect("jdbc:postgresql://" + addr.getHostName() + ":" + ((SocketListener)this.es.transports.get(0)).getPort() + "/test", p);
            ResultSet rs = conn.createStatement().executeQuery("select * from helloworld");
            rs.next();
            Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testXMLDeployFails() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model><translator name=\"foo\" type=\"h2\"></translator></vdb>".getBytes()));
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testXMLDeployFails1() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\"><source/></model><translator name=\"foo\" type=\"h2\"></translator></vdb>".getBytes()));
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testDeploymentError() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testValidationOrder() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1");
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("a");
        mmd2.setModelType(Model.Type.VIRTUAL);
        mmd2.setSchemaSourceType("ddl");
        mmd2.setSchemaText("create view v1 as select * from v");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1, mmd2});
        try {
            this.es.deployVDB("test2", new ModelMetaData[]{mmd2, mmd1});
            Assert.fail();
        }
        catch (VirtualDatabaseException e) {
            // empty catch block
        }
    }

    @Test
    public void testTransactions() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1; create virtual procedure proc () options (updatecount 2) as begin select * from v; end; create virtual procedure proc1 () as begin atomic select * from v; end; create virtual procedure proc2 (x integer) as begin atomic select 1; begin select 1/x; end exception e end; create virtual procedure proc3 (x integer) as begin begin atomic select 1; end create local temporary table x (y string); begin atomic select 1; end end;");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        s.execute("select 1");
        c.setAutoCommit(true);
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        Transaction txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc ()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc1()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("set autoCommitTxn on");
        s.execute("set noexec on");
        s.execute("select 1");
        Assert.assertFalse((boolean)s.getResultSet().next());
        s.execute("set autoCommitTxn off");
        s.execute("set noexec off");
        s.execute("call proc2(0)");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).rollback();
        tm.txnHistory.clear();
        tm.begin();
        try {
            c.setAutoCommit(false);
            s.execute("select 1");
            Assert.fail((String)"should fail since we aren't allowing a nested transaction");
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn, (VerificationMode)Mockito.times((int)0))).commit();
        tm.commit();
        c.setAutoCommit(true);
        tm.txnHistory.clear();
        s.execute("call proc3(0)");
        Assert.assertEquals((long)2L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn, (VerificationMode)Mockito.times((int)0))).registerSynchronization((Synchronization)Mockito.any());
    }

    @Test
    public void testMultiSourcePreparedDynamicUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v (i integer) OPTIONS (UPDATABLE true) as select 1; create trigger on v instead of update as for each row begin atomic IF (CHANGING.i)\nEXECUTE IMMEDIATE 'select \"new\".i'; end; ");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", null);
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("update v set i = ? where i = ?");
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
        ps.setInt(1, 3);
        ps.setInt(2, 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
    }

    @Test
    public void testMultiSourceMetadata() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create foreign table t (x string)");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", null);
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("select * from t");
        ResultSetMetaData metadata = ps.getMetaData();
        Assert.assertEquals((long)1L, (long)metadata.getColumnCount());
        mmd1.addProperty("multisource.addColumn", Boolean.TRUE.toString());
        this.es.undeployVDB("vdb");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        ps = c.prepareStatement("select * from t");
        metadata = ps.getMetaData();
        Assert.assertEquals((long)2L, (long)metadata.getColumnCount());
        mmd1.addProperty("multisource.columnName", "y");
        this.es.undeployVDB("vdb");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        ps = c.prepareStatement("select * from t");
        metadata = ps.getMetaData();
        Assert.assertEquals((long)2L, (long)metadata.getColumnCount());
        Assert.assertEquals((Object)"y", (Object)metadata.getColumnName(2));
    }

    @Test
    public void testMultiSourceMetadataMissingSource() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", (ExecutionFactory)new ExecutionFactory<Object, Object>(){

            public Object getConnection(Object factory) throws TranslatorException {
                return factory;
            }

            public void closeConnection(Object connection, Object factory) {
            }

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Assert.assertNotNull((Object)conn);
                Table t = metadataFactory.addTable("x");
                metadataFactory.addColumn("a", "string", (ColumnSet)t);
            }
        });
        this.es.addConnectionFactory("b", new Object());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", "a");
        mmd1.addSourceMapping("y", "t", "b");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testDynamicUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", (ExecutionFactory)new ExecutionFactory<Void, Void>(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean isSourceRequired() {
                return false;
            }

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Void connection) throws TranslatorException {
                Collection values = CollectorVisitor.collectObjects(Literal.class, (LanguageObject)command);
                Assert.assertEquals((long)2L, (long)values.size());
                for (Literal literal : values) {
                    Assert.assertFalse((boolean)(literal.getValue() instanceof Reference));
                }
                return new UpdateExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{1};
                    }
                };
            }
        });
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("accounts");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText(ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"dynamic_update.sql")));
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("update hello1 set SchemaName=? where Name=?");
        ps.setString(1, "test1223");
        ps.setString(2, "Columns");
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
    }

    @Test
    public void testStart() throws TranslatorException {
        this.es.addTranslator(MyEF.class);
        Assert.assertTrue((boolean)started);
    }

    @Test
    public void testGlobalTempTables() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setMaxResultSetCacheStaleness(0);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE global temporary table some_temp (col1 string, col2 time) options (updatable true);]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        PreparedStatement ps = c.prepareStatement("/*+ cache */ select * from some_temp");
        ResultSet rs = ps.executeQuery();
        Assert.assertFalse((boolean)rs.next());
        ConnectionImpl c1 = this.es.getDriver().connect("jdbc:teiid:test", null);
        c1.createStatement().execute("insert into some_temp (col1) values ('a')");
        PreparedStatement ps1 = c1.prepareStatement("/*+ cache */ select * from some_temp");
        ResultSet rs1 = ps1.executeQuery();
        Assert.assertTrue((boolean)rs1.next());
        rs = ps.executeQuery();
        Assert.assertFalse((boolean)rs.next());
        c.createStatement().execute("insert into some_temp (col1) values ('b')");
        rs = ps.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        rs = c.createStatement().executeQuery("select * from some_temp");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        rs = c1.createStatement().executeQuery("select * from some_temp");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
    }

    @Test
    public void testMaxRows() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setMaxResultSetCacheStaleness(0);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE virtual procedure proc (out col1 string result) returns TABLE (r1 string) as begin col1 = 'a'; select 'b' union all select 'c'; end;]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        CallableStatement cs = c.prepareCall("{? = call proc()}");
        ResultSet rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(1);
        cs.setFetchSize(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs = c.prepareCall("/*+ cache */ {? = call proc()}");
        cs.setMaxRows(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(0);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
    }

    @Test
    public void testSourceLobUnderTxn() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setMaxResultSetCacheStaleness(0);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        final AtomicBoolean closed = new AtomicBoolean();
        this.es.addTranslator("foo", new ExecutionFactory(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                return new ResultSetExecution(){
                    private boolean returned;

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                        closed.set(true);
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (this.returned) {
                            return null;
                        }
                        this.returned = true;
                        ArrayList<SQLXMLImpl> result = new ArrayList<SQLXMLImpl>(1);
                        result.add(new SQLXMLImpl(new InputStreamFactory(){

                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream(new byte[DataTypeManager.MAX_LOB_MEMORY_BYTES + 1]);
                            }
                        }));
                        return result;
                    }
                };
            }
        });
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\"><source name=\"foo\" translator-name=\"foo\"/><metadata type=\"DDL\"><![CDATA[CREATE foreign table x (y xml);]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from x");
        rs.next();
        Assert.assertFalse((boolean)closed.get());
        s.close();
        Assert.assertTrue((boolean)closed.get());
    }

    @Test
    public void testUndeploy() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model type=\"VIRTUAL\" name=\"test\"><metadata type=\"DDL\"><![CDATA[CREATE view x as select 1;]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        Assert.assertTrue((boolean)c.isValid(10));
        this.es.undeployVDB("test");
        Assert.assertTrue((!c.isValid(10) ? 1 : 0) != 0);
    }

    @Test
    public void testQueryTimeout() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.addTranslator("foo", new ExecutionFactory(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return super.createResultSetExecution(command, executionContext, metadata, connection);
            }
        });
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\"><source name=\"foo\" translator-name=\"foo\"/><metadata type=\"DDL\"><![CDATA[CREATE foreign table x (y xml);]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        s.setQueryTimeout(1);
        try {
            s.execute("select * from x");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"57014", (Object)e.getSQLState());
        }
    }

    @Test
    public void testMultipleEmbeddedServerInOneVM() throws TranslatorException {
        this.es.addTranslator(MyEFES1.class);
        this.es.start(new EmbeddedConfiguration());
        Assert.assertTrue((boolean)isES1started);
        EmbeddedServer es2 = new EmbeddedServer();
        es2.start(new EmbeddedConfiguration());
        es2.addTranslator(MyEFES2.class);
        Assert.assertTrue((boolean)isES2started);
        es2.stop();
    }

    public static class MyEFES2
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            isES2started = true;
        }
    }

    public static class MyEFES1
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            isES1started = true;
        }
    }

    public static class MyEF
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            started = true;
        }
    }

    public static final class MockTransactionManager
    implements TransactionManager {
        ThreadLocal<Transaction> txns = new ThreadLocal();
        List<Transaction> txnHistory = new ArrayList<Transaction>();

        public Transaction suspend() throws SystemException {
            Transaction result = this.txns.get();
            this.txns.remove();
            return result;
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            Transaction result = this.txns.get();
            if (result == null) {
                throw new IllegalStateException();
            }
            result.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.rollback();
        }

        public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.checkNull(true);
            this.txns.set(tobj);
        }

        private Transaction checkNull(boolean isNull) {
            Transaction t = this.txns.get();
            if (!isNull && t == null || isNull && t != null) {
                throw new IllegalStateException();
            }
            return t;
        }

        public Transaction getTransaction() throws SystemException {
            return this.txns.get();
        }

        public int getStatus() throws SystemException {
            Transaction t = this.txns.get();
            if (t == null) {
                return 6;
            }
            return t.getStatus();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.commit();
        }

        public void begin() throws NotSupportedException, SystemException {
            this.checkNull(true);
            Transaction t = (Transaction)Mockito.mock(Transaction.class);
            this.txnHistory.add(t);
            this.txns.set(t);
        }

        public void reset() {
            this.txnHistory.clear();
            this.txns = new ThreadLocal();
        }
    }
}

