/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import org.teiid.client.security.ILogon;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.core.BundleUtil;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.crypto.DhKeyGenerator;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.logging.LogManager;
import org.teiid.net.CommunicationException;
import org.teiid.net.socket.Handshake;
import org.teiid.net.socket.Message;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientInstance;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ObjectEncoder;
import org.teiid.transport.ServerWorkItem;

public class SocketClientInstance
implements ChannelListener,
ClientInstance {
    private final ObjectChannel objectSocket;
    private Cryptor cryptor;
    private ClientServiceRegistryImpl csr;
    private boolean usingEncryption;
    private DhKeyGenerator keyGen;
    private DQPWorkContext workContext = new DQPWorkContext();

    public SocketClientInstance(ObjectChannel objectSocket, ClientServiceRegistryImpl csr, boolean isClientEncryptionEnabled) {
        this.objectSocket = objectSocket;
        this.csr = csr;
        this.workContext.setSecurityHelper(csr.getSecurityHelper());
        this.usingEncryption = isClientEncryptionEnabled;
        SocketAddress address = this.objectSocket.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)address;
            this.workContext.setClientAddress(addr.getAddress().getHostAddress());
            this.workContext.setClientHostname(addr.getHostName());
        }
    }

    @Override
    public void send(Message message, Serializable messageKey) {
        message.setMessageKey(messageKey);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.TRANSPORT", (int)5)) {
            LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)("send message: " + message));
        }
        this.objectSocket.write((Object)message);
    }

    @Override
    public Cryptor getCryptor() {
        return this.cryptor;
    }

    @Override
    public void exceptionOccurred(Throwable t) {
        if (this.objectSocket.isOpen() && !SocketClientInstance.isClosedException(t)) {
            Message m;
            ObjectEncoder.FailedWriteException fwe;
            if (this.workContext.getClientVersion().compareTo((Enum)DQPWorkContext.Version.EIGHT_4) >= 0 && t instanceof ObjectEncoder.FailedWriteException && (fwe = (ObjectEncoder.FailedWriteException)t).getObject() instanceof Message && !((m = (Message)fwe.getObject()).getMessageKey() instanceof ExceptionHolder)) {
                Message exception = new Message();
                exception.setContents((Object)m.getMessageKey());
                exception.setMessageKey((Serializable)new ExceptionHolder(fwe.getCause()));
                this.objectSocket.write((Object)exception);
                LogManager.log((int)SocketClientInstance.getLevel(t), (String)"org.teiid.TRANSPORT", (Throwable)t, (Object[])new Object[]{RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40113, new Object[0])});
                return;
            }
            if (this.workContext.getClientVersion().compareTo((Enum)DQPWorkContext.Version.EIGHT_6) >= 0) {
                Message exception = new Message();
                exception.setMessageKey((Serializable)new ExceptionHolder(t));
                this.objectSocket.write((Object)exception);
                LogManager.log((int)SocketClientInstance.getLevel(t), (String)"org.teiid.TRANSPORT", (Throwable)t, (Object[])new Object[]{RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40113, new Object[0])});
                return;
            }
        }
        int level = SocketClientInstance.getLevel(t);
        LogManager.log((int)level, (String)"org.teiid.TRANSPORT", (Throwable)(LogManager.isMessageToBeRecorded((String)"org.teiid.TRANSPORT", (int)5) || level < 3 ? t : null), (Object[])new Object[]{RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40114, new Object[]{t.getMessage()})});
        this.objectSocket.close();
    }

    static int getLevel(Throwable t) {
        if (!(t instanceof IOException)) {
            return 2;
        }
        if (ExceptionUtil.getExceptionOfType((Throwable)t, ClosedChannelException.class) != null || ExceptionUtil.getExceptionOfType((Throwable)t, SocketException.class) != null) {
            return 5;
        }
        if (SocketClientInstance.isClosedException(t)) {
            return 5;
        }
        return 3;
    }

    private static boolean isClosedException(Throwable t) {
        if (!(t instanceof IOException)) {
            return false;
        }
        String message = t.getMessage();
        return !(t.getCause() != null && t.getCause() != t || message == null || !message.equals("Connection reset by peer") && !message.equals("Broken pipe"));
    }

    @Override
    public void onConnection() throws CommunicationException {
        Handshake handshake = new Handshake();
        handshake.setAuthType(this.csr.getAuthenticationType());
        if (this.usingEncryption) {
            byte[] publicKey;
            this.keyGen = new DhKeyGenerator();
            try {
                publicKey = this.keyGen.createPublicKey();
            }
            catch (CryptoException e) {
                throw new CommunicationException((BundleUtil.Event)RuntimePlugin.Event.TEIID40051, (Throwable)e);
            }
            handshake.setPublicKey(publicKey);
        }
        this.objectSocket.write((Object)handshake);
    }

    @Override
    public void disconnected() {
        if (this.workContext.getSessionId() != null) {
            this.workContext.runInContext(new Runnable(){

                @Override
                public void run() {
                    try {
                        SocketClientInstance.this.csr.getClientService(ILogon.class).logoff();
                    }
                    catch (Exception e) {
                        LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)e, (Object)"Exception closing client instance");
                    }
                }
            });
        }
    }

    private void receivedHahdshake(Handshake handshake) throws CommunicationException {
        String clientVersion = handshake.getVersion();
        this.workContext.setClientVersion(DQPWorkContext.Version.getVersion((String)clientVersion));
        if (this.usingEncryption) {
            byte[] returnedPublicKey = handshake.getPublicKey();
            if (returnedPublicKey == null) {
                throw new CommunicationException((BundleUtil.Event)RuntimePlugin.Event.TEIID40052, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40052, new Object[0]));
            }
            try {
                this.cryptor = this.keyGen.getSymmetricCryptor(returnedPublicKey, "08.03".compareTo(clientVersion) > 0, SocketClientInstance.class.getClassLoader());
            }
            catch (CryptoException e) {
                throw new CommunicationException((BundleUtil.Event)RuntimePlugin.Event.TEIID40053, (Throwable)e);
            }
            this.keyGen = null;
        } else {
            this.cryptor = new NullCryptor();
        }
    }

    @Override
    public void receivedMessage(Object msg) throws CommunicationException {
        if (msg instanceof Message) {
            this.processMessagePacket((Message)msg);
        } else if (msg instanceof Handshake) {
            this.receivedHahdshake((Handshake)msg);
        }
    }

    private void processMessagePacket(Message packet) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.TRANSPORT", (int)5)) {
            LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)("processing message:" + packet));
        }
        if (this.workContext.getSecurityHelper() != null) {
            this.workContext.getSecurityHelper().clearSecurityContext();
        }
        ServerWorkItem work = new ServerWorkItem(this, packet.getMessageKey(), packet, this.csr);
        this.workContext.runInContext((Runnable)work);
    }

    @Override
    public void shutdown() throws CommunicationException {
        this.objectSocket.close();
    }

    @Override
    public DQPWorkContext getWorkContext() {
        return this.workContext;
    }
}

