/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.util.Properties;
import javax.security.auth.Subject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.core.util.Base64;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.security.SecurityHelper;
import org.teiid.services.SessionServiceImpl;
import org.teiid.transport.LogonImpl;

public class TestLogonImpl {
    SessionServiceImpl ssi;

    @Before
    public void setup() {
        this.ssi = new SessionServiceImpl();
        this.ssi.setSecurityHelper((SecurityHelper)new DoNothingSecurityHelper(){

            public Subject getSubjectInContext(String securityDomain) {
                if (securityDomain.equals("SC")) {
                    return new Subject();
                }
                return null;
            }
        });
    }

    @Test
    public void testLogonResult() throws Exception {
        SessionService ssi = (SessionService)Mockito.mock(SessionService.class);
        Mockito.stub((Object)ssi.getAuthenticationType(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).toReturn((Object)AuthenticationType.USERPASSWORD);
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        String userName = "Fred";
        String applicationName = "test";
        Properties p = new Properties();
        p.setProperty("user", userName);
        p.setProperty("ApplicationName", applicationName);
        p.setProperty("VirtualDatabaseName", "x");
        p.setProperty("VirtualDatabaseVersion", "1");
        SessionMetadata session = new SessionMetadata();
        session.setUserName(userName);
        session.setApplicationName(applicationName);
        session.setSessionId(String.valueOf(1));
        session.setSessionToken(new SessionToken(1L, userName));
        Mockito.stub((Object)ssi.createSession("x", "1", AuthenticationType.USERPASSWORD, userName, null, applicationName, p)).toReturn((Object)session);
        LogonImpl impl = new LogonImpl(ssi, "fakeCluster");
        LogonResult result = impl.logon(p);
        Assert.assertEquals((Object)userName, (Object)result.getUserName());
        Assert.assertEquals((Object)String.valueOf(1), (Object)result.getSessionID());
    }

    @Test
    public void testLogonAuthenticationType() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.addProperty("gss-pattern", "GSS");
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.setSecurityDomain("SC");
        this.ssi.setAuthenticationType(AuthenticationType.USERPASSWORD);
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        Properties p = this.buildProperties("fred", "name");
        LogonImpl impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
        LogonResult result = impl.logon(p);
        Assert.assertEquals((Object)"fred@SC", (Object)result.getUserName());
        this.ssi.setAuthenticationType(AuthenticationType.USERPASSWORD);
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        p = this.buildProperties("fred", "name");
        impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
        result = impl.logon(p);
        Assert.assertEquals((Object)"fred@SC", (Object)result.getUserName());
        this.ssi.setAuthenticationType(AuthenticationType.USERPASSWORD);
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        p = this.buildProperties("GSS", "name");
        FakeGssLogonImpl fimpl = new FakeGssLogonImpl((SessionService)this.ssi, "fakeCluster");
        fimpl.addToken("bytes".getBytes(), new Subject());
        p.put("KRB5TOKEN", "bytes".getBytes());
        result = fimpl.logon(p);
        Assert.assertEquals((Object)"GSS@SC", (Object)result.getUserName());
        this.ssi.setAuthenticationType(AuthenticationType.GSS);
        try {
            DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
            p = this.buildProperties("fred", "name");
            impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
            result = impl.logon(p);
            Assert.fail((String)"should have failed due server does not support USERPASSWORD");
        }
        catch (LogonException e) {
            // empty catch block
        }
    }

    @Test
    public void testLogonAuthenticationTypeByVDB() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        this.ssi.setVDBRepository(repo);
        this.ssi.setAuthenticationType(AuthenticationType.GSS);
        this.addVdb(repo, "name", "SC", AuthenticationType.USERPASSWORD.name());
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        Properties p = this.buildProperties("fred", "name");
        LogonImpl impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
        LogonResult result = impl.logon(p);
        Assert.assertEquals((Object)"fred@SC", (Object)result.getUserName());
        VDBMetaData metadata = this.addVdb(repo, "name1", "SC", AuthenticationType.USERPASSWORD.name());
        metadata.addProperty("gss-pattern", "GSS");
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
        p = this.buildProperties("fred", "name1");
        result = impl.logon(p);
        Assert.assertEquals((Object)"fred@SC", (Object)result.getUserName());
        p = this.buildProperties("GSS", "name1");
        FakeGssLogonImpl fimpl = new FakeGssLogonImpl((SessionService)this.ssi, "fakeCluster");
        fimpl.addToken("bytes".getBytes(), new Subject());
        p.put("KRB5TOKEN", "bytes".getBytes());
        result = fimpl.logon(p);
        Assert.assertEquals((Object)"GSS@SC", (Object)result.getUserName());
        try {
            p = this.buildProperties("GSS", "name");
            result = impl.logon(p);
            Assert.assertEquals((Object)"GSS@SC", (Object)result.getUserName());
        }
        catch (LogonException e) {
            // empty catch block
        }
        try {
            this.addVdb(repo, "name2", "SC", "GSS");
            DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
            impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
            p = this.buildProperties("fred", "name2");
            result = impl.logon(p);
            Assert.fail((String)"should have failed due server does not support USERPASSWORD");
        }
        catch (LogonException e) {
            // empty catch block
        }
        metadata.addProperty("gss-pattern", "GSS");
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        impl = new LogonImpl((SessionService)this.ssi, "fakeCluster");
        p = this.buildProperties(null, "name1");
        result = impl.logon(p);
        Assert.assertEquals((Object)"anonymous@SC", (Object)result.getUserName());
    }

    private Properties buildProperties(String userName, String vdbName) {
        Properties p = new Properties();
        if (userName != null) {
            p.setProperty("user", userName);
        }
        p.setProperty("ApplicationName", "test");
        p.setProperty("VirtualDatabaseName", vdbName);
        p.setProperty("VirtualDatabaseVersion", "1");
        return p;
    }

    private VDBMetaData addVdb(VDBRepository repo, String name, String sc, String authenticationType) {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName(name);
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB(name, (Object)"1")).toReturn((Object)vdb);
        vdb.addProperty("security-domain", sc);
        vdb.addProperty("authentication-type", authenticationType);
        return vdb;
    }

    class FakeGssLogonImpl
    extends LogonImpl {
        public FakeGssLogonImpl(SessionService service, String clusterName) {
            super(service, clusterName);
        }

        public void addToken(byte[] token, Subject securityContext) {
            this.gssServiceTickets.put(Base64.encodeBytes((byte[])FakeGssLogonImpl.MD5((byte[])token)), securityContext);
        }
    }
}

