/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.infinispan;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.transaction.TransactionMode;
import org.teiid.cache.Cache;
import org.teiid.logging.LogManager;

public class InfinispanCache<K, V>
implements Cache<K, V> {
    protected AdvancedCache<K, V> cacheStore;
    private final String name;
    private ClassLoader classloader;
    private boolean transactional;

    public InfinispanCache(org.infinispan.Cache<K, V> cacheStore, String cacheName, ClassLoader classloader) {
        assert (cacheStore != null);
        this.cacheStore = cacheStore.getAdvancedCache();
        TransactionMode transactionMode = this.cacheStore.getCacheConfiguration().transaction().transactionMode();
        this.transactional = transactionMode == TransactionMode.TRANSACTIONAL;
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Added", transactionMode, "infinispan cache", cacheName});
        this.name = cacheName;
        this.classloader = classloader;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public V get(K key) {
        return (V)this.cacheStore.with(this.classloader).get(key);
    }

    public V put(K key, V value) {
        return (V)this.cacheStore.with(this.classloader).put(key, value);
    }

    public V put(K key, V value, Long ttl) {
        if (ttl != null) {
            return (V)this.cacheStore.with(this.classloader).put(key, value, ttl.longValue(), TimeUnit.MILLISECONDS);
        }
        return (V)this.cacheStore.with(this.classloader).put(key, value);
    }

    public V remove(K key) {
        return (V)this.cacheStore.with(this.classloader).remove(key);
    }

    public int size() {
        return this.cacheStore.with(this.classloader).size();
    }

    public void clear() {
        this.cacheStore.with(this.classloader).clear();
    }

    public String getName() {
        return this.name;
    }

    public Set<K> keySet() {
        return this.cacheStore.with(this.classloader).keySet();
    }
}

