/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.gss.MakeGSS;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.LocalProfile;
import org.teiid.logging.LogManager;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.Handshake;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.vdb.runtime.VDBKey;

public class LocalServerConnection
implements ServerConnection {
    private static final String TEIID_RUNTIME_CONTEXT = "teiid/queryengine";
    private LogonResult result;
    private boolean shutdown;
    private ClientServiceRegistry csr;
    private DQPWorkContext workContext = new DQPWorkContext();
    private Properties connectionProperties;
    private boolean passthrough;
    private boolean derived;
    private static String serverVersion = new Handshake().getVersion();
    private Method cancelMethod;

    public static String jndiNameForRuntime(String embeddedTransportName) {
        return "teiid/queryengine/" + embeddedTransportName;
    }

    public LocalServerConnection(Properties connectionProperties, boolean useCallingThread) throws CommunicationException, ConnectionException {
        this.connectionProperties = connectionProperties;
        this.csr = this.getClientServiceRegistry(connectionProperties.getProperty("transportName", "local"));
        DQPWorkContext context = (DQPWorkContext)connectionProperties.get(LocalProfile.DQP_WORK_CONTEXT);
        if (context == null) {
            String vdbVersion = connectionProperties.getProperty("VirtualDatabaseVersion");
            String vdbName = connectionProperties.getProperty("VirtualDatabaseName");
            VDBKey key = new VDBKey(vdbName, (Object)vdbVersion);
            if (!key.isAtMost()) {
                int waitForLoad = PropertiesUtils.getIntProperty((Properties)connectionProperties, (String)"loginTimeout", (int)-1);
                waitForLoad = waitForLoad == -1 ? PropertiesUtils.getIntProperty((Properties)connectionProperties, (String)"waitForLoad", (int)-1) : (waitForLoad *= 1000);
                if (waitForLoad != 0) {
                    this.csr.waitForFinished(key, waitForLoad);
                }
            }
            this.workContext.setSecurityHelper(this.csr.getSecurityHelper());
            this.workContext.setUseCallingThread(useCallingThread);
            this.workContext.setSecurityContext(this.csr.getSecurityHelper().getSecurityContext());
            this.authenticate();
            this.passthrough = Boolean.valueOf(connectionProperties.getProperty("PassthroughAuthentication", "false"));
        } else {
            this.derived = true;
            this.workContext = context;
            this.result = new LogonResult(context.getSessionToken(), context.getVdbName(), null);
            this.passthrough = true;
        }
        try {
            this.cancelMethod = DQP.class.getMethod("cancelRequest", Long.TYPE);
        }
        catch (SecurityException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    protected ClientServiceRegistry getClientServiceRegistry(String transport) {
        try {
            InitialContext ic = new InitialContext();
            return (ClientServiceRegistry)ic.lookup(LocalServerConnection.jndiNameForRuntime(transport));
        }
        catch (NamingException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40067, (Throwable)e);
        }
    }

    public synchronized void authenticate() throws ConnectionException, CommunicationException {
        block12: {
            Object previousSecurityContext = this.workContext.getSecurityHelper().associateSecurityContext(this.workContext.getSession().getSecurityContext());
            try {
                this.logoff();
            }
            finally {
                this.workContext.getSecurityHelper().associateSecurityContext(previousSecurityContext);
            }
            this.workContext.setSecurityContext(previousSecurityContext);
            try {
                this.result = this.getService(ILogon.class).logon(this.connectionProperties);
                AuthenticationType type = (AuthenticationType)this.result.getProperty("authType");
                if (type == null) break block12;
                if (type == AuthenticationType.GSS) {
                    try {
                        this.result = MakeGSS.authenticate((ILogon)this.getService(ILogon.class), (Properties)this.connectionProperties);
                        break block12;
                    }
                    catch (LogonException e) {
                        if (!this.passthrough) {
                            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40150, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40150, new Object[0]));
                        }
                        throw e;
                    }
                }
                throw new LogonException((BundleUtil.Event)JDBCPlugin.Event.TEIID20034, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20034, new Object[]{type}));
            }
            catch (LogonException e) {
                throw new ConnectionException((Throwable)e);
            }
            catch (TeiidComponentException e) {
                if (e.getCause() instanceof CommunicationException) {
                    throw (CommunicationException)e.getCause();
                }
                throw new CommunicationException((BundleUtil.Event)RuntimePlugin.Event.TEIID40069, (Throwable)e);
            }
        }
    }

    public <T> T getService(final Class<T> iface) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, new InvocationHandler(){
            boolean logon;
            {
                this.logon = iface.equals(ILogon.class);
            }

            @Override
            public Object invoke(Object arg0, final Method arg1, final Object[] arg2) throws Throwable {
                if (LocalServerConnection.this.shutdown) {
                    throw ExceptionUtil.convertException((Method)arg1, (Throwable)new TeiidComponentException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40074, new Object[0])));
                }
                try {
                    if (LocalServerConnection.this.derived) {
                        LocalServerConnection.this.workContext.setDerived(true);
                    }
                    if (!(!LocalServerConnection.this.passthrough || this.logon || arg1.equals(LocalServerConnection.this.cancelMethod) || LocalServerConnection.this.workContext.getSession().isClosed() || LocalServerConnection.this.workContext.getSession().getSecurityDomain() == null || LocalServerConnection.sameSubject(LocalServerConnection.this.workContext))) {
                        LogManager.logInfo((String)"org.teiid.SECURITY", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40115, new Object[]{LocalServerConnection.this.workContext.getSession().getSessionId()}));
                        LocalServerConnection.this.authenticate();
                    }
                    final Object service = LocalServerConnection.this.csr.getClientService(iface);
                    Object object = LocalServerConnection.this.workContext.runInContext((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return arg1.invoke(service, arg2);
                        }
                    });
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                catch (Throwable e) {
                    throw ExceptionUtil.convertException((Method)arg1, (Throwable)e);
                }
                finally {
                    LocalServerConnection.this.workContext.setDerived(false);
                }
            }
        }));
    }

    public static boolean sameSubject(DQPWorkContext workContext) {
        Object currentContext = workContext.getSecurityHelper().getSecurityContext();
        if (currentContext != null) {
            Subject currentUser = workContext.getSecurityHelper().getSubjectInContext(workContext.getSecurityDomain());
            if (workContext.getSubject() != null && currentUser != null && workContext.getSubject().equals(currentUser)) {
                return true;
            }
            if (currentUser == null && workContext.getSubject() == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isOpen(long msToTest) {
        if (this.shutdown) {
            return false;
        }
        try {
            ResultsFuture result = this.getService(ILogon.class).ping();
            result.get(msToTest, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void close() {
        this.shutdown(true);
    }

    private void shutdown(boolean logoff) {
        if (this.shutdown) {
            return;
        }
        if (logoff) {
            this.logoff();
        }
        this.shutdown = true;
    }

    private void logoff() {
        if (this.derived) {
            return;
        }
        try {
            ResultsFuture writeFuture = this.getService(ILogon.class).logoff();
            if (writeFuture != null) {
                writeFuture.get(5000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LogonResult getLogonResult() {
        return this.result;
    }

    public boolean isSameInstance(ServerConnection conn) throws CommunicationException {
        return conn instanceof LocalServerConnection;
    }

    public void cleanUp() {
    }

    public boolean supportsContinuous() {
        return true;
    }

    public DQPWorkContext getWorkContext() {
        return this.workContext;
    }

    public boolean isLocal() {
        return true;
    }

    public void addListener(VDBLifeCycleListener listener) {
        VDBRepository repo = this.csr.getVDBRepository();
        if (repo != null) {
            repo.addListener(listener);
        }
    }

    public void removeListener(VDBLifeCycleListener listener) {
        VDBRepository repo = this.csr.getVDBRepository();
        if (repo != null) {
            repo.removeListener(listener);
        }
    }

    public String getServerVersion() {
        return serverVersion;
    }
}

