/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Base64;
import org.teiid.core.util.LRUCache;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.logging.LogManager;
import org.teiid.net.CommunicationException;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;

public class LogonImpl
implements ILogon {
    private SessionService service;
    private String clusterName;
    protected Map<String, Object> gssServiceTickets = Collections.synchronizedMap(new LRUCache());

    public LogonImpl(SessionService service, String clusterName) {
        this.service = service;
        this.clusterName = clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogonResult logon(Properties connProps) throws LogonException {
        String vdbName = connProps.getProperty("VirtualDatabaseName");
        String vdbVersion = connProps.getProperty("VirtualDatabaseVersion");
        String user = connProps.getProperty("user", "anonymous");
        boolean onlyAllowPassthrough = Boolean.valueOf(connProps.getProperty("PassthroughAuthentication", "false"));
        AuthenticationType authType = AuthenticationType.USERPASSWORD;
        if (!onlyAllowPassthrough) {
            authType = this.service.getAuthenticationType(vdbName, vdbVersion, user);
        }
        if (connProps.get("KRB5TOKEN") != null) {
            if (authType == AuthenticationType.GSS) {
                LogonResult logonResult;
                block11: {
                    Object previous = null;
                    boolean assosiated = false;
                    SecurityHelper securityHelper = this.service.getSecurityHelper();
                    try {
                        byte[] krb5Token = (byte[])connProps.get("KRB5TOKEN");
                        Object securityContext = this.gssServiceTickets.remove(Base64.encodeBytes((byte[])LogonImpl.MD5(krb5Token)));
                        if (securityContext == null) {
                            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40054, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40054, new Object[0]));
                        }
                        previous = securityHelper.associateSecurityContext(securityContext);
                        assosiated = true;
                        logonResult = this.logon(connProps, krb5Token, AuthenticationType.GSS, user);
                        if (!assosiated) break block11;
                    }
                    catch (Throwable throwable) {
                        if (assosiated) {
                            securityHelper.associateSecurityContext(previous);
                        }
                        throw throwable;
                    }
                    securityHelper.associateSecurityContext(previous);
                }
                return logonResult;
            }
        } else if (authType == AuthenticationType.GSS) {
            DQPWorkContext.Version v = DQPWorkContext.getWorkContext().getClientVersion();
            if (v.compareTo((Enum)DQPWorkContext.Version.EIGHT_7) >= 0) {
                LogonResult result = new LogonResult();
                result.addProperty("authType", (Object)authType);
                return result;
            }
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40149, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40149, new Object[0]));
        }
        if (!AuthenticationType.USERPASSWORD.equals((Object)authType)) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40055, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40055, new Object[]{authType}));
        }
        return this.logon(connProps, null, AuthenticationType.USERPASSWORD, user);
    }

    private LogonResult logon(Properties connProps, byte[] krb5ServiceTicket, AuthenticationType authType, String user) throws LogonException {
        String vdbName = connProps.getProperty("VirtualDatabaseName");
        String vdbVersion = connProps.getProperty("VirtualDatabaseVersion");
        String applicationName = connProps.getProperty("ApplicationName");
        String password = connProps.getProperty("password");
        Credentials credential = null;
        if (password != null) {
            credential = new Credentials(password.toCharArray());
        }
        try {
            SessionMetadata sessionInfo = this.service.createSession(vdbName, vdbVersion, authType, user, credential, applicationName, connProps);
            if (connProps.get(GSSCredential.class.getName()) != null) {
                LogonImpl.addCredentials(sessionInfo.getSubject(), (GSSCredential)connProps.get(GSSCredential.class.getName()));
            }
            this.updateDQPContext(sessionInfo);
            if (DQPWorkContext.getWorkContext().getClientAddress() == null) {
                sessionInfo.setEmbedded(true);
            }
            LogonResult result = new LogonResult(sessionInfo.getSessionToken(), sessionInfo.getVDBName(), this.clusterName);
            if (krb5ServiceTicket != null) {
                result.addProperty("KRB5TOKEN", (Object)krb5ServiceTicket);
            }
            return result;
        }
        catch (LoginException e) {
            throw new LogonException((Throwable)e);
        }
        catch (SessionServiceException e) {
            throw new LogonException((Throwable)e);
        }
    }

    public LogonResult neogitiateGssLogin(Properties connProps, byte[] serviceTicket, boolean createSession) throws LogonException {
        String user;
        String vdbVersion;
        String vdbName = connProps.getProperty("VirtualDatabaseName");
        AuthenticationType authType = this.service.getAuthenticationType(vdbName, vdbVersion = connProps.getProperty("VirtualDatabaseVersion"), user = connProps.getProperty("user"));
        if (!AuthenticationType.GSS.equals((Object)authType)) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40055, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40055, new Object[]{"Kerberos"}));
        }
        GSSResult result = this.neogitiateGssLogin(serviceTicket, vdbName, vdbVersion, user);
        if (!result.isAuthenticated() || !createSession) {
            LogonResult logonResult = new LogonResult(new SessionToken(0L, "temp"), "internal", "internal");
            logonResult.addProperty("KRB5TOKEN", (Object)result.getServiceToken());
            logonResult.addProperty("KRB5_CONTEXT_ESTABLISHED", (Object)new Boolean(result.isAuthenticated()));
            if (result.isAuthenticated()) {
                logonResult.addProperty(GSSCredential.class.getName(), (Object)result.getDelegationCredential());
            }
            return logonResult;
        }
        connProps.setProperty("user", result.getUserName());
        connProps.put("KRB5TOKEN", result.getServiceToken());
        if (result.getDelegationCredential() != null) {
            connProps.put(GSSCredential.class.getName(), result.getDelegationCredential());
        }
        LogonResult logonResult = this.logon(connProps);
        return logonResult;
    }

    public GSSResult neogitiateGssLogin(byte[] serviceTicket, String vdbName, String vdbVersion, String user) throws LogonException {
        GSSResult result;
        try {
            result = this.service.neogitiateGssLogin(user, vdbName, vdbVersion, serviceTicket);
        }
        catch (LoginException e) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40014, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40014, new Object[0]));
        }
        if (result == null) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40014, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40014, new Object[0]));
        }
        if (result.isAuthenticated()) {
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object)"Kerberos context established");
            this.gssServiceTickets.put(Base64.encodeBytes((byte[])LogonImpl.MD5(result.getServiceToken())), result.getSecurityContext());
        }
        return result;
    }

    protected static byte[] MD5(byte[] content) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(content);
        }
        catch (NoSuchAlgorithmException e) {
            return content;
        }
    }

    private String updateDQPContext(SessionMetadata s) {
        String sessionID = s.getSessionId();
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        workContext.setSession(s);
        return sessionID;
    }

    public ResultsFuture<?> logoff() throws InvalidSessionException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        if (workContext.getSession().isClosed() || workContext.getSessionId() == null) {
            if (workContext.getSessionId() != null) {
                this.updateDQPContext(new SessionMetadata());
            }
            return ResultsFuture.NULL_FUTURE;
        }
        try {
            this.service.closeSession(workContext.getSessionId());
        }
        finally {
            this.updateDQPContext(new SessionMetadata());
        }
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
        String id = DQPWorkContext.getWorkContext().getSessionId();
        if (id != null) {
            this.service.pingServer(id);
        }
        LogManager.logTrace((String)"org.teiid.SECURITY", (Object)"Ping", (Object)id);
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> ping(Collection<String> sessions) throws TeiidComponentException, CommunicationException {
        for (String string : sessions) {
            try {
                this.service.pingServer(string);
            }
            catch (InvalidSessionException invalidSessionException) {}
        }
        return ResultsFuture.NULL_FUTURE;
    }

    public void assertIdentity(SessionToken checkSession) throws InvalidSessionException, TeiidComponentException {
        if (checkSession == null) {
            this.updateDQPContext(new SessionMetadata());
            return;
        }
        SessionMetadata sessionInfo = null;
        try {
            sessionInfo = this.service.validateSession(checkSession.getSessionID());
        }
        catch (SessionServiceException e) {
            throw new TeiidComponentException((BundleUtil.Event)RuntimePlugin.Event.TEIID40062, (Throwable)e);
        }
        if (sessionInfo == null) {
            throw new InvalidSessionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40063);
        }
        SessionToken st = sessionInfo.getSessionToken();
        if (!st.equals((Object)checkSession)) {
            throw new InvalidSessionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40064);
        }
        this.updateDQPContext(sessionInfo);
    }

    public SessionService getSessionService() {
        return this.service;
    }

    static void addCredentials(final Subject subject, final GSSCredential cred) {
        if (System.getSecurityManager() == null) {
            subject.getPrivateCredentials().add(cred);
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                subject.getPrivateCredentials().add(cred);
                return null;
            }
        });
    }
}

