/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColourGradient {
    private Colour fromColour;
    private Colour toColour;
    private final Pattern htmlColourPattern = Pattern.compile("(?i)^#?([a-f0-9][a-f0-9]?)([a-f0-9][a-f0-9]?)([a-f0-9][a-f0-9]?)$");

    public ColourGradient(String gradientFrom, String gradientTo) {
        this.fromColour = this.parseHtmlColour(gradientFrom);
        this.toColour = this.parseHtmlColour(gradientTo);
    }

    private Colour parseHtmlColour(String htmlColourCode) {
        Matcher m = this.htmlColourPattern.matcher(htmlColourCode);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid colour code: " + htmlColourCode);
        }
        int red = this.getColourValue(m.group(1));
        int green = this.getColourValue(m.group(2));
        int blue = this.getColourValue(m.group(3));
        return new Colour(red, green, blue);
    }

    private int getColourValue(String code) {
        return Integer.parseInt(code + (code.length() == 1 ? code : ""), 16);
    }

    public String getHtmlColour(Colour colour) {
        return String.format("#%02x%02x%02x", colour.red, colour.green, colour.blue);
    }

    public List<String> calculateGradient(int steps) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getHtmlColour(this.fromColour));
        Colour stepColour = new Colour(this.fromColour.red, this.fromColour.green, this.fromColour.blue);
        for (int i = 1; i < steps - 1; ++i) {
            stepColour.red = this.nudgeColour(this.fromColour.red, this.toColour.red, steps, i);
            stepColour.green = this.nudgeColour(this.fromColour.green, this.toColour.green, steps, i);
            stepColour.blue = this.nudgeColour(this.fromColour.blue, this.toColour.blue, steps, i);
            values.add(this.getHtmlColour(stepColour));
        }
        values.add(this.getHtmlColour(this.toColour));
        return values;
    }

    private int nudgeColour(int start, int end, int steps, int step) {
        return Math.round((float)start + (float)(end - start) / ((float)(steps - 1) * 1.0f) * (float)step);
    }

    class Colour {
        public int red;
        public int green;
        public int blue;

        public Colour(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }
}

