/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.util.Files;
import org.jboss.testharness.impl.util.Reflections;

public class ResourceDescriptorImpl
implements ResourceDescriptor {
    private final String name;
    private final URL source;

    public ResourceDescriptorImpl(String name, InputStream source) throws IOException {
        this.name = name;
        File file = File.createTempFile(ResourceDescriptorImpl.class.getName(), null);
        file.deleteOnExit();
        Files.copy(source, file);
        this.source = file.toURI().toURL();
    }

    public ResourceDescriptorImpl(String name, URL source) {
        this.name = name;
        this.source = source;
    }

    public ResourceDescriptorImpl(String name, String source) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("Unable to have a null resource");
        }
        this.source = Reflections.loadResource(source);
        if (this.source == null) {
            throw new IllegalArgumentException("Unable to load file for " + source);
        }
    }

    public String getName() {
        return this.name;
    }

    public URL getSource() {
        return this.source;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceDescriptorImpl) {
            ResourceDescriptor that = (ResourceDescriptor)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + " (" + this.source.toString() + ")";
    }
}

