/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging.ear;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifact;
import org.jboss.testharness.impl.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarArtifactDescriptor {
    public static final String APPLICATION_XML_DESTINATION = "META-INF/application.xml";
    private final TCKArtifact ejbJar;
    private final TCKArtifact war;
    private final TCKArtifact ear;

    public static TCKArtifact createEarArtifact(TCKArtifact ear, TCKArtifact ejbJar, TCKArtifact war) {
        EarArtifactDescriptor descriptor = new EarArtifactDescriptor(ear, ejbJar, war);
        return descriptor.ear;
    }

    private EarArtifactDescriptor(TCKArtifact ear, TCKArtifact ejbJar, TCKArtifact war) {
        this.ear = ear;
        this.ejbJar = ejbJar;
        this.war = war;
        this.ear.setExtrasSupported(false);
        this.war.setExtrasSupported(false);
        this.war.setLibrariesSupported(false);
        this.war.skipIncludeXmlConfig(true);
        this.ear.getClasses().clear();
        this.ear.setExtension(".ear");
        this.ear.setLibrariesSupported(true);
        this.ear.setLibrariesRoot("lib");
        this.ear.skipIncludeXmlConfig(true);
        this.ejbJar.initialize();
        this.war.initialize();
        this.createContainingJars();
        this.createApplicationXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKArtifact createApplicationXml() {
        InputStream applicationXml = null;
        try {
            applicationXml = EarArtifactDescriptor.getApplicationXml(this.ear.getDeclaringClass());
            this.ear.getResources().add(new ResourceDescriptorImpl(APPLICATION_XML_DESTINATION, applicationXml));
        }
        catch (IOException e) {
            LogUtil.logger().log(Level.WARNING, "Error generating ear", e);
        }
        finally {
            if (applicationXml != null) {
                try {
                    applicationXml.close();
                }
                catch (IOException e1) {
                    LogUtil.logger().log(Level.WARNING, "Error generating ear", e1);
                }
            }
        }
        return this.ear;
    }

    public TCKArtifact getEarJar() {
        return this.ear;
    }

    public TCKArtifact getEjbJar() {
        return this.ejbJar;
    }

    public TCKArtifact getWar() {
        return this.war;
    }

    public String toString() {
        return "EarArtifactDescriptor{ejbJar=" + this.ejbJar + ", war=" + this.war + ", ear=" + this.ear + '}';
    }

    public void createContainingJars() {
        try {
            this.ear.getResources().add(new ResourceDescriptorImpl(this.war.getDefaultName(), this.war.getJar()));
            this.ear.getResources().add(new ResourceDescriptorImpl(this.ejbJar.getDefaultName(), this.ejbJar.getJar()));
        }
        catch (IOException ioe) {
            String message = "Error generating ear";
            LogUtil.logger().log(Level.WARNING, message, ioe);
            throw new RuntimeException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getApplicationXml(Class<?> declaringClass) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter writer = new PrintWriter(os);
            ((Writer)writer).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ((Writer)writer).write("<application xmlns=\"http://java.sun.com/xml/ns/javaee\" \n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\t\txsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd\" \n\t\tversion=\"5\">\n\n");
            ((Writer)writer).write("\t<display-name>JSR-99 TCK: " + declaringClass.getName() + "</display-name>\n\n");
            ((Writer)writer).write("\t<module>\n\t\t<web>\n\t\t\t<web-uri>" + declaringClass.getName() + ".war</web-uri>\n" + "\t\t\t<context-root>/" + declaringClass.getName() + "</context-root>\n" + "\t\t</web>\n" + "\t</module>\n\n");
            ((Writer)writer).write("\t<module>\n\t\t<ejb>" + declaringClass.getName() + ".jar</ejb>\n" + "\t</module>\n\n");
            ((Writer)writer).write("</application>\n");
            ((Writer)writer).flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            os.close();
        }
    }
}

