/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.logging;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.logging.XLevel;

/**
 * A LoggingPlugin that configures a console log4j appender without looking
 * for any configuration resources.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class Log4jConsoleLoggingPlugin extends LoggingPlugin
{
   public void enableTrace(String name)
   {
      Logger.getLogger(name).setLevel(XLevel.TRACE);
   }

   public void setUp() throws Exception
   {
      // Setup a console appender
      BasicConfigurator.resetConfiguration();
      PatternLayout layout = new PatternLayout("%r %-5p [%c{1}] %m%n");
      ConsoleAppender appender = new ConsoleAppender(layout);
      BasicConfigurator.configure(appender);
   }

}
